C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdlin(s1,s2,s3,s4,smax,
     1                  a1,a2,a3,a4,f1,f2,f3,f4,fs,df,fnyquist,
     2                  t1,t2,t3,t4,nsamp_in,nt,dtmsec,istart,iend,
     3                  nfft,dx,dy,dz,dsamp,dmsamp,dxh,dyh,dzh,prew,
     4                  mx,my,wx,wy,xtaper,ytaper,reject,verbose,
     5                  fwd_drt,rev_drt,depth_section,lerr,nx,ny,
     6                  xazim,yazim,xazimh,yazimh,toeplitz,svd,rhofilt,
     7                  startline,endline,starttrace,endtrace,dang,
     8                  pmin,pmax,qmin,qmax,true_dip,
     9                  p1,p2,p3,p4,q1,q2,q3,q4,
     a                  nxinterp,nyinterp,dxi,dyi,interpolate,
     b                  kximin,kximax,kyimin,kyimax)
c
      integer ipwr(4)
      integer argis
      integer    startline,endline,starttrace,endtrace
      logical    verbose,reject,depth_section
      logical    fwd_drt,rev_drt
      logical    toeplitz,svd,rhofilt
      logical    hdrexist,interpolate,true_dip
      data           undefined/-99999./
c
      if(.not. rev_drt) then
c_______________________________________________________________
c        these command line arguments will be passed via the line
c        header when using the -R option.
c_______________________________________________________________
         call argr4('-ilhw',wx,-1.,-1.)
         call argr4('-clhw',wy,-1.,-1.)
         call argr4 ('-f1',f1,0.,0.)
         call argr4 ('-f4',f4,0.,0.)
         call argr4('-ildm',dx,undefined,undefined)
         call argr4('-cldm',dy,undefined,undefined)
         call argi4('-startline',startline,1,1)
         call argi4('-endline',endline,ny+1,ny+1)   
         call argi4('-starttrace',starttrace,1,1)
         call argi4('-endtrace',endtrace,nx+1,nx+1)   
c_______________________________________________________________
c        old command line arguments.
c_______________________________________________________________
         call argi4('-ilhap',mx,0,0)
         call argi4('-clhap',my,0,0)
      else
         starttrace=1
         endtrace=nx+1
         startline=1
         endline=ny+1
      endif
c_______________________________________________________________
c     read in remaining command line parameters.
c     none of these will be used when running the -R option.
c_______________________________________________________________
      call argr4('-smax',smax,0.,0.)
      call argr4('-pmin',pmin,0.,0.)                 
      call argr4('-pmax',pmax,0.,0.)                 
      call argr4('-qmin',qmin,0.,0.)                 
      call argr4('-qmax',qmax,0.,0.)                 
      call argr4('-dz',dz,undefined,undefined)
      call argr4('-s1',s1,undefined,undefined)
      call argr4('-s2',s2,undefined,undefined)
      call argr4('-s3',s3,undefined,undefined)
      call argr4('-s4',s4,undefined,undefined)
      call argr4('-a1',a1,undefined,undefined)
      call argr4('-a2',a2,undefined,undefined)
      call argr4('-a3',a3,undefined,undefined)
      call argr4('-a4',a4,undefined,undefined)
      call argr4('-p1',p1,undefined,undefined)
      call argr4('-p2',p2,undefined,undefined)
      call argr4('-p3',p3,undefined,undefined)
      call argr4('-p4',p4,undefined,undefined)
      call argr4('-q1',q1,undefined,undefined)
      call argr4('-q2',q2,undefined,undefined)
      call argr4('-q3',q3,undefined,undefined)
      call argr4('-q4',q4,undefined,undefined)
      call argr4('-prew',prew,0.,0.)
      call argr4('-dang',dang,2.,2.)
      call argr4('-t1',t1,0.,0.)  
      call argr4('-t2',t2,0.,0.)  
      call argr4('-t3',t3,0.,0.)  
      call argr4('-t4',t4,0.,0.)  
      call argr4 ('-fs',fs,0.,0.)
      call argr4 ('-f2',f2,0.,0.)
      call argr4 ('-f3',f3,0.,0.)
      call argr4('-xtaper',xtaper,0.,0.)
      call argr4('-ytaper',ytaper,0.,0.)
      call argr4('-ilazim',xazim,undefined,undefined)
      call argr4('-clazim',yazim,undefined,undefined)
      call argi4('-ilinterp',nxinterp,1,1)
      call argi4('-clinterp',nyinterp,1,1)

      if(xazim .eq. undefined)
     1  call argr4('-xazim',xazim,undefined,undefined)
      if(yazim .eq. undefined)
     1  call argr4('-yazim',yazim,undefined,undefined)
      verbose=(argis('-V') .gt. 0)
      toeplitz=(argis( '-toeplitz' ) .gt. 0 )
      svd=(argis( '-svd' ) .gt. 0 )
      rhofilt=(argis( '-rho' ) .gt. 0 )
      reject=(argis('-reject') .gt. 0)
c
      ierror=0
      starttrace=max(starttrace-1,0)
      endtrace=min(endtrace-1,nx)
      startline=max(startline-1,0)
      endline=min(endline-1,ny)
c
      if(smax .gt. 0.) then 
c_______________________________________________________________
c        mutes applied as true dip/azimuth
c_______________________________________________________________
         true_dip=.true.
         pmin=-smax
         pmax=+smax
         qmin=-smax
         qmax=+smax
      else
c_______________________________________________________________
c        mutes applied as apparent dips in x and y.
c_______________________________________________________________
         true_dip=.false.
         smax=2.*max(pmax,-pmin,qmax,-qmin)
         if(pmin .eq. 0. .and. pmax .eq. 0. .and. qmin .eq. 0.
     1        .and. qmax .eq. 0.) then
            write(lerr,*) 'command line error!'
            write(lerr,*) 'at least one of the following command'
     1               //' line arguments must be nonzero:'
            write(lerr,*) '-smax,-pmin,-pmax,-qmin,-qmax'
            ierror=ierror+1
         endif
      endif
      if(true_dip) then
         if(s1 .eq. undefined) then
            s1=0.
         elseif(s1 .lt. 0) then 
            write(lerr,*) 'command line error!'
            write(lerr,*) 's1 = ',s1,' must be non-zero!'
            ierror=ierror+1
         endif 
         if(s2 .eq. undefined) then
            s2=s1   
         elseif(s2 .lt. 0) then 
            write(lerr,*) 'command line error!'
            write(lerr,*) 's2 = ',s2,' must be non-zero!'
            ierror=ierror+1
         endif 
         if(s4 .eq. undefined) then
            s4=smax
         elseif(s4 .lt. 0) then 
            write(lerr,*) 'command line error!'
            write(lerr,*) 's4 = ',s4,' must be non-zero!'
            ierror=ierror+1
         endif 
         if(s3 .eq. undefined) then
            s3=s4   
         elseif(s3 .lt. 0) then 
            write(lerr,*) 'command line error!'
            write(lerr,*) 's3 = ',s3,' must be non-zero!'
            ierror=ierror+1
         endif 
         if(s1 .gt. s2 .or. s2 .gt. s3 .or. s3 .gt. s4) then
            write(lerr,*) 'command line error!'
            write(lerr,*) 's1,s2,s3,s4 are out of order!'
            write(lerr,'(a10,f10.6)') 's1',s1,'s2',s2,
     1                                's3',s3,'s4',s4
            ierror=ierror+1
         endif
c
         if(a1 .eq. undefined) then
            a1=-361.
         endif
         if(a2 .eq. undefined) then
            a2=a1
         elseif(a2 .lt. a1) then
            write(lerr,*) 'command line error!'
            write(lerr,*) 'a2 = ',a2,' must be greater than a1 = ',a1
            ierror=ierror+1
         endif
         if(a4 .eq. undefined) then
            a4=+361.
         elseif(a4 .lt. a3) then
            write(lerr,*) 'command line error!'
            write(lerr,*) 'a4 = ',a4,' must be greater than a3 = ',a3
            ierror=ierror+1
         endif
         if(a3 .eq. undefined) then
            a3=a4
         elseif(a3 .lt. a2) then
            write(lerr,*) 'command line error!'
            write(lerr,*) 'a3 = ',a3,' must be greater than a2 = ',a2
            ierror=ierror+1
         endif
      else
         if(p1 .eq. undefined) then
            p1=pmin
         elseif(p1 .lt. pmin) then
            p1=pmin
         endif
         if(p2 .eq. undefined) then
            p2=p1
         elseif(p2 .lt. p1) then
            p2=p1
         endif
         if(p4 .eq. undefined) then
            p4=pmax
         elseif(p4 .eq. undefined) then
            p4=pmax
         endif
         if(p3 .eq. undefined) then
            p3=p4
         elseif(p3 .lt. p4) then
            p3=p4
         endif
         if(p1 .gt. p2 .or. p2 .gt. p3 .or. p3 .gt. p4) then
            write(lerr,*) 'command line error!'
            write(lerr,*) 'p1,p2,p3,p4 are out of order!'
            write(lerr,'(a10,f10.6)') 'p1',p1,'p2',p2,
     1                                'p3',p3,'p4',p4
            ierror=ierror+1
         endif
         if(q1 .eq. undefined) then
            q1=qmin
         elseif(q1 .lt. qmin) then
            q1=qmin
         endif
         if(q2 .eq. undefined) then
            q2=q1
         elseif(q2 .lt. q1) then
            q2=q1
         endif
         if(q4 .eq. undefined) then
            q4=qmax
         elseif(q4 .lt. 0) then
            q4=qmax
         endif
         if(q3 .eq. undefined) then
            q3=q4
         elseif(q3 .lt. q4) then
            q3=q4
         endif
         if(q1 .gt. q2 .or. q2 .gt. q3 .or. q3 .gt. q4) then
            write(lerr,*) 'command line error!'
            write(lerr,*) 'q1,q2,q3,q4 are out of order!'
            write(lerr,'(a10,f10.6)') 'q1',q1,'q2',q2,
     1                                'q3',q3,'q4',q4
            ierror=ierror+1
         endif
      endif
c
      if(dz .ge. 0.) then     
         depth_section=.true.
         if(dz .le. 0.) then 
c______________________________________________________________________
c           dz is obtained from the seismic line header.
c______________________________________________________________________
            if(dzh .gt. 0.) then
               dz=dzh
            else
               write(lerr,*) 'command line error!'
               write(lerr,*) 'dz = ',dz,' must be positive!'           
               write(lerr,*) 'dzh (from Dz1000) = ',dzh,' non positive'
               ierror=ierror+1
            endif
         endif
      else
         depth_section=.false.
      endif
c______________________________________________________________________
c     dmsamp is the sample increment in msec, m or ft.
c     dsamp  is the sample increment in sec, km or kft.
c______________________________________________________________________
      if(depth_section) then
         dmsamp=dz
      else
         dmsamp=dtmsec
      endif
      dsamp=.001*dmsamp
c
      if(t1 .eq. 0.) then
         t1=0.
      endif
      if(t2 .eq. 0.) then
         t2=t1
      elseif(t2 .lt. t1) then
         write(lerr,*) 'command line error!'
         write(lerr,*) 't2 = ',t2,' must be greater than t1 = ',t1
         ierror=ierror+1
      endif
      if(t4 .eq. 0.) then
         t4=(nsamp_in-1)*dmsamp
      elseif(t4 .lt. t3) then
         write(lerr,*) 'command line error!'
         write(lerr,*) 't4 = ',t4,' must be greater than t3 = ',t3
         ierror=ierror+1
      endif
      if(t3 .eq. 0.) then
         t3=t4
      elseif(t4 .lt. t3) then
         write(lerr,*) 'command line error!'
         write(lerr,*) 't4 = ',t4,' must be greater than t3 = ',t3
         ierror=ierror+1
      endif
c_______________________________________________________________________
c     pull defaults from the line header.
c_______________________________________________________________________
      if(xazimh .ne. 0. .and. yazimh .ne. 0.) then
         hdrexist=.true.
      else
         hdrexist=.false.
      endif
      if(xazim .eq. undefined) then
         if(hdrexist) then
            xazim=xazimh
         else
            xazim=0.
         endif
      endif
      if(yazim .eq. undefined) then
         if(hdrexist) then
            yazim=yazimh
         else
            yazim=90.   
         endif
      endif
      if(dx .eq. undefined) dx=dxh
      if(dy .le. undefined) dy=dyh
      if(dx .le. 0.) then
         Write(lerr,*) 'error! ',
     1                 'positive non-zero dx must be entered '
     2                 //'after -ildm on command line!'
         write(lerr,*) 'dx = ',dx
         ierror=ierror+1
      endif
      if(dy .le. 0.) then
         write(lerr,*) 'error! ',
     1                 ' positive non-zero dy must be entered '
     3                 //'after -cldm on command line!'
         write(lerr,*) 'dy = ',dy
         ierror=ierror+1
      endif

c______________________________________________________________________
c     set up a default analysis window.
c______________________________________________________________________
      if(mx .eq. 0) then
         if(wx .lt. 0.) then
            wx=5.*dx
         endif
         mx=nint(wx/dx)
      else
         wx=mx*dx
      endif
      if(my .eq. 0) then
         if(wy .lt. 0.) then
            wy=5.*dy
         endif
         my=nint(wy/dy)
      else
         wy=my*dy
      endif
      if(mx .eq. 0.) xtaper=0.
      if(my .eq. 0.) ytaper=0.
      istart=nint(t1/dmsamp)
      iend=nint(t4/dmsamp)
      nt=iend-istart+1
c______________________________________________________________________
c     calculate length of mixed radix fft that fits lenwnd best.
c     limit to radices 2,3 and 5 to allow use both cray scilib
c     and qtc routines.
c______________________________________________________________________
      lenwindow=1.1*nt
      call nrfft(lenwindow,5,nfft,ipwr)
c________________________________________________________________
c      set uninitialized frequencies to defaults.
c________________________________________________________________
       df=1./(nfft*dsamp)
       fnyquist=(nfft/2-1)*df
       fnyquist=1./(2.*dsamp)
       if(f4 .eq. 0.) then
          f4=fnyquist
          write(lerr,*)'Upper freq limit defaulted to ',f4
       endif
       if(f1 .eq. 0.) then
          f1=df
       endif
       if(f2 .eq. 0.) then
          f2=f1
       endif
       if(f3 .eq. 0.) then
          f3=f4
       endif
c________________________________________________________________
c      check that frequencies are in ascending order
c________________________________________________________________
       if(f1 .lt.0.) then
          write(lerr,*) 'command line error! f1 = ',f1,
     1                 ' less than 0.'
          ierror=ierror+1
       endif
       if(f2 .lt. f1) then
          write(lerr,*) 'command line error! f2 = ',f2,
     1                 ' less than f1 = ',f1
          ierror=ierror+1
       endif
       if(f3 .lt. f2) then
          write(lerr,*) 'command line error! f3 = ',f3,
     1                 ' less than f2 = ',f2
          ierror=ierror+1
       endif
       if(f4 .lt. f3) then
          write(lerr,*) 'command line error! f4 = ',f4,
     1                 ' less than f3 = ',f3
          ierror=ierror+1
       endif
       if(f4 .gt.fnyquist) then
          write(lerr,*) 'error! f4 exceeds fnyquist'
          write(lerr,*) 'f4 = ',f4
          write(lerr,*) 'fnyquist = ',fnyquist
          ierror=ierror+1
       endif
c
      if(prew .eq. 0.) then
         prew=.05
      elseif(prew .lt. 0.) then
         write(lerr,*) 'command line error!'
         write(lerr,*) 'prew = ',prew,' must be non-zero!'
         ierror=ierror+1
      else
         prew=.01*prew
      endif
c_________________________________________________________________
c     calculate interpolation grid.
c_________________________________________________________________
      if(nxinterp .lt. 1) then
         write(lerr,*) 'nxinterp must be greater than 0'
         ierror=ierror+1
      else
         dxi=dx/nxinterp
         kximax=nxinterp/2
         if(mod(nxinterp,2) .eq. 1) then
            kximin=-kximax
         else
            kximin=-kximax+1
         endif
      endif
      if(nyinterp .lt. 1) then
         write(lerr,*) 'nyinterp must be greater than 0'
         ierror=ierror+1
      else
         dyi=dy/nyinterp
         kyimax=nyinterp/2
         if(mod(nyinterp,2) .eq. 1) then
            kyimin=-kyimax
         else
            kyimin=-kyimax+1
         endif
      endif
      if(kximin .ne. kximax .or. kyimin .ne. kyimax) then
         interpolate=.true.
      else
         interpolate=.false.
      endif
c
      if(ierror .gt. 0) then
         write(lerr,*) 'program aborted due to ',ierror, 
     1                 ' command line errors!'
         call exit(666)
         close(lerr)
      endif

      return
      end
 

