C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine invert(r,rc,r2,rinv,z,iperm,rcond,
     1                  sigma,re,ru,rv,rwork,rho,
     2                  nx,np,prew,toeplitz,svd,taup,stderr,lerr)
c_________________________________________________________________
c     calculate least square inverse of matrix [R] 
c_________________________________________________________________
      complex  r(nx,np)           
      complex  rc(np,nx)
      complex  r2(np,np)
      complex  rinv(np,nx)
      integer  iperm(np)
      complex  z(np)
      complex  sigma(*),re(*),rwork(*)
      complex  ru(nx,np),rv(np,nx)     
      integer  stderr
      logical  svd,toeplitz,taup
c
      if(taup) then
c_________________________________________________________________
c        approximate the inverse by the adjoint equations.
c_________________________________________________________________
          do 12100 jp=1,np
           do 11100 jx=1,nx
            rinv(jp,jx)=rho*rc(jp,jx)
11100      continue
12100     continue
c_________________________________________________________________
c                            *
c        calculate [R2] = [R] [R]
      elseif(svd) then
c_________________________________________________________________
c        invert by using singular value decomposition.
c_________________________________________________________________
         job=11
         call csvdc(r,nx,nx,np,sigma,re,ru,nx,rv,np,
     1              rwork,job,info)
         if(info .ne. 0) then
            write(lerr,*) 'incorrect eigenvalues in decomposing rx1d!'
            write(lerr,*) 'all singular values zero in routine getr.'
            write(lerr,*) 'info = ',info
            write(lerr,'(a10,2a24)') 'k','sigma(k)','re(k)'
            write(lerr,'(i10,2e12.3)') (k,sigma(k),re(k),
     1                   k=1,min(np,nx))
         endif
c_________________________________________________________________
c        calculate condition number.
c_________________________________________________________________
         rcond=abs(sigma(min(np,nx))/sigma(1))
c_________________________________________________________________
c        marquardt-levinson prewhitening
c          sigma(k)=1./(sigma(k)+fact)
c_________________________________________________________________
         fact=prew*abs(sigma(1))
         nsvd=0
         do 31000 k=1,min(np,nx)
          if(abs(sigma(k)) .lt. fact) then
             sigma(k)=(0.,0.)
          else
             nsvd=nsvd+1
             sigma(k)=1./sigma(k)
          endif
31000    continue
c_________________________________________________________________
c        inversion.
c_________________________________________________________________
         do 61000 jx=1,nx
          do 51000 jp=1,np
           rinv(jp,jx)=(0.,0.)
           do 41000 k=1,min(np,nx)
            rinv(jp,jx)=rinv(jp,jx)
     1                   +rv(jp,k)*sigma(k)*conjg(ru(jx,k))
41000      continue
51000     continue
61000    continue
      else
c_________________________________________________________________
c        invert by forming the normal equations.
c       
c                    *            -1   *
c         [RINV]=([R] [R]+eps*[I])  [R] 
c
c_________________________________________________________________
c_________________________________________________________________
c                            *
c        calculate [R2] = [R] [R]
c_________________________________________________________________
         do 23000 jp=1,np
          do 22000 kp=1,np
           r2(jp,kp)=(0.,0.)
           do 21000 jx=1,nx
            r2(jp,kp)=r2(jp,kp)+rc(jp,jx)*r(jx,kp)
21000      continue
22000     continue
23000    continue
c_________________________________________________________________
c        calculate eps to be used in prewhitening.
c_________________________________________________________________
         rmax=0.
         do 30000 jp=1,np
          rmax=max(rmax,abs(r2(jp,jp)))
30000    continue
         eps=prew*rmax
c_________________________________________________________________
c        add prewhitening:
c
c                         *
c               [R2] = [R] [R]+eps*[I]
c_________________________________________________________________
         do 60000 jp=1,np
          r2(jp,jp)=r2(jp,jp)+eps
60000    continue
c_________________________________________________________________
c        calculate 
c
c                            *            -1   *
c               [RINV] = ([R] [R]+eps*[I])  [R]
c
c_________________________________________________________________
        if(toeplitz) then
           do 72000 jx=1,nx
            do 71000 jp=1,np
             rv(jp,1)=r2(jp,1)
71000       continue
            call clev(np,rv,rc(1,jx),rinv(1,jx),z)
72000      continue
        else
           call cgeco(r2,np,np,iperm,rcond,z)
           job=0
           do 80000 jx=1,nx
            do 75000 jp=1,np
             rinv(jp,jx)=rc(jp,jx)
75000       continue
            call cgesl(r2,np,np,iperm,rinv(1,jx),job)
80000      continue
        endif
      endif
c
      return
      end
