C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdgather(tracebuf,ibuffer2,trheader,uin,
     1                    uorig,udata,live,luin,ler,nx,nxpad,
     2                    l_StaCor,eof,iy,my,mx,
     3                    ITRWRD,lntrhd,nt,nfft,ifl,ifh,lerr,
     4                    rtabf,itabf,rtabi,fwgt,
     5                    itabi,work,twgt,ky,
     6                    lenrtab,lenitab,lenwork,initfftf,
     7                    istart,iend,nt_orig,  
     8                    l_LinInd,l_DphInd,ifmt_LinInd,ln_LinInd,
     9                    ifmt_DphInd,ln_DphInd,
     a                    ifmt_StaCor,ln_StaCor)
c
c_______________________________________________________________
c     Warning! ibuffer2 and tracebuf are equivalenced by the 
c     calling sequence.
c_______________________________________________________________
      integer*2 trheader(lntrhd,0:nx,-my:my)
      integer*2 ibuffer2(lntrhd)
      real      tracebuf(-ITRWRD:nt_orig)
      real      uorig(0:nt_orig,0:nx,0:my)
      real      twgt(0:nt),fwgt(ifl:ifh)              
      real      udata(0:nfft-1,-mx:nx+mx)
      complex   uin(ifl:ifh,-mx:nx+mx,-my:my)
      logical   live(-mx:nx+mx,-my:+my)
      logical   eof,forward 
c_______________________________________________________________
c     fourier transform table and work arrays.
c_______________________________________________________________
      real       rtabf(lenrtab)
      integer    itabf(lenitab)
      real       rtabi(lenrtab)
      integer    itabi(lenitab)
      real       work(lenwork)
c_______________________________________________________________________
c     read in the seismic record.
c_______________________________________________________________________
      eof=.false.
      if(nxpad .gt. 0) then
c_______________________________________________________________________
c        read in the first (-nxpad,-1) traces of the seismic record.
c_______________________________________________________________________
         do 13000 jx=-nxpad,-1
          nbytes_in=0
          call rtape(luin,tracebuf,nbytes_in)
          if(nbytes_in .le. 0) then
             eof=.true.
             return
          endif
          if(jx .ge. -mx) then
             call saver2(ibuffer2 ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                   istatic, 1)
             if(istatic .eq. 30000) then
                live(jx,iy)=.false.
                call vclr(udata(0,jx),1,nfft)
             else
                live(jx,iy)=.true.
                call vmov(tracebuf(istart),1,udata(0,jx),1,nt+1)           
                call vclr(udata(nt+1,jx),1,nfft-1-nt)
             endif
          endif
13000    continue
      else
c___________________________________________________________________
c        flag nonexistent traces as dead.
c__________________________________________________________________
         do 14000 jx=-mx,-1
          live(jx,iy)=.false.
          call vclr(udata(0,jx),1,nfft)
14000    continue
      endif
c_______________________________________________________________________
c     read in the next (0,nx) traces of the seismic record.
c_______________________________________________________________________
      do 40000 jx=0,nx       
       nbytes_in=0
       call rtape(luin,tracebuf,nbytes_in)
       if(nbytes_in .le. 0) then
          eof=.true.
          return
       endif
c_______________________________________________________________________
c      copy trace headers into trheader array.
c      copy entire data into uorig for possible 'reject' mode.
c      copy window of data into udata for fft.               
c_______________________________________________________________________
       do 11000 k=1,lntrhd
        trheader(k,jx,iy)=ibuffer2(k)
11000  continue
       call saver2(ibuffer2 ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1             istatic, 1)
       if(istatic .eq. 30000) then
          live(jx,iy)=.false.
          call vclr(udata(0,jx),1,nfft)
          call vclr(uorig(0,jx,ky),1,nt_orig+1)
       else
          live(jx,iy)=.true.    
          call vmov(tracebuf(0),1,uorig(0,jx,ky),1,nt_orig+1)           
          call vmov(tracebuf(istart),1,udata(0,jx),1,nt+1)           
          call vclr(udata(nt+1,jx),1,nfft-1-nt)
       endif
40000 continue
      if(nxpad .gt. 0) then
c_______________________________________________________________________
c        read in the last (nx+1,nx+mx) traces of the seismic record.
c_______________________________________________________________________
         do 83000 jx=nx+1,nx+nxpad
          nbytes_in=0
          call rtape(luin,tracebuf,nbytes_in)
          if(nbytes_in .le. 0) then
             eof=.true.
             return
          endif
          if(jx .le. nx+mx) then
             call saver2(ibuffer2 ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                   istatic, 1)
             if(istatic .eq. 30000) then
                live(jx,iy)=.false.
                call vclr(udata(0,jx),1,nfft)
             else
                live(jx,iy)=.true.
                call vmov(tracebuf(istart),1,udata(0,jx),1,nt+1)           
                call vclr(udata(nt+1,jx),1,nfft-1-nt)
             endif
          endif
83000    continue
      else
c___________________________________________________________________
c        flag nonexistent traces as dead.
c__________________________________________________________________
         do 84000 jx=nx+1,nx+mx
          live(jx,iy)=.false.
          call vclr(udata(0,jx),1,nfft)
84000    continue
      endif

c___________________________________________________________________
c     taper
c___________________________________________________________________
      do 46000 jt=0,nt       
       if(twgt(jt) .ne. 1.) then
          do 45000 jx=-mx,nx+mx
           udata(jt,jx)=twgt(jt)*udata(jt,jx)
45000     continue
       endif
46000 continue
c___________________________________________________________________
c     take fourier transform from t-x into omega-x space.
c___________________________________________________________________
      forward=.true.
      call rmmfft(udata(0,-mx),work,itabf,rtabf,forward,
     1            nfft,lenwork,lenitab,lenrtab,
     2            nfft,nx+1+2*mx,initfftf,lerr)
      initfftf=0
c___________________________________________________________________
c     copy transformed data into udata.   
c     udata(0,jp) maps to the real part of udata(0,jp)
c     udata(1,jp) maps to the imaginary part of udata(0,jp)
c___________________________________________________________________
      jbegin=2*ifl
      lenf=2*(ifh-ifl+1)
      do 60000 jx=-mx,nx+mx
       call vmov(udata(jbegin,jx),1,uin(ifl,jx,iy),1,lenf)  
60000 continue
      do 65000 jomega=ifl,ifh
       if(fwgt(jomega) .ne. 1.) then
          do 64000 jx=-mx,nx+mx
           uin(jomega,jx,iy)=fwgt(jomega)*uin(jomega,jx,iy)
64000     continue
       endif
65000 continue
c
      return
      end 
