C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine getradon(radon,p,ifl,ifh,df,np,
     1                     fstart,theta,cincr,fourier)

cinclude <f77/lhdrsz.h>

c_________________________________________________________________
c     calculate the radon transform matrix for a given value 
c     theta(x)
c
c     radon(omega,p,x)=exp{+i*(p*omega*theta(x))}
c_________________________________________________________________
      real     p(np)             
      complex  radon(ifl:ifh,np)
c     complex * 16  work
c     pointer  (wkwork, work(1))
      complex  cincr(np)
      complex  const
      logical  fourier
      ierr = 0
      iabort = 0
c
      if(fourier) then
c_________________________________________________________________
c        frequency invariant (x,k) fourier transform.         
c_________________________________________________________________
         do 10005 ip=1,np
          arg=-theta*p(ip)
          const=cmplx(cos(arg),sin(arg))
          do 10003 ifreq=ifl,ifh
           radon(ifreq,ip)=const
10003     continue
10005    continue
      else

c     nf = ifh-ifl+1
c     item = nf * np * 4 * SZSMPD
c     call galloc (wkwork, item, ierr, iabort)
c_________________________________________________________________
c     intialize first frequency and update vector.            
c_________________________________________________________________
         do 10000 ip=1,np       
          arg=-theta*p(ip)*fstart
          argincr=-theta*p(ip)*df   
          radon(ifl,ip)=cmplx(cos(arg),sin(arg))
          cincr(ip)=cmplx(cos(argincr),sin(argincr))
c      write(11,666)ip,theta,p(ip),arg,argincr,radon(ifl,ip),cincr(ip)
c666   format(i3,2x,f6.0,7f10.4)
10000    continue
c_________________________________________________________________
c        complete the coefficient matrix by a nonrecursive vector
c        multiply across parameters p.
c_________________________________________________________________
        do 30000 ifreq=ifl+1,ifh
         do 20000 ip=1,np
          radon(ifreq,ip)=radon(ifreq-1,ip)*cincr(ip)
20000     continue
30000    continue
c         call bldrad (ifl, ifh, nf, np, cincr, radon, work)
c         call gfree (wkwork)
      endif
c
      return
      end
