C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdparm(dmin,dmax,dx,verbos,amaxmem,nptaper,szsmpd,
     1                  lerr,ierror,regularize,interpolate,smooth,
     2                  lensmooth,restore_mute)
c 
      integer    argis
      integer    szsmpd
      logical    verbos
      logical    smooth           
      logical    regularize,interpolate,restore_mute                     
c
      data       undefined/1.23456e+12/
 
      ierror=0           
c
      call argr4 ('-dx',dx, 0.0 , 0.0 )
      call argr4 ('-dmin',dmin,0.,0.)               
      call argr4 ('-dmax',dmax,0.0,0.0)
      call argi4 ('-nttaper',nttaper,200,200)
      call argi4 ('-nptaper',nptaper,10,10)
      call argi4 ('-S',lensmooth,5,0)
      regularize = (argis('-R') .gt. 0)
      interpolate= (argis('-I') .gt. 0)
      restore_mute=.not. (argis('-nomute') .gt. 0)
      if(lensmooth .gt. 0) then
         smooth=.true.
         lensmooth=(lensmooth/2)*2+1
      else
         smooth=.false.
      endif
c________________________________________________________________________
c     force regularized data to ALWAYS be interpolated.
c________________________________________________________________________
      if(regularize) interpolate=.true.
      call argr4('-M',amaxmem,0.,0.)
      if(amaxmem .le. 0.) then
         if(szsmpd .eq. 4) then
c________________________________________________________________________
c           workstation architecture.
c           default to 16 Megabytes=4 Megawords
c________________________________________________________________________
            amaxmem=4.
         else
c________________________________________________________________________
c           supercomputer architecture.
c           default to 24 Megawords
c________________________________________________________________________
            amaxmem=24.
         endif
      endif
c
      if(regularize) then
         if(dx .le. 0.) then
            write(lerr,*) 'error in routine rdparm'
            write(lerr,*) 'regularization chosen by -R option'
            write(lerr,*) 'dx must be entered as a positive number!'
            write(lerr,*) 'dx = ',dx       
            ierror=ierror+1
         endif
         if(dmin .gt. dmax) then
            write(lerr,*) 'error in routine rdparm'
            write(lerr,*) 'regularization chosen by -R option'
            write(lerr,*) 'dmax cannot be less than dmin!'
            write(lerr,*) 'dmin = ',dmin
            write(lerr,*) 'dmax = ',dmax
            ierror=ierror+1
         endif
      endif
c
      return
      end
