C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine d3hsmg(a,iorda,iord,iord2,b)

c*************************************************************************
c     This subroutine fills in the symmetric matrix given by a column by
c     row multiplication of a two dimensional power series using a high
c     speed matrix generator.
c
c     Thompson, G.T., 1992, "The Grand Unified Theory of Least Squares",
c     Computers and Geosciences, Vol. 18, No. 7, pp. 815-822.
c
c**** Subroutine inputs
c
c     a = The vector of powers of one independent variable up to twice the
c         order of the matrix being filled.
c     iorda = The length of the vector, a.
c     iord = The order of the polynomial being tested.
c     iord2 = The number of coeficients in the polynomial being tested.
c
c**** Subroutine outputs
c
c     b = The symmetric matrix of normal equations.
c
c**** Subroutines required.
c
c     dmmove
c
c*************************************************************************

      real*8 a(iorda),b(iord2 * iord2)
      integer iorda,iord,iord2,i,j,nmove,icol,iloc,ilocb,isum,iscan,im1
      integer iord1

      iord1 = iord + 1
      icol = 1

      do i = 1,iord1

        im1 = i - 1

        do j = 1,i

          isum = 1

          do nmove = 1,iord1

            iscan = im1 + nmove
            iloc = iscan * (iscan - 1) / 2 + j
            ilocb = (icol - 1) * iord2 + isum
            call dmmove(nmove,a(iloc),b(ilocb))
            isum = isum + nmove

          enddo

          icol = icol + 1

        enddo

      enddo

      return
      end
