C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE DAGCM(LX,LW,AMP,X,G,idec)
C     A CONFIDENTIAL AMOCO SUBROUTINE
C                            FORTRAN BY KEN PEACOCK        7-19-74
C     DAGCM COMPUTES A MEDIAN GAIN TRACE FOR DIGITAL AUTOMATIC GAIN CONTROL.
C     INPUTS ARE...
C             LX, LENGTH OF X AND G.
C             LW, LENGTH OF ANALYSIS WINDOW, LW ODD.
C             AMP, AMPLITUDE THAT DAGC ACTION TRYS TO MAINTAIN
C             X, INPUT ARRAY.
C     OUTPUT IS...
C             G, GAIN TRACE.
C     PROGRAMMED FOR THE IBM 370/145 COMPUTER.
C     VERSION AS OF 9-24-75.
C     MODIFICATION BY STH 10/3/75
C     SUM=0.     NOW IS SUM=0.001
C
      DIMENSION X(1),G(1), work(8192)

      xmed = 0.0
      SUM=0.001
      LWD2 = LW/2
      ISTO = LWD2+1
      lwf = .1 * lw

      DO 1 I=1,ISTO
         work(i) = ABS(X(I))
1     continue
      call mdian2 (work, ISTO, xmed,idec)
         if (xmed .gt. 1.e-20) then
            g(1) =  amp/xmed
         else
            g(1) = 1.
         endif

      DO  5  I = 1, ISTO
          work(i) = ABS(X(I))
5     continue

      ino = 0
      DO 2 I=2,ISTO
         ino = ino + 1
         J = LWD2+I
         work(isto+ino) = ABS(X(J))
         call mdian2 (work, isto+ino, xmed,idec)
         if (xmed .gt. 1.e-20) then
            g(i) = amp/xmed
         else
            g(i) = 1.
         endif

    2 continue

      ISTA = ISTO+1
      ISTO = LX-LWD2
      LWD2P1=LWD2+1

      DO 3 I=ISTA,ISTO
         J = I-LWD2P1
         K = I+LWD2
         ii0 = 0
        do  10  ii = J, K
            ii0 = ii0 + 1
            work(ii0) = abs(x(ii))
10      continue
         call mdian2 (work, ii0, xmed,idec)
         if (xmed .gt. 1.e-20) then
            g(i) = amp/xmed
         else
            g(i) = 1.
         endif
    3 continue

      ISTA = ISTO+1
      ISTO = LX

      DO 4 I=ISTA, ISTO
      J = I-LWD2P1+1
         ino = 0
         do  40  ii = J, ISTO
             ino = ino + 1
             work(ino) = abs(x(ii))
40       continue
         if (ino .gt. 1) then
            call mdian2 (work, ino, xmed,idec)
         else
            xmed = amp/work(ino)
         endif
         if (xmed .gt. 1.e-20) then
            g(i) = amp/xmed
         else
            g(i) = 1.
         endif
    4 continue 

      do  50  i = 1, lwf
          g(lx-lwf+i) = g(lx-lwf)
50    continue

      RETURN
      END
