C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dcrfrm(m,n,a,alpha)

c**********************************************************************
c     This subroutine forms the crout array from a given m*n array
c
c     See Robinson,"Least Squares Regression Analysis in Terms of
c     Linear Algebra", page 51.
c
c**** Subroutine inputs
c
c     m = The number of rows in the input array
c     n = The number of columns in the input array
c     a = The input array
c
c**** Subroutine outputs
c
c     alpha = m * n crout array.
c
c***********************************************************************

      real*8 a(m * n),alpha(m * n),sum
      integer m,n,i,j,j1,mm,k,kp,km,il,lk,ik,l,kl,lj,kj,kk,koff,joff

c**********************************************************************
c     fill in the first vertical block
c**********************************************************************

      do i = 1,m

        alpha(i) = a(i)

      enddo

c**********************************************************************
c     fill in the first horizontal block
c     j1 = index of the first element in the jth. row 2 <= j <=n
c**********************************************************************

      j1 = m + 1

      do j = 2,n

        alpha(j1) = a(j1) / alpha(1)
        j1 = j1 + m

      enddo

c**********************************************************************
c     fill in the rest of the crout array.
c**********************************************************************

      if(n.lt.m) then

        mm = n

        else

        mm = m

      endif

c**********************************************************************
c     koff = the base element offset of the kth row 2 <= k <= mm.
c**********************************************************************

      koff = m

      do k = 2,mm

        kp = k + 1
        km = k - 1
        kk = koff + k

c**********************************************************************
c     fill in the kth. vertical block
c**********************************************************************

        do i = k,m

          sum = 0.0d0
          il = i

          do l = 1,km

            lk = koff + l
            sum = sum + alpha(il) * alpha(lk)
            il = il + m

          enddo

          ik = koff + i
          alpha(ik) = a(ik) - sum

        enddo

c**********************************************************************
c     fill in the kth. horizontal block
c     joff = the base element offset of the jth row k + 1 <= j <= n.
c**********************************************************************

        joff = koff + m

        do j = kp,n

          sum = 0.0d0
          kl = k

          do l = 1,km

            lj = joff + l
            sum = sum + alpha(kl) * alpha(lj)
            kl = kl + m

          enddo

          kj = joff + k
          alpha(kj) = (a(kj) - sum) / alpha(kk)
          joff = joff + m

        enddo

        koff = koff + m

      enddo

      return
      end
