C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dcrout(m,n,a,alpha,nsys,x)

c**********************************************************************
c     This subroutine solves nsys sets of m * m simultaneous equations
c     using the Crout method.
c     The matrix A comprises the m * m matrix of right hand sides
c     and the m * nsys matrix of left hand sides. that is, a is m * n
c     where n = m + nsys. the solution matrix is the m * nsys matrix, X
c
c     See Robinson,"Least Squares Regression Analysis in Terms of
c     Linear Algebra", page 51.
c
c**** Subroutine inputs
c
c     m = The number of unknowns in the simultaneous equations, the
c         number of rows in a.
c     n = The number of columns in a, where n = m + nsys.
c     a = The coefficient matrix, (m * n)
c     nsys = Number of sets of equations to be solved
c
c**** Subroutine outputs
c
c     alpha = The crout array of a.
c     x = m * nsys matrix of solutions to the simultaneous equations
c
c**** Subroutine required
c
c     dcrfrm
c
c***********************************************************************

      real*8 a(m * n),alpha(m * n),x(m * nsys),sum
      integer m,n,nsys,i,k,kp,l,kl,kj,it,mit,mj,kit,lit,itoff,joff,mp1
      integer mm1,m2,koff

c***********************************************************************
c     form the crout array, alpha
c***********************************************************************

      call dcrfrm(m,n,a,alpha)
      mp1 = m + 1
      mm1 = m - 1
      m2 = m * m

c**********************************************************************
c     carry out the back solution of the simultaneous equations.
c     itoff = the base offset of row it where      1 <= it <= nsys
c     joff = the base offset of row j where    m + 1 <= j <= m + nsys
c     koff = the base offset of row k where        m => k >= 1
c**********************************************************************

      mit = m
      itoff = 0
      joff = m2
      mj = joff + m

      do it = 1,nsys

        x(mit) = alpha(mj)
        k = mm1
        kp = m
        koff = m2 - m

        do i = 2,m

          sum = 0.0d0
          kl = koff + k

          do l = kp,m

            lit = itoff + l
            sum = sum + alpha(kl) * x(lit)
            kl = kl + m

          enddo

          kit = itoff + k
          kj = joff + k
          x(kit) = alpha(kj) - sum
          k = k - 1
          kp = kp - 1
          koff = koff - m

        enddo

        itoff = itoff + m
        joff = joff + m
        mit = mit + m
        mj = mj + m

      enddo

      return
      end
