C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dminsn(lx,x,xmin,index,axmin,indexa)

c*******************************************************************************
c     This subroutine finds the minimum and the smallest absolute
c     elements in an array with the corresponding index of their
c     locations. The sign of the elements is taken into consideration.
c     see Robinson, "Multichannel Time Series Analysis", page 21
c     This is the double precision version of subroutine "minsn" in
c     Robinson with the addition of the output of the element with the
c     minimum absolute value.
c
c**** Subroutine inputs
c
c     lx = The length of array x
c     x = The array under investigation
c
c**** Subroutine outputs
c
c     xmin = The smallest element in array x
c     index = The fortran subscript of the smallest element, xmin
c     axmin = The element with the smallest absolute value in array x
c     indexa = The fortran subscript of the element with the smallest
c              absolute value, axmin
c
c*******************************************************************************

      real*8 x(lx),xmin,axmin
      integer i,index,indexa,lx

      index = 1
      indexa = 1

      do i = 1,lx

        if(x(index).gt.x(i)) index = i
        if(dabs(x(indexa)).gt.dabs(x(i))) indexa = i

      enddo

      xmin = x(index)
      axmin = x(indexa)
      return
      end
