C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine dmmove(lx,x,y)

c*******************************************************************************
c     This subroutine copies lx values of array x into array y
c     see Robinson, "Multichannel Time Series Analysis", page 17.
c
c     This subroutine has a check to prevent premature overwriting when
c     the source array overlays the target.
c
c**** Subroutine inputs.
c
c     lx = the number of values to be moved.
c     x = the source array of the values.
c
c**** Subroutine outputs.
c
c     y = the target array that the values are moved into.
c
c*******************************************************************************

      real*8 x(lx),y(lx)
      integer lx,init,iend,istep,i

c*******************************************************************************
c     Determine the start and end of the loop to prevent overlap
c*******************************************************************************

      if (loc(x(1)).ge.loc(y(1))) then

        init = 1
        iend = lx
        istep = 1

        else if (loc(x(1)).lt.loc(y(1))) then

        init = lx
        iend = 1
        istep = -1

        else

        return

      endif

c*******************************************************************************
c     Move the elements.
c*******************************************************************************

      do i = init,iend,istep

        y(i) = x(i)

      enddo

      return
      end
