C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine pordmx(iopt,ndim,nn,maxin,iord,iord2,iord4,ierr)

c***********************************************************************
c     This subroutine determines the maximum order of polynomial that
c     can be fitted to data points in two, three, or four dimensions.
c
c**** Subroutine inputs
c
c     iopt = Option choice flag
c            iopt < 0  No scaling of the variables is carried out
c            iopt > 0  Scaling of the variables is carried out
c     ndim = The number of dimensions
c     nn = The number of input data points.
c     maxin = The maximum absolute input value.
c
c**** Subroutine outputs
c
c     iord = The maximum possible order of polynomial that can be fitted
c     iord2 = The number of coefficients in the maximum possible order
c             of polynomial that can be fitted
c     iord4 = iord2 * iord2
c     ierr = Error code on exit
c            ierr = 0   A polynomial can be fitted no error
c            ierr = 1   Insufficient data points.
c
c**** Subroutines required
c
c     pncoef
c
c***********************************************************************

      real*8 maxin
      integer iopt,ndim,nn,iord,iord2,iord4,ierr,logmax,depemax
      ierr = 0

c***********************************************************************
c     Find iord for two dimensional data
c***********************************************************************

      if(ndim.eq.2) then

        if(nn.lt.2) then

          goto 1

          else if(nn.ge.15) then

          iord = 14

          else

          iord = nn - 1

        endif

c***********************************************************************
c     Find iord for three dimensional data
c***********************************************************************

        else if(ndim.eq.3) then

        if(nn.lt.3) then

          goto 1

          else if(nn.ge.120) then

          iord = 14

          else

          iord = int((sqrt(9.0 + 8.0 * float(nn - 1)) - 3.0) / 2.0)

        endif

c***********************************************************************
c     Find iord for four dimensional data
c***********************************************************************

        else if(ndim.eq.4) then

        if(nn.lt.4) then

          goto 1

          else if(nn.ge.120) then

          iord = 7

          else if(nn.ge.84.and.nn.lt.120) then

          iord = 6

          else if(nn.ge.56.and.nn.lt.84) then

          iord = 5

          else if(nn.ge.35.and.nn.lt.56) then

          iord = 4

          else if(nn.ge.20.and.nn.lt.35) then

          iord = 3

          else if(nn.ge.10.and.nn.lt.20) then

          iord = 2

          else if(nn.ge.4.and.nn.lt.10) then

          iord = 1

        endif

      endif

c***********************************************************************
c     Check for limits of unscaled data.
c***********************************************************************

      if(iopt.lt.0) then

        logmax = int(dble(depemax(maxin)) / (2.0d0 * dlog10(maxin)))
        iord = min0(logmax,iord)

      endif

c***********************************************************************
c     Compute iord2
c***********************************************************************

      call pncoef(ndim,iord,iord2,iord4)
      return

c***********************************************************************
c     If insufficient points exit with error code = 1
c***********************************************************************

    1 iord = 0
      ierr = 1
      return
      end
