C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  Rearrange a Data Set
C
C**********************************************************************C
C
C rearrange READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C reads all the trc1's, all the trc2's, etc, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD )
      REAL        HEAD( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis
      CHARACTER   NAME * 9,  ntap * 100, otap * 100
#include <f77/pid.h>
      logical     verbos,rnum,query
 
      EQUIVALENCE ( ITR( 1), LHED(1), HEAD(1) )

      DATA     NAME /'REARRANGE'/
      DATA     LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA     obytes / 0 /
      DATA     verbos /.false./, rnum /.false./

c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?') .gt. 0 .or. argis('-h') .gt. 0)
      if( query ) then
          call help ()
          stop
      endif

c---------------------------------
c  open printout files
c---------------------------------
#include <f77/open.h>

c---------------------------------------------------------------
c  read program parameters from command line
c---------------------------------------------------------------
      call cmdln(ntap,otap,rnum,verbos)

C**********************************************************************C
C     open logical units
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C

      call getln( luin, ntap, 'r', 0)
      if (luin .eq. 0) then
         write(LERR,*)'REARRANGE: cannot pipe in'
         write(LERR,*)'rerun with input disk file:'
         write(LERR,*)'editt -N[file name] ...'
         stop
      endif
      call getln(luout, otap, 'w', 1)

c - we need to do this before calling rtape

      call sislgbuf(luin,'off')

      lbytes=0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'REARRANGE: no header read on unit ',luin
         write(LERR,*)'for data set name ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'check existence of this file'
         stop
      endif

#include <f77/saveh.h>
      write(LERR,*)'ntrc,nrec= ',ntrc,nrec

      CALL HLHprt ( ITR , LBYTES, NAME, 9, LERR        )

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c---------------------------------------
c  check key values for reasonableness
c---------------------------------------

      if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD

c     if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' Input Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval     =  ', nsi  
        write(LERR,*) ' Input traces/rec    =  ', ntrc
        write(LERR,*) ' Input Records/Line  =  ', nrec
        write(LERR,*) ' Format of Data      =  ', iform
        if(rnum) then
        write(LERR,*) ' Renumber traces'
        endif
        write(LERR,*) ' '
        write(LERR,*) ' Input on unit #            =  ',luin
        write(LERR,*) ' Output on unit #            =  ',luout
        write(LERR,*) ' '
c     endif

c------------------------------
c  save key line header values
c------------------------------
       iform = 3
       call savew( itr, 'NumTrc', nrec , LINHED)
       call savew( itr, 'NumRec', ntrc , LINHED)
       call savew( itr, 'Format', iform , LINHED)
       call savhlh( itr, lbytes, lbyout)

      obytes = SZTRHD + SZSMPD * nsamp
      CALL WRTAPE ( LUOUT, ITR, LBYout )

c*********************************************
c  this part of code assumes SMALL buffering
c  on input, i.e. this is the general trace
c  selection option - anything goes
c*********************************************

      ir = 0

      DO 100 KK = 1, ntrc

             ir = ir + 1
             ic = 0

             DO 99 JJ = 1, nrec
 
                   ic = ic + 1
                   ioff = (JJ - 1) * ntrc + KK
                   call sisseek (luin, ioff)

                   nbytes = 0
                   CALL RTAPE  ( LUIN , itr, NBYTES         )
                   if(nbytes .eq. 0) then
                      write(LERR,*)'End of file on input:'
                      write(LERR,*)'  rec= ',jj,'  trace= ',kk
                      go to 999
                   endif



                   if( rnum ) then
                      call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                            ir, TRACEHEADER)
                      call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                            ic, TRACEHEADER)
                   endif

                   call wrtape(luout,itr,nbytes)

   99        CONTINUE

  100 CONTINUE

  999 continue
        call lbclos(luin)
        call lbclos(luout)
      END

c--------------------------------
c  online help routine
c--------------------------------
      subroutine help
#include <f77/iounit.h>
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for rearrange: '
        write(LER,*)' output all trc1s, all trc2s, etc'
        write(LER,*)' '
        write(LER,*)'Input...................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-U         -- if present, renumber trcs & recs'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)' '
        write(LER,*)' rearrange -N[] -O[] [ -U -V ]'
        write(LER,*)' '
      return
      end

      subroutine cmdln(ntap,otap,rnum,verbos)
c-----
c     get command arguments
c
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     rnum  - L         if true, rnumber recs & traces
c     verbos- L         verbose output or not
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*)
      integer   argis
      logical   rnum,verbos

           call argstr('-N',ntap,' ',' ')
           call argstr('-O',otap,' ',' ')
           rnum   = ( argis( '-U' ) .gt. 0 )
           verbos = ( argis( '-V' ) .gt. 0 )

c-----
      return
      end

