C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln ( ntap, otap, ptap, Time,  Record, Trace, it0, 
     :     SmpUnitOverride, iseg, N, verbos, stawrd, recwrd, FormatIn,
     :     limin, limax, dimin, dimax, D3, debug)

c get command arguments

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer     N, iseg
      integer     argis

      real        Time(SZLNHD), Record(SZLNHD), Trace(SZLNHD)
      real        SmpUnitOverride

      character   ntap*(*), otap*(*), ptap*(*), stawrd*6, recwrd*6
      character   FormatIn*20
     
      integer     limin, limax, dimin, dimax
      logical     verbos, flat, xsd, xsdheader, D3, debug
 
      D3    = .false.

      call argi4 ( '-limin', limin ,  0  , 0    )
      call argi4 ( '-limax', limax ,  0  , 0    )
      call argi4 ( '-dimin', dimin ,  0  , 0    )
      call argi4 ( '-dimax', dimax ,  0  , 0    )

      call argi4 ( '-d', it0 ,  0 , 0   )
      call argstr( '-N', ntap, ' ', ' ' )
      call argstr( '-O', otap, ' ', ' ' )
      call argstr( '-P', ptap, ' ', ' ' )
      call argstr ('-rw',recwrd,' ',' ')
      call argstr ('-sw',stawrd,'StaCor','StaCor')
      D3     =   (argis('-D3') .gt. 0)
      if (D3) recwrd = 'RecNum'

      IF (ptap .eq. ' ') THEN

         FormatIn(1:1) = ' '

         do  i = 1, SZLNHD
            call argr4 ( '-r', Record(i), 0., 0. )
            call argr4 ( '-t', Time(i), 0., 0. )
            if (Record(i) .eq. 0.) then
               N = i - 1
               go to 2
            endif
         enddo

         write(LERR,*)'Too many rec/time pairs - ',SZLNHD
         write(LERR,*)'is the max'
         stop

 2       continue

         if (N .lt. 2) then
            write(LERR,*)'Must have at least 2 pairs of -r[] -t[]'
            write(LERR,*)'entries on command line -- FATAL'
            write(LERR,*)'Rerun with additional entries'
            stop
         endif
         call argr4 ( '-si', SmpUnitOverride , 0.0 , 0.0  )

      ELSE

         call argi4 ( '-j', iseg ,  1 , 1   )
         call argr4 ( '-si', SmpUnitOverride , 0.0 , 0.0  )
         xsdheader = ( argis('-xsdheader') .gt. 0 )
         xsd       = ( argis('-xsd') .gt. 0 )
         flat      = ( argis('-flat') .gt. 0 )

         if ( xsdheader ) then
            FormatIn = 'xsdheader'
         elseif (flat) then
            FormatIn = 'flat'
         else
            FormatIn = 'xsd'
         endif


      ENDIF

      if (recwrd(1:1) .eq. ' ') then
         write(LERR,*)'WARNING in recshift:'
         write(LERR,*)'You should supply trace header'
         write(LERR,*)'key word on cmd line using -rw[]'
         write(LERR,*)'Will default to RecNum'
         recwrd(1:6) = 'RecNum'
      endif

      debug  =   (argis('-debug') .gt. 0)
      verbos =   (argis('-V') .gt. 0)

      if (debug .and. .not.D3) then
         write(LERR,*)'WARNING from recshift:'
         write(LERR,*)'For debug option you must specify -D3'
         write(LERR,*)'3d option also.  Setting debug off.'
         debug = .false.
      endif

      return
      end
