C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine interp ( nrec, num, recnum, shifts, recs, times, 
     :     verbos )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer  num, nrec

      real     recnum(SZLNHD), recs(nrec), shifts(SZLNHD), times(nrec)
      real     j1, j2, dj, t1, t2, dt, s

      logical  verbos

      write(LERR,*)' '
      write(LERR,*)' Values Before Interpolation'
      write(LERR,*)' Record          Time'
      do  j = 1, num
          write(LERR,*)recnum(j),shifts(j)
      enddo
      write(LERR,*)' '

      
      ic = 0
      DO  i = 2, num
         j1 = recnum(i-1)
         if (i .eq. num) then
            j2 = recnum(i)
         else
            j2 = recnum(i) - 1
         endif
         dj = j2 - j1
c        dj = j2 - j1 + 1
         t1 = shifts(i-1)
         t2 = shifts(i)
         dt = t2 - t1
         if (dj .ne. 0.0) then
            s = dt / dj
         else
            s = 1
         endif
         DO  j = nint(j1), nint(j2)

            times(j) = t1 + s * (float(j) - j1)
            recs(j)   = float(j)
         ENDDO
      ENDDO

      write(LERR,*)' '

      if ( nint(recnum(1)) .ne. 1 ) then
         do i = 1, nint(recnum(1) - 1 )
            recs(i) = float(i)
         enddo
      endif

      if ( nint(recnum(num)) .lt. nrec ) then
         do i = nint(recnum(num)+1), nrec
            recs(i) = float(i)
         enddo
      endif

      return
      end
