C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c*************************RECSHIFT*************************************c
c
c recshift reads in time/rec pairs from the commandline, an xsd pick file
c or an xsd header value at pick file.  The times associated with the
c record index are entered to the record trace headers.  Either the raw time
c or a datum - raw time are entered as desired by the user.  The trace
c header mnemonic used to store the value is StaCor by default or may be 
c defined by the user.  The mnemonic used to associate the record index
c is sequential record by default, or may be user defined.
c
c     Changes October/95 .. cleaned up help routine and man page for points
c                           on xsd file use that were unclear...Garossino
c

c declare variables

#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

c standard usp variables

      integer     itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     argis, limin, limax, dimin, dimax, dphind, linind

      character   ntap*255, otap*255, name*8, card*80

      logical     verbos, D3, heap, debug

c program specific variables

      integer     ishift, iseg, it0, N, lupick
      integer     StaCor, ifmt_StaCor, l_StaCor, ln_StaCor
      integer     ifmt_stawrd, l_stawrd, ln_stawrd
      integer     ifmt_recwrd, l_recwrd, ln_recwrd

      real        Record(SZLNHD), Trace(SZLNHD), Time(SZLNHD)
      real        times(2*SZLNHD), recs(2*SZLNHD),SmpUnitOverride

      integer     li, di
      real        timer
      pointer     (wktimer, timer (1000000))
      pointer     (wkli   , li    (1000000))
      pointer     (wkdi   , di    (1000000))

      character   stawrd*6, recwrd*6, ptap*255, FormatIn*20

      logical gotit

c initialize data

      data lbytes / 0 / 
      data nbytes / 0 /
      data name/'RECSHIFT'/
      call vclr ( Record, 1, SZLNHD)
      call vclr ( Trace, 1, SZLNHD)
      call vclr ( Time, 1, SZLNHD)
      call vclr ( recs, 1, 2*SZLNHD)
      call vclr ( times, 1, 2*SZLNHD)

c check for help request

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0) then
            call help()
            stop
      endif
 
c open printout files

#include <f77/open.h>

c read program parameters from command line 

      call cmdln ( ntap, otap, ptap, Time, Record, Trace, it0,  
     :     SmpUnitOverride, iseg, N, verbos, stawrd, recwrd, FormatIn ,
     :     limin, limax, dimin, dimax, D3, debug)

c get logical unit numbers for input and output of seismic data

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c open pickfile if attached

      if ( ptap .ne. ' ' ) then
         length = lenth(ptap)
         call alloclun(lupick)
         open ( lupick, file = ptap(1:length), status = 'old', 
     :        iostat = ierr )
         if(ierr .ne. 0) then
            write(LER,*)'RECSHIFT: Could not open pickfile ',
     :           ptap(1:length)
            write(LER,*)'       Check permissions/spelling and rerun '
            write(LER,*)'FATAL'
            stop
         endif
      endif

c read input line header

      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LER,*)' '
         write(LER,*)'RECSHIFT: no header found on input dataset'
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      endif

c save certain line header parameters 

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c define required trace header pointers
 
      call savelu('StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )
      call savelu ( stawrd, ifmt_stawrd, l_stawrd, ln_stawrd, 
     :        TRACEHEADER )
      if ( recwrd .ne. ' ' ) 
     : call savelu ( recwrd, ifmt_recwrd, l_recwrd, ln_recwrd, 
     :        TRACEHEADER )
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)

      call hlhprt (itr, lbytes, name, 8, LERR)

c define number output bytes

      obytes = SZTRHD + nsamp * SZSMPD

c inject command line into historical lineheader

      call savhlh ( itr, lbytes, lbyout )

c write output lineheader

      call wrtape ( luout, itr, lbyout )

c read pick file header

      IF ( ptap(1:1) .ne. ' ') THEN

         if (D3) then

            if (limin.eq.0 .and. limax.eq.0 .and. dimin.eq.0 .and.
     1          dimax.eq.0) then
               call saver(itr, 'MnLnIn', limin, LINHED)
               call saver(itr, 'MxLnIn', limax, LINHED)
               call saver(itr, 'MnDpIn', dimin, LINHED)
               call saver(itr, 'MxDpIn', dimax, LINHED)
            endif
            if (limin.eq.0 .and. limax.eq.0 .and. dimin.eq.0 .and.
     1          dimax.eq.0) then
               write(LERR,*)'FATAL ERROR in picker 3D application:'
               write(LERR,*)'Min & Max LI & DI are zero. Fix line'
               write(LERR,*)'header or input limits on cmd line'
               write(LER ,*)'FATAL ERROR in picker 3D application:'
               write(LER ,*)'Min & Max LI & DI are zero. Fix line'
               write(LER ,*)'header or input limits on cmd line'
               stop
            endif
            nli = limax - limin + 1
            ndi = dimax - dimin + 1

            do while (1 .eq. 1)
               read (lupick, '(a80)', end = 11) card
               nf = nf + 1
            enddo
11          continue
            rewind lupick

            if (nf .eq. 0) then
            write(LERR,*)'FATAL ERROR in recshift:'
            write(LERR,*)'Hit end of file and detected no entries. Is'
            write(LERR,*)'file empty?'
            write(LER ,*)'FATAL ERROR in recshift:'
            write(LER ,*)'Hit end of file and detected no entries. Is'
            write(LER ,*)'file empty?'
            stop
            else
            write(LERR,*)' '
            write(LERR,*)'Read ',nf,' lines from times file'
            endif

            heap = .true.
            item = nli * ndi
            iteml = nli
            itemd = ndi
            call galloc (wktimer, item * SZSMPD, ierr, iab)
            if (ierr .ne. 0)  heap = .false.
            call galloc (wkli   , nf * SZSMPD, ierr, iab)
            if (ierr .ne. 0)  heap = .false.
            call galloc (wkdi   , nf * SZSMPD, ierr, iab)
            if (ierr .ne. 0)  heap = .false.
            if (.not. heap) then
               write(LER ,*)' '
               write(LER ,*)'Unable to allocate workspace:'
               write(LER ,*) item,'  bytes'
               write(LER ,*) iteml,'  bytes'
               write(LERR,*) itemd,'  bytes'
               go to 999
            else
               write(LERR,*)' '
               write(LERR,*)'Allocating workspace:'
               write(LERR,*) item,'  bytes'
               write(LERR,*) iteml,'  bytes'
               write(LERR,*) itemd,'  bytes'
            endif

            call timrd1 (lupick, nf, li, di, timer, nli, ndi,
     1                   limin, limax, dimin, dimax, nsi, debug)

         else

            call PickCount (  lupick, NumEntries, NumSegs, RecUnits, 
     :           TrcUnits, SmpUnits, RecOffset, TrcOffset, SmpOffset, 
     :           FormatIn )

c load pick segment requested 

            if ( FormatIn .eq. 'xsd' ) then
               call Xsd_ReadPicks(lupick, Record, Trace, Time, 
     :        N, NumEntries, iseg )
            elseif ( FormatIn .eq. 'xsdheader' ) then
               call Xsd_ReadHeaderPicks(lupick, Record, Trace, Time, 
     :        N, NumEntries, iseg, recwrd, SmpUnits, SmpOffset)
            elseif (FormatIn .eq. 'flat') then
               N = NumEntries
               call flat (lupick, NumEntries, Record, Time)
            endif

         endif
c handle sample unit override

         if ( abs (SmpUnitOverride) .gt. 1.e-30 ) then
            do i = 1, N
               Time(i) = Time(i) * SmpUnitOverride
            enddo
         endif


      ENDIF

c echo processing parameters to USP printout file

      call verbal(nsamp, nsi, ntrc, nrec, iform, iseg, N, Record, 
     :     Time, ntap, otap, ptap, SmpUnitOverride, it0, stawrd, 
     :     recwrd, FormatIn, limin, limax, dimin, dimax, D3)

c BEGIN PROCESSING

c process data

      ic = 0
      DO JJ = 1, nrec
 
         ic = ic + 1

c ... for 2D application ...
c if user has not supplied a recwrd then use sequential record number 
c as a index for the ishift calculation.

         gotit = .false.
         
         DO KK = 1, ntrc

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 990
            endif
               
            call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,StaCor,
     :           TRACEHEADER)

c write ishift to traceheader as required

            if (StaCor .ne. 30000) then

c depending on 2D or 3D app get index(es) from data traceheader
c and interpolate/ extrapolate the appropriate ishift from the attached 
c record/times vectors
               

               if (D3) then

                  call saver2(itr, ifmt_DphInd, l_DphInd, ln_DphInd, 
     :                 dphind, TRACEHEADER )
                  call saver2(itr, ifmt_LinInd, l_LinInd, ln_LinInd, 
     :                 linind, TRACEHEADER )
                  call centr1 (linind, dphind, timer, nt, nsi,ishift,
     1                         limin, limax, dimin, dimax, nli, ndi)
               else

                  call saver2(itr, ifmt_recwrd, l_recwrd, ln_recwrd, 
     :                 irec, TRACEHEADER )
                  if (.not. gotit) then
                     call GetShift(irec, Record, Time, N, it0,ishift)
                     if (verbos) write(LERR,*) 
     1                 'Rec ',irec,'   shift ', ishift
                     gotit = .true.
                  endif

               endif

               
               call savew2 ( itr, ifmt_stawrd, l_stawrd, ln_stawrd, 
     :              ishift, TRACEHEADER)

            endif
               
            call wrtape (luout, itr, obytes)
               
         ENDDO
      ENDDO

  999 continue

c normal termination - close logical units and terminate

      call lbclos ( luin )
      call lbclos ( luout )
      if ( ptap .ne. ' ' ) close(lupick)

      write(LERR,*)
     :'end of recshift, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)' RECSHIFT: Normal Termination'

      stop

 990  continue
      write(LER,*)' RECSHIFT: Abnormal Termination'
      stop

      end
