C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( nsamp, nsi, ntrc, nrec, iform, iseg, N, 
     :     Record, Time, ntap, otap, ptap, SmpUnitOverride, it0, stawrd,
     :     recwrd, FormatIn, limin, limax, dimin, dimax, D3)

#include <f77/iounit.h>

      integer     nsamp, nsi, ntrc, nrec, N, iseg, iform, it0
      integer     limin, limax, dimin, dimax

      real        Record(*),Time(*), SmpUnitOverride

      character   ntap*(*), otap*(*), ptap*(*), stawrd*6, recwrd*6
      character   FormatIn*20
      logical     D3
 
      write(LERR,*)' '
      write(LERR,*)' line header values after default check '
      write(LERR,*) ' # of samples/trace =  ', nsamp
      write(LERR,*) ' sample interval    =  ', nsi
      write(LERR,*) ' traces per record  =  ', ntrc
      write(LERR,*) ' records per line   =  ', nrec
      write(LERR,*) ' format of data     =  ', iform
      write(LERR,*) ' input data set name =  ', ntap
      write(LERR,*) ' output data set name=  ', otap

      IF (D3) THEN

      write(LERR,*) '3D data assumed'
      write(LERR,*) ' Min LI =  ',limin
      write(LERR,*) ' Max LI =  ',limax
      write(LERR,*) ' Min DI =  ',dimin
      write(LERR,*) ' Max DI =  ',dimax

      ELSE

      if (ptap .ne. ' ')  then
         if ( FormatIn .eq. 'xsd' ) then
            write(LERR,*) ' Xsd pickfile used'
         elseif ( FormatIn .eq. 'xsdheader' ) then
            write(LERR,*) 
     :' Xsd header value at pick location file used'
         endif
         write(LERR,*) ' Pick file name      =  ', ptap
         write(LERR,*) ' Pick segment to use =  ', iseg
         write(LERR,*) ' Sample override     =  ', SmpUnitOverride
      endif
      write(LERR,*)' Shift stored in trace header entry ',stawrd
      if ( recwrd .ne. ' ') then
         write(LERR,*)' Input index is ',recwrd
      else
         write(LERR,*)' Input index is sequential record number'
      endif
      write(LERR,*)' '
      write(LERR,*)'Control points'
      do  j = 1, N
          write(LERR,*)'Record  ',Record(j),'   Time  ',Time(j)
      enddo
      write(LERR,*)' '

      ENDIF

      write(LERR,*) ' Datum time          =  ', it0
      write(LERR,*)' '
            
      return
      end
