C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
	subroutine matinv(a,n,np,z)

	real	 a(2,2),y(2,2),indx(2)
        real     z(2,2),temp(2,2)

 	do 12 i=1,n
	do 11 j=1,n
	y(i,j)=0.
	temp(i,j)=a(i,j)
11	continue
	y(i,i)=1.
12	continue

	call ludcmp(temp,n,2,indx,d)

	do 13 j=1,n
	    call lubksb(temp,n,2,indx,y(1,j),j,z)
13	continue
	return
	end
c==========================================================
	subroutine ludcmp(a,n,np,indx,d)

c
c  Subroutine to do the LU decomposition of matrix a
c
	parameter (tiny=1.0E-40)
	real a(2,2),indx(2),vv(2)
	d=1.
	do 12 i=1,n
	aamax=0.
	do 11 j=1,n
	if (abs(a(i,j)) .GT. aamax) aamax=abs(a(i,j))
11	continue
	if (aamax .eq. 0.) write(6,*) 'Singular Matrix'
	vv(i)=1./aamax
12	continue
	do 19 j=1,n
	do 14 i=1,j-1
	sum=a(i,j)
	do 13 k=1,i-1
	sum=sum-a(i,k)*a(k,j)
13	continue
	a(i,j)=sum
14	continue
	aamax=0.
	do 16 i=j,n
	sum=a(i,j)
	do 15 k=1,j-1
	sum=sum-a(i,k)*a(k,j)
15	continue
	a(i,j)=sum
	dum=vv(i)*abs(sum)
	if (dum .ge. aamax) then
	imax=i
	aamax=dum
	endif
16	continue
	if (j .ne. imax) then
	do 17 k=1,n
	dum=a(imax,k)
	a(imax,k)=a(j,k)
	a(j,k)=dum
17	continue
	d=-d
	vv(imax)=vv(j)
	endif
	indx(j)=imax
	if(a(j,j) .eq. 0.) a(j,j)=tiny
	if (j .ne. n) then
	dum=1./a(j,j)
	do 18 i=j+1,n
	a(i,j)=a(i,j)*dum
18	continue
	endif
19 	continue
	return
	end
c========================================================
	subroutine lubksb(a,n,np,indx,b,jj,z)

c
c  Subroutine to back-substitute from the LU decomposition
	real a(2,2),indx(2),b(2),z(2,2)
	ii=0
	do 12 i=1,n
	ll=indx(i)
	sum=b(ll)
	b(ll)=b(i)
	if (ii .ne. 0) then
	do 11 j=ii,i-1
	sum=sum-a(i,j)*b(j)
11	continue
	else if (sum .ne. 0.) then
	ii=i
	endif
	b(i)=sum
12	continue
	do 14 i=n,1,-1
	sum=b(i)
	if (i .lt. n) then
	do 13 j=i+1,n
	sum=sum-a(i,j)*b(j)
13	continue
	endif
	b(i)=sum/a(i,i)
	z(i,jj)=b(i)
14	continue
	return
	end
