C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GradientFunc(tri, nsamp, new_vel, 
     :              Index_Constraint,Pick_Constraint,
     :              Null_Constraint,No_Constraint,
     :              vo,vgrad,refe,
     :              hdrwd1,hdrwd2,hdrwd3,
     :              iword1,iword2,iword3,
     :              irs, ire, ns, ne, nsi,
     :              recnum, trcnum, nullval,
     :              Start_End_Constraint,ist,iend,
     :	            hang)

c     Subroutine to perform a value replacement based on the 
c     given constraint conditions and outputs the 
c     the new time series as NEW_VEL.
c     The code creates a gradient function
c     
c     
c     James M. Gridley
c     USP Team
c     July 1996
      
c     variables passed from calling routine
      
      integer nsamp, irs, ire, ns, ne, ist, iend, nsi
      integer iword1, iword2, iword3, nullval
      integer trcnum, recnum
      
      real tri(nsamp)
      real new_vel(nsamp)
      real vo, vgrad, refe
      
      logical  Index_Constraint, Pick_Constraint
      logical  Null_Constraint, No_Constraint
      logical  Start_End_Constraint
      logical  hang
      
      character   hdrwd1 * 6, hdrwd2 * 6, hdrwd3 * 6
c=============================================================================
c     process data
c
c=============================================================================
c
c=============================================================================
      
      if (Null_Constraint  .and. iword3 .eq. nullval) then
        
         do i = 1, nsamp
            new_vel(i) = tri(i)
         enddo
         go to 999
      endif
c=============================================================================
      
      if(Pick_Constraint .and. Index_Constraint) then
      
         if (refe .eq. -99999.) refe = 0.

c set the vo to value of previous sample 
         
         if (vo .eq. -99999. .and. iword1/nsi .gt. 1 ) then
            vo_temp = tri((iword1/nsi)-1)
         elseif (vo .eq. -99999. .and. iword1/nsi .eq. 1) then
            vo_temp = 0.
         endif

         if (vo .ne. -99999.) vo_temp = vo
c in the case of hanging the gradient off of the horizion (HW1)
	  if(hang) refe = iword1

         do i = 1,nsamp
            if(i .gt. (iword1/nsi)+(ist-1) .and.
     :           i .le. (iword2/nsi) .and.
     :           recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne) then


               new_vel(i)= vgrad*(i-(refe/nsi))*nsi + vo_temp
               
c               new_vel(i) =(vgrad * (i-1) * nsi) + (vo_temp
c     :              - vgrad * (refe))  

            else
               new_vel(i) = tri(i)
            endif
         enddo
         go to 999
      endif
      
c=============================================================================
      
      if(Index_Constraint .and. Start_End_Constraint) then
     
         if(refe .eq. -99999.) refe = ist*nsi

         if (vo .eq. -99999. .and. ist .gt. 1) then
            vo_temp = tri(ist-1)
         elseif (vo .eq. -99999. .and. ist .eq. 1) then
            vo_temp = 0.
         endif
         if (vo .ne. -99999.) vo_temp = vo
         if (hang) refe=nsi*ist
            
         do i = 1, nsamp
            if (i .gt. ist .and. i .le. iend .and.
     :           recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne ) then
               new_vel(i)= vgrad*(i-(refe/nsi))*nsi + vo_temp
c               new_vel(i) =(vgrad * (i-1) * nsi) + (vo_temp
c     :              - vgrad * (refe))                 
                            
            else
               new_vel(i) = tri(i)
            endif
         enddo
         go to 999
      endif
      
c=============================================================================
      
      if (No_Constraint) then
         
         if(refe .eq. -99999.) refe = 0.
         if (vo .eq. -99999. ) then
            vo_temp = 0.
         elseif (vo .ne. -99999.) then
               vo_temp = vo
            endif
            if (hang) refe = nsi*ist
                   
         do i = 1, nsamp
               new_vel(i)= vgrad*(i-(refe/nsi))*nsi + vo_temp

c            new_vel(i) =(vgrad * (i-1) * nsi) + (vo_temp
c     :           - vgrad * (refe)) 
     
         enddo
         go to 999
      endif
      
c=============================================================================
         
      if(Start_End_Constraint) then 
    
         if (refe .eq. -99999.) refe = ist*nsi

         if (vo .eq. -99999. .and. ist .gt. 1) then
            vo_temp = tri(ist-1)
            elseif (vo .eq. -99999. .and. ist .eq. 1) then
               vo_temp = 0.
            endif
            if(vo .ne. -99999) vo_temp = vo
            if (hang) refe=nsi*ist
            
       
         do i = 1, nsamp
            if (i .gt. ist .and. i .le. iend) then

               new_vel(i)= vgrad*(i-(refe/nsi))*nsi + vo_temp

c               new_vel(i) =(vgrad * (i-1) * nsi) + (vo_temp
c     :              - vgrad * (refe))                
            else
               new_vel(i) = tri(i)
            endif
         enddo
         go to 999
      endif
c=============================================================================
      if(Pick_Constraint) then
        
         if (vo .eq. -99999. .and. iword1/nsi .gt. 1) then
            vo_temp = tri((iword1/nsi)-1)
         elseif ( vo .eq. -99999. .and. iword1/nsi .le. 1) then
            vo_temp = 0.
         endif

         if (vo .ne. -99999.) vo_temp = vo
         if (refe .eq. -99999.) refe = 0.

c in the case of hanging the gradient off of the horizion (HW1)
	  if(hang) refe = iword1
     
         do i = 1, nsamp
            
            if(i .gt. (iword1/nsi)+(ist-1) .and.
     :           i .le. (iword2/nsi)) then
               
               new_vel(i)= vgrad*(i-(refe/nsi))*nsi + vo_temp

c               new_vel(i) =(vgrad * (i-1) * nsi) + (vo_temp
c     :              - vgrad * (refe))     
            else
               new_vel(i)=tri(i)
            endif
            
         enddo
         go to 999
      endif
c=============================================================================
      if(Index_Constraint) then
      
         if (refe .eq. -99999.) refe = 0.
         if (vo .eq. -99999. ) vo_temp = 0
         if (vo .ne. -99999.) vo_temp = vo

         if (hang) refe = ist*nsi

         do i = 1, nsamp
            if(recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne) then

               new_vel(i)= vgrad*(i-(refe/nsi))*nsi + vo_temp

c               new_vel(i) =(vgrad * (i-1) * nsi) + (vo_temp
c     :              - vgrad * (refe))
            else
               new_vel(i) = tri(i)
            endif
         enddo
         go to 999
      endif
      
c=============================================================================
      
 999  return
      end
