C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ValueDetect(tri, nsamp, new_vel, 
     :     Index_Constraint,Pick_Constraint,
     :     Null_Constraint,No_Constraint,
     :     replacement_value,
     :     hdrwd1,hdrwd2,hdrwd3,
     :     iword1,iword2,iword3,
     :     irs, ire, ns, ne, nsi,
     :     recnum, trcnum, nullval,
     :     Start_End_Constraint,ist,iend,DetOn,
     :     ifmt_hdrwd1,l_hdrwd1,ln_hdrwd1,
     :     ifmt_hdrwd2,l_hdrwd2,ln_hdrwd2,itr,top,bot,
     :     grad,thr,verbos,LERR)

c     Subroutine to perform a value replacement based on the 
c     given constraint conditions and outputs the 
c     the new time series as NEW_VEL.
c     
c     
c     James M. Gridley
c     USP Team
c     July 1996
      
c     variables passed from calling routine
      
      integer itr (*)
      integer nsamp, irs, ire, ns, ne, ist, iend, nsi
      integer iword1, iword2, iword3, nullval
      integer recnum,trcnum
      real tri(nsamp)
      real new_vel(nsamp)

      logical  Index_Constraint, Pick_Constraint
      logical  Null_Constraint, No_Constraint
      logical  Start_End_Constraint
      logical  DetOn, top, bot, grad, verbos
      logical  gottop, gotbot

      character   hdrwd1 * 6, hdrwd2 * 6, hdrwd3 * 6
c=============================================================================
c     process data
      
c=============================================================================
c     do detect only:
c        this assumes top - look from top down for first occurence
c                           of a specified value, and
c        for bot - continue down through a zone where "value" is
c                  constant looking for the first occurence of
c                  non-"value"
c        i.e. we are looking for the top (and possible bottom) of
c        a body compreised of a specfied "value"

      IF ( DetOn ) THEN

        gottop = .false.
        gotbot = .false.
        ibst = 0
        ibed = 0
        call savew2 (itr,ifmt_hdrwd1,l_hdrwd1, ln_hdrwd1,
     1               0, 1)
        call savew2 (itr,ifmt_hdrwd2,l_hdrwd2, ln_hdrwd2,
     1               0, 1)

        if (grad) then
           val = thr * replacement_value / 100
        else
           val = replacement_value
        endif

        if ( top ) then

           if (grad) then

                do  i = 1, nsamp-1
                  del = abs(tri(i) - tri(i+1))
                  if (del .gt. val) then
                     itime1 = nsi * (i-1)
                     call savew2 (itr,ifmt_hdrwd1,l_hdrwd1, ln_hdrwd1,
     1                            itime1, 1)
                     ibst = i
                     gottop = .true.
                     go to 11
                  endif
                enddo

           else

                do  i = 1, nsamp
                  if (tri(i) .eq. val) then
                     itime1 = nsi * (i-1)
                     call savew2 (itr,ifmt_hdrwd1,l_hdrwd1, ln_hdrwd1,
     1                            itime1, 1)
                     ibst = i
                     gottop = .true.
                     go to 11
                  endif
                enddo

           endif

        endif
11      continue

        ibst = ibst + 1

        if ( bot ) then

           if (grad) then

              do  i = nsamp, ibst+1, -1
                  del = abs(tri(i) - tri(i-1))
                  if (del .gt. val) then
                     itime2 = nsi * (i-2)
                     call savew2 (itr,ifmt_hdrwd2,l_hdrwd2, ln_hdrwd2,
     1                            itime2, 1)
                     ibed = i - 1
                     gotbot = .true.
                     go to 13
                  endif
              enddo

           else

              do  i = ibst, nsamp
                  if (tri(i) .ne. val) then
                     itime2 = nsi * (i-2)
                     call savew2 (itr,ifmt_hdrwd2,l_hdrwd2, ln_hdrwd2,
     1                            itime2, 1)
                     ibed = i - 1
                     gotbot = .true.
                     go to 13
                  endif
              enddo

           endif

        endif
13      continue

        if (verbos) then
           if (gottop .AND. .not. gotbot) 
     1     write(LERR,*)'Rec/Trc ',recnum,trcnum,'  Top= ',itime1
           if (.not. gottop .AND. gotbot) 
     1     write(LERR,*)'Rec/Trc ',recnum,trcnum,'  Bot= ',itime2
           if (gottop .AND. gotbot) 
     1     write(LERR,*)'Rec/Trc ',recnum,trcnum,'  Top/Bot= ',
     2                   itime1,itime2
        endif

        return
      ENDIF
c=============================================================================
         
      if(Pick_Constraint .and. Index_Constraint) then
      
         do i = 1,nsamp
            if(i .ge. (iword1/nsi)+(ist-1) .and.
     :           i .le. (iword2/nsi) .and.
     :           recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne) then
                if (tri(i) .eq.  replacement_value) then
                   tri(i)=tri(i-1)              
                endif 
             endif
          enddo
         go to 999
      endif

c=============================================================================

      if(Index_Constraint) then

         do i = 1, nsamp

            if(recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne .and.
     :	 i .ge. ist .and. i .le. iend ) then
               if (tri(i) .eq.  replacement_value) then
                  tri(i)=tri(i-1)              
               endif
            endif
            
         enddo
         go to 999
      endif
      
c=============================================================================

      if (No_Constraint) then
         
         do i = 1, nsamp
            if (tri(i) .eq.  replacement_value) then
               tri(i)=tri(i-1)              
            endif
         enddo
c=============================================================================
         
      elseif(Start_End_Constraint) then
         do i = 1, nsamp
            if (i .ge. ist .and. i .le. iend) then
               if (tri(i) .eq.  replacement_value) then
                  tri(i)=tri(i-1) 
               endif
            endif
         enddo
         
c=============================================================================
      elseif(Pick_Constraint) then
         
         do i = 1, nsamp
            if(i .ge. (iword1/nsi)+(ist-1) .and.
     :           i .le. (iword2/nsi)) then
               if (tri(i) .eq.  replacement_value) then
                  tri(i)=tri(i-1)  
               endif
            endif
         enddo
c=============================================================================
         
      endif
c=============================================================================
c     put the new array into  new_vel
         
         do i=1,nsamp
            new_vel(i)=tri(i)
         enddo
      
c=============================================================================
         
 999  return
      end
