C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ValueSwap(tri, nsamp, new_vel, 
     :              Index_Constraint,Pick_Constraint,
     :              Null_Constraint,No_Constraint,
     :              ValueOld, ValueNew,
     :              hdrwd1,hdrwd2,hdrwd3,
     :              iword1,iword2,iword3,
     :              irs, ire, ns, ne, nsi,
     :              recnum, trcnum, nullval,
     :              Start_End_Constraint,ist,iend )

c     Subroutine to perform a value replacement based on the 
c     given constraint conditions and outputs the 
c     the new time series as NEW_VEL.
c     The code will swap  ValueOld with ValueOld 
c     
c     
c     James M. Gridley
c     USP Team
c     July 1996
      
c     variables passed from calling routine
      
      integer nsamp, irs, ire, ns, ne, ist, iend, nsi
      integer iword1, iword2, iword3, nullval
      integer recnum, trcnum
      
      real tri(nsamp)
      real new_vel(nsamp)
      real ValueOld, ValueNew
      
      logical  Index_Constraint, Pick_Constraint
      logical  Null_Constraint, No_Constraint
      logical  Start_End_Constraint
      
      character   hdrwd1 * 6, hdrwd2 * 6, hdrwd3 * 6
c=============================================================================
c     process data
c=============================================================================
      
      if (Null_Constraint  .and. iword3 .eq. nullval) then
         do i = 1, nsamp
            new_vel(i) = tri(i)
         enddo
         go to 999
      endif
c=============================================================================
      
      if(Pick_Constraint .and. Index_Constraint) then
         
         do i = 1,nsamp
            if(i .ge. (iword1/nsi)+(ist-1) .and.
     :           i .le. (iword2/nsi) .and.
     :           recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne) then
               
               if(tri(i) .eq. ValueOld) then
                  new_vel(i) = ValueNew
               else
                  new_vel(i) = tri(i)
               endif
               
            else
               new_vel(i) = tri(i)
            endif
         enddo
         go to 999
      endif
      
c=============================================================================
      
      if(Index_Constraint .and. Start_End_Constraint) then
         do i = 1, nsamp
            if (i .ge. ist .and. i .le. iend .and.
     :           recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne ) then
            if(tri(i) .eq. ValueOld) then
               new_vel(i) = ValueNew
               else
                  new_vel(i) = tri(i)
               endif
               
            else
               new_vel(i) = tri(i)
            endif
         enddo
         go to 999
      endif
      
c=============================================================================
      
      if (No_Constraint) then
         
         do i = 1, nsamp
            if(tri(i) .eq. ValueOld) then
               new_vel(i) = ValueNew
            else
               new_vel(i) = tri(i)
            endif
            
         enddo
      endif
c=============================================================================
         
      if(Start_End_Constraint) then
         do i = 1, nsamp
            if (i .ge. ist .and. i .le. iend) then
               
               if(tri(i) .eq. ValueOld) then
                  new_vel(i) = ValueNew
               else
                  new_vel(i) = tri(i)
               endif
               
            else
               new_vel(i) = tri(i)
            endif
         enddo
         go to 999
      endif
c=============================================================================
      if(Pick_Constraint) then
         
         do i = 1, nsamp
            if(i .ge. (iword1/nsi)+(ist-1) .and.
     :           i .le. (iword2/nsi)) then
               
               if(tri(i) .eq. ValueOld) then
                  new_vel(i) = ValueNew
               else
                  new_vel(i) = tri(i)
               endif
               
            else
               new_vel(i)=tri(i)
            endif
         enddo
         go to 999
      endif
c=============================================================================
      if(Index_Constraint) then
         
         do i = 1, nsamp
            if(recnum .ge. irs .and. recnum .le. ire .and.
     :           trcnum .ge. ns .and. trcnum .le. ne) then
               if(tri(i) .eq. ValueOld) then
                  new_vel(i) = ValueNew
               else
                  new_vel(i) = tri(i)
               endif
               
            else
               new_vel(i) = tri(i)
            endif
         enddo
         go to 999   
      endif
      
c=============================================================================
      
 999  return
      end
