C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------------resortm------------------------------------------72
c
c Original of resorter Author Klaas Koster
c Modified to resortm by Chester A. Jacewitz 01aug94
c
c resortm reads data in USP format from disk.  It output traces
c interchanged for records.  ie rec10 trace 1 on input becomes record1 trace
c 10 on output
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c
c     declare variables
c
c ----- get machine dependent parameters -----
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c
c ----- dimension standard USP variables -----
c

      integer*2   itr( SZLNHD )
      integer     lhed( 1500 )
      integer     nsamp,nsampo,nsi,ntrc,ntrco,nrec,nreco,iform
      integer     luin,lbytes,nbytes,obytes
      integer     argis,ist,iend,irs,ire,ns,ne
      integer     JJ,KK,recnum,trcnum
      integer     errcod,LL,lenblk,ntrccn,ntrci,nrecc,nreci
      
      pointer     (iaddr1,ibuff)

      real        ibuff(1),tri(SZSMPM)

      character   name*7,ntap*100,otap*100

      logical     verbos,query, fdslice, rev


c ----- integer USP variables -----
c
c	itr   array: trace plus header from rtape
c       itrh  array: trace headers for record
c       lhed  array: line header
c       nsamp      : number of samples of input trace
c       nsampo     : number of samples of output trace
c       nsi        : input sample interval
c       ntrc       : input traces/record
c       ntrcc      : changed input traces/record
c       ntrco      : output traces/record
c       nrec       : input number of records
c       nrecc      : changed input number of records
c       nreco      : output number of records
c       iform      : format of data
c       luin       : input device
c       lbytes     :
c       nbytes     :
c       obytes     :
c       argis      : 
c       ist        : window start time (ms)
c       iend       : window end time (ms)
c       irs        : record start
c       ire        : record end
c       irm        : records in memory
c       ns         : trace start
c       ne         : trace end
c       nm         : traces in memory
c       lenblk     : blocking factor for traces
c       JJ,KK      : loop counters
c       KKOUT      : output record counter
c       errcd1     : error flag from galloc
c       abort1     : abort flag from galloc
c
c ----- real USP variables -----
c
c	tri array  : working trace   
c
c ----- character USP variables -----
c
c	name       : for print file identification
c	ntap       : input file name 
c       otap       : output file name
c
c ----- logical USP variables -----
c
c	verbos     : printout verbosity flag
c	query      : online help flag
c
c
c ----- dimension program specific variables -----
c

c
c ----- set up useful hooks -----
c
 
      equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )

c
c ----- initialize necessary variables -----
c

      data name/'RESORTM'/
      data luin/1/,lbytes/0/

c
c ----- get online help if necessary -----
c

      query = (argis('-?').gt.0 .or. argis('-h').gt.0)

      if ( query ) then

           call help ()
           stop 111

      endif

c
c ----- printout -----

#include <f77/open.h>

c
c ----- get command line parameters -----
c

      call cmdln (ntap,otap,ist,iend,irs,ire,irm,ns,ne,nm
     *           ,lenblk,verbos,
     1            ntrcc, nrecc)

c
c ----- get logical units -----
c

      call getln(luin,ntap,'r',0)
      call getln (luout,otap,'w+',1)
      call  sislgbuf( luout, 'off')

C     LER = stderr
C     LERR = RESORTM.numbers = "print" file

      write(LERR,*)'Input unit # is ',luin,' for DSN= ',ntap
      write(LERR,*)'Output unit # is ',luout,' for DSN= ',otap

c
c ----- read line header, check to see if input empty -----
c

      lbytes = 0
      call rtape(luin,itr,lbytes)
C     write(LERR,*)'lbytes= ',lbytes

      if(lbytes .eq. 0) then
         write(LERR,*)'resortm: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop 222
      endif

c
c ----- alter line header -----
c

#include <f77/saveh.h>

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)


      if(nsamp .gt. SZSMPM) nsamp=SZSMPM

C     cmdchk is external 

C     call cmdchk(ns,ne,irs,ire,ntrc,nrec)
      ntrci=ntrc
      nreci=nrec
      if( 1 .LE. ntrcc ) ntrc=ntrcc
      if( 1 .LE. nrecc ) nrec=nrecc
      call cmdchk(ns,ne,irs,ire,ntrcc,nrecc)

c
c ----- set record start and end defaults -----
c

      if(irs .eq. 0) irs=1
      if(ire .eq. 0) ire=nrec
      if(ns.eq.0)ns = 1
      if(ne.eq.0)ne = ntrc

c
c ----- determine number of records to process -----
c

      nreco = ne - ns +1
      nreco = nreco/lenblk

      if( nreco .LE. 0 )then
           write(LERR,*)'**** output number of records bad: '
     *                  ,nreco
           write(LERR,*)'ns,ne,lenblk: ',ns,ne,lenblk
           STOP 5555
           endif

      
c
c ----- convert start and end time to start and end sample -----
c

      ist=ist/nsi
      iend=iend/nsi

      if(ist .lt. 1) ist=1
      if(iend .lt. 1) iend=nsamp

c
c ----- determine number of output samples -----
c

      nsampo=iend-ist+1

c
c ----- determine number of output traces -----
c

      ntrco = ire - irs +1
      ntrco = ntrco*lenblk
      

c
c ----- modify output lineheader -----
c

         call savew( itr, 'NumSmp', nsampo, LINHED)
         call savew( itr, 'NumRec', nreco , LINHED)
         call savew( itr, 'NumTrc', ntrco , LINHED)

c
c ----- change output bytes to reflect change -----
c       from time to # traces
c

      obytes = SZTRHD + SZSMPD * nsampo

c
c ----- adjust historical line header & write header -----
c

      call savhlh(itr,lbytes,lbyout)

      call wrtape(luout,itr,lbyout)

c
c ----- printout -----
c

      call verbal(nsamp,nsampo,nsi,ntrci,ntrcc,ntrco
     *            ,nreci,nrecc,nreco,iform,ist,iend,
     :            ns,ne,nm,irs,ire,irm,lenblk)

c
c ----- create output filespace to skip around in -----
c

      do JJ=irs,ire

         do KK=ns,ne
            
            call vclr(tri,1,nsamp)
            call wrtape(luout,itr,obytes)

         enddo

      enddo

c ----- allocate internal memory buffer ---------------

      nbuf1=irm*nm
      nbuf=nbuf1*(ITRWRD+nsamp)

C     write(LERR,*)'Number of traces/words in buffer: '
C    *                       ,nbuf1,nbuf
  
C     write(LERR,*)'Number of bytes/trace: ',(ITRWRD+nsamp)
C     write(LERR,*)'Number of bytes in buffer: ',nbuf*SZSMPD

      call galloc (iaddr1,nbuf*SZSMPD, errcod, abort)

      if( errcod .ne. 0 )then
           write(LERR,*)'**** Unable to allocate workspace ****'
           write(LERR,*)'Reduce -nm or -rm from : ',nm,irm
           go to 999
           endif
c
         kread=0
         kwrite=0

         DO 200 JJ = irs, ire,irm

              DO 199 KK = ns,ne,nm
C             write(LERR,*)'Read ... fill buffer JJ,KK: ',JJ,KK
c
c ----- skip to desired trace -----
c
              index=1

           DO 201 JM=JJ,MIN(JJ+(irm-1),ire)
C
              ioff = (jm-1)*ntrc + KK
C             write(LERR,*)'Read ... ioff: ',ioff
              call sisseek (luin, ioff)

C             Fill memory

C                   write(LERR,*)'Read ... loop control: '
C    *              ,KK,MIN(KK+(nm-1),ne)

                    DO 198 KM=KK,MIN(KK+(nm-1),ne)

                  JJINP=JM
                  KKINP=KM
                  LLINP=1+MOD(KKINP-1,lenblk)

CC               write(LERR,*)'Read ... JJINP,KKINP,LLINP : '
CC   *                                 ,JJINP,KKINP,LLINP

C                   trace number in buffer

                    index1= (JJINP-JJ)*(nm) + 1+ (KKINP-KK)
                    index=1+(index1-1)*(ITRWRD+nsamp)

CC                  write(LERR,*)'Read ... index1,index= '
CC   *                                    ,index1,index

                    if(nbuf1 .LT. index1) then
                         write(LERR,*)'**** nbuf1 .LT. index1 ****'
     *                               ,nbuf1,index1
                         write(LERR,*)'JJINP,JJ,nm,KKINP,KK: '
     *                                ,JJINP,JJ,nm,KKINP,KK
                         STOP 66666
                         endif

CC                  write(LERR,*)'Read ... JM,KM: ',JM,KM
CC                  write(LERR,*)'Read ... ioff,index= '
CC   *                                    ,ioff,index

                    nbytes = 0
                    call rtape(luin,ibuff(index),nbytes)
C                   index=index+ITRWRD+nsamp
                    if(nbytes .eq. 0) then

                       write(LERR,*)'End of file on input:'
                       write(LERR,*)'  rec= ',jjinp,'  trace= ',kkinp
                       if(lenblk.ne.1)
     *                 write(LERR,*)'  subrec= ',llinp
C                      go to 999
                       go to 202
                       else
                       kread=kread+1

                       if( .FALSE. )THEN
                          write(LERR,*)'Read ... rec_inp= ',JJ+(jm-1)
     *                           ,'  trace_input= ',KK+(KM-1)
     *                           ,'  ensemble location= '
     *                           ,1+MOD( (KK-1) + (KM-1),lenblk)
                             endif

                    endif

198                 CONTINUE


c

C 
201         CONTINUE
202         CONTINUE

      write(LER,*)'Read ... Record,Traces read/written: '
     *                 ,JJ,kread,kwrite

             
C               Flush memory

C            Flush all traces in memory

C             write(LERR,*)'Write ... flush buffer JJ,KK: ',JJ,KK


C            Flush all records in memory
C            Note: KM bumped irregularly within the loop

C            DO 398 KM=KK,MIN(KK+(nm-1),ne)

             KM=KK

3398         CONTINUE

             if( MIN(KK+(nm-1),ne) .LT. KM ) goto 399
               
                  LLSTRT=1+MOD(KM-1,lenblk)
                  LLSTOP=LLSTRT+MIN(lenblk,nm)-1

                  if( KM .EQ. KK )then
C                      write(LERR,*)'Write ... LLSTRT,LLSTOP: '
C    *                                   ,LLSTRT,LLSTOP
                       endif

                  

                  DO 301 JM=JJ,MIN(JJ+(irm-1),ire)
                  KMLOC = KM
                  DO 300 LL=LLSTRT,LLSTOP

CC                write(LERR,*)'Write ... KM,JM,LL: '
CC   *                                   ,KM,JM,LL

C                 Compute input record/trace

                  JJINP=JM
                  KKINP=KMLOC
                  LLINP=LL

CC               write(LERR,*)'Write ... JJINP,KKINP,LLINP : '
CC   *                                  ,JJINP,KKINP,LLINP

C                 Compute output record/location
                 

                  JJOUT = 1 + (KMLOC-1)/lenblk
                  KKOUT = (JM-1)*lenblk+LL
                  LLOUT = LL
                    
                    ioff = (JJOUT-1)*(ntrco)+KKOUT
CC                  write(LERR,*)'Write ... ioff= ',ioff

                    call sisseek (luout, ioff)

                    if( .FALSE. )THEN
                         write(LERR,*)'Write ... rec_out= ',JJOUT
     *                                ,'  trace_out= ',KKOUT
     *                           ,'  ensemble location= ',LLOUT
                         endif

C                   trace number in buffer

                    index1= (JJINP-JJ)*(nm) + 1+ (KKINP-KK)
                    index=1+(index1-1)*(ITRWRD+nsamp)

CC                  write(LERR,*)'Write ... index1,index= '
CC   *                                     ,index1,index

                    if(nbuf1 .LT. index1) then
                         write(LERR,*)'**** nbuf1 .LT. index1 ****'
     *                               ,nbuf1,index1
                         write(LERR,*)'JJINP,JJ,nm,KKINP,KK: '
     *                                ,JJINP,JJ,nm,KKINP,KK
                         STOP 7777
                         endif
                   
                    call wrtape(luout,ibuff(index),obytes)
                    kwrite=kwrite+1
                    KMLOC = KMLOC + 1
                    if( kwrite .EQ. kread ) goto 399
300                 CONTINUE
301                 CONTINUE

                    KM=KM+(LLSTOP-LLSTRT)+1
                    goto 3398

398         CONTINUE
399         CONTINUE

      write(LER,*)'Write ... Record,Traces read/written: '
     *             ,JJ,kread,kwrite


199           CONTINUE
200      CONTINUE


999   continue

       call lbclos(luin)
       call lbclos(luout)

      write(LER,*)'Total Traces read/written: ',kread,kwrite
      stop
      end

c
c ----- online help section -----
c

      subroutine  help

#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for resortm'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap] -- input data set'
        write(LER,*)'-O[otap] -- output data set'
c       write(LER,*)'-s[ist]  -- start time (ms)          (first samp)'
c       write(LER,*)'-e[iend] -- end time (ms)             (last samp)'
        write(LER,*)'-ns[ns]  -- start trace             (first trace)'
        write(LER,*)'-ne[ne]  -- end trace                (last trace)'
        write(LER,*)'-nm[nm]  -- traces in memory                  (1)'
        write(LER,*)'-rs[irs] -- start record                  (first)'
        write(LER,*)'-re[ire] -- end record                     (last)'
        write(LER,*)'-rm[irm] -- records in memory                 (1)'
        write(LER,*)'-lb[lenblk] -- length of block                (1)'
        write(LER,*)'-fdslice -- reorder fdslice data (forward)'
        write(LER,*)'-V       -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'resortm -N[] -O[] -s[] -e[] -ns[] -ne[] -nm[]'//
     :   ' -rs[] -re[] -rm[] -lb[] [-fdslice -V]'
        write(LER,*)' '

      return
      end

c
c ----- command line parsing subroutine -----
c

      subroutine cmdln (ntap,otap,ist,iend,irs,ire,irm,ns,ne,nm
     *                ,lenblk,verbos,
     1                 ntrcc, nrecc)

#include <f77/iounit.h>

      integer    argis,ist,iend,irs,ire,irm,lenblk
     
      character  ntap*(*), otap*(*)

      logical    verbos, fdslice, rev

          call argstr('-N',ntap,' ',' ') 

          if( ntap(1:1) .EQ. ' ' )then
               write(LER,*)'**** Cannot pipe input ****'
               stop 333
               endif

          call argstr('-O',otap,' ',' ') 

          if( otap(1:1) .EQ. ' ' )then
               write(LER,*)'**** Cannot pipe output ****'
               stop 444
               endif

          call argi4('-s',ist,1,1)
          call argi4('-e',iend,0,0)
          call argi4('-rs',irs,1,1)
          call argi4('-re',ire,0,0)
          call argi4('-rm',irm,1,1)
          call argi4('-ns',ns,0,0)
          call argi4('-ne',ne,0,0)
          call argi4('-nm',nm,1,1)
          call argi4('-lb',lenblk,1,1)
          call argi4('-L',ntrcc,0,0)
          call argi4('-R',nrecc,0,0)

          verbos  = (argis('-V') .gt. 0)

      return
      end

      subroutine verbal(nsamp,nsampo,nsi,ntrc,ntrcc,ntrco
     *                  ,nrec,nrecc,nreco,iform,
     :                  ist,iend,ns,ne,nm,irs,ire,irm,lenblk)

#include <f77/iounit.h>

      
      integer nsamp,nsampo,nsi,ntrc,ntrco,nrec,nreco,iform,ist,iend
      integer ns,ne,nm,lenblk

        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi
        write(LERR,*) ' Input Traces per Record  =  ', ntrc
        write(LERR,*) ' Changed input Traces per Record  =  ', ntrcc
        write(LERR,*) ' Output Traces per Record  =  ', ntrco
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Changed records per Line   =  ', nrecc
        write(LERR,*) ' Format of Data     =  ', iform
c       write(LERR,*) ' window start in samples   =  ', ist
c       write(LERR,*) ' window end in samples     =  ', iend
        write(LERR,*) ' trace start       =  ', ns
        write(LERR,*) ' trace end       =  ', ne
        write(LERR,*) ' traces in memory   =  ', nm
        write(LERR,*) ' record start       =  ', irs
        write(LERR,*) ' record end         =  ', ire
        write(LERR,*) ' records in memory  =  ', irm
        write(LERR,*) ' Output records     =  ', nreco
        write(LERR,*) ' Output # samples   =  ',nsampo
        write(LERR,*) ' Input/Output trace block length =  ',lenblk
        write(LERR,*) ' '

      return
      end
