C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       MNMX                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  TO PICK RELATIVE MINIMA AND MAXIMA FOR INPUT FUNCTION.    *
C  ENTRY POINTS:                                                       *
C      MNMX  (tri_env,nsampo,IPEAK,JP,ITRF,JT)                         *
C  ARGUMENTS:                                                          *
C      tri_env REAL         I*  (1) - INPUT ARRAY TO SCAN FOR MIN/MAX  *
C      nsampo  INTEGER      I*      - NUMBER OF SAMPLES IN ARRAY 'A'   *
C      IPEAK   INTEGER      O*  (1) - INDEX  ARRAY OF RELATIVE PEAKS   *
C      JP      INTEGER      O*      - NUMBER OF RELATIVE PEAKS IN IPEAK*
C      ITRF    INTEGER      O*  (1) - INDEX  ARRAY OF RELATIVE TROUGHS *
C      JT      INTEGER      O*      - NUMBER OF REL TROUGHS IN ITRF    *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   J. NORRIS                          ORIGIN DATE: 83/06/03  *
C  LANGUAGE: FORTRAN 77/IV               DATE LAST COMPILED: 83/06/03  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  IF NPT <=1, SUBROUTINE IS NOT EXECUTED.            *
C  GENERAL DESCRIPTION:  EVERY PEAK OR TROUGH IS FOUND REGARDLESS OF   *
C       AMPLITUDE.  THIS CODE ADAPTED FROM PKDT AND RPHS BY J.H.BODINE.*
C       +------------------------------------------------------+       *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NON-STANDARD FEATURES:  NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE MNMX(tri_env,nsampo,IPEAK,JP,ITRF,JT)
#include <f77/lhdrsz.h>

c dimension standard USP variables
      integer     nsampo
      real        tri_env( nsampo ), ITRF( SZLNHD ), IPEAK( SZLNHD )
C
      JT = 0
      JP = 0
      SLOP = 0.
      ILAST=0
C***********************************************************************
C ***** FIND ARRAY POSITIONS OF MAXIMA AND MINIMA AFTER CHECKING VALID
C ***** LOOP INDEX.
C***********************************************************************
      nsampo1 = nsampo-1
      IF(nsampo1.LE.0) GO TO 150
      DO 100 I=1,nsampo1
         SLAST = SLOP
         SLOP = tri_env(I+1)-tri_env(I)
         CHNG = SLAST*SLOP
         IF (CHNG.GT.0.) GO TO 100
         IF (SLOP.EQ.0..AND.SLAST.EQ.0.) GO TO 100
         IF (SLAST.LE.0..AND.SLOP.GE.0.) GO TO 50
C***********************************************************************
C ******* HERE FOR A PEAK.
C ******* CHECK FOR TWO CONSECUTIVE PEAKS. IGNORE SUBSEQUENT PEAKS UNTIL
C ******* A TROUGH IS FOUND.  ILAST=1 FOR PEAK.
C***********************************************************************
         IF(ILAST.EQ.1)GO TO 100
         JP = JP+1
         IPEAK(JP) = I
         ILAST=1
         GO TO 100
C***********************************************************************
C ******* HERE FOR A TROUGH. SEE IF PEAK ALREADY PICKED FIRST.
C ******* CALLING ROUTINES EXPECT FIRST POINT OF ZERO SLOPE TO BE PEAK.
C ******* CHECK FOR TWO CONSECUTIVE TROUGHS. IGNORE SUBSEQUENT TROUGHS
C ******* UNTIL A PEAK IS FOUND.ILAST=-1 FOR TROUGH.
C***********************************************************************
   50    IF (JP.EQ.0) GO TO 100
         IF(ILAST.EQ.-1)GO TO 100
         JT = JT+1
         ITRF(JT) = I
         ILAST=-1
  100 CONTINUE
C***********************************************************************
C ******* ASSIGN LAST POINT OF TROUGH ARRAY TO BE LAST SAMPLE. IF NO
C ******* PEAKS FOUND, DEFAULT SET JP TO ONE POINT.
C***********************************************************************
      ITRF(JT+1) = nsampo
C
  150 CONTINUE
      IF(JP.EQ.0)JP=1
      RETURN
      END
