C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C     PROGRAM MODULE  revtr
C
C**********************************************************************C
C
C REVTR READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C and reverses the trace order of each record, then writes the output
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER     ITR ( SZLNHD )
      INTEGER     LHED( SZLNHD )
      INTEGER     itrh
      pointer     (wkaddr, itrh(1))
      REAL        xtr ( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LBYTES, NBYTES
      integer     argis
      integer     errcod,abort
      logical     sign, heap, rnum, reverse, flip
      CHARACTER   NAME * 5, ntap * 256, otap * 256
#include <f77/pid.h>
      logical     verbos,query
 
      EQUIVALENCE ( ITR(  1), LHED(1) )
      DATA NAME     /'REVTR'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /
      DATA abort / 0 /

c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help ()
           stop
      endif

c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE ARGUMENT STRING
C**********************************************************************C
      call cmdln (ntap,otap,nrst,nred,rnum,verbos, sign,
     1            reverse,flip)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )

      lbytes = 0
      CALL RTAPE ( LUIN, ITR, LBYTES           )
      if(lbytes .eq. 0) then
         write(LERR,*)'REVTR: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt ( ITR , LBYTES, NAME, 5, LERR        )

c---------------------------------
c  save key header values
#include <f77/saveh.h>
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
c----------------------------------
c  check default values
      if(nrst .eq. 0) nrst=1
      if(nred .eq. 0) nred=nrec
      nrecc=nred-nrst+1
c------------------------------------------------------
c  save headers: exchange # traces/rec & # samples/rec
       call savew( itr, 'NumRec', nrecc , LINHED)

c---------------------------------
c  verbos printout
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec
        write(LERR,*) ' Output records     =  ', nrecc
        write(LERR,*) ' Format of Data     =  ', iform
        if (reverse)
     1  write(LERR,*) ' reverse trace order within record'
        if (flip)
     1  write(LERR,*) ' flip traces within record'

c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

      items = ntrc * (nsamp + ITRWRD)
      call galloc (wkaddr, items*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
 
c-----------------------------------------------
c  adjust historical line header & write header
      call savhlh ( itr, lbytes, lbyout )
 
      call wrtape(luout,itr,lbyout)

c------------------------------------------------
c  skip to start record
      call recskp(1,nrst-1,luin,ntrc,itr)

      items = nsamp + ITRWRD
C**********************************************************************C
C
C     READ RECORD, DO TRANSPOSE, WRITE OUTPUT RECORD
C
C**********************************************************************C
 
      DO 100 JJ = NRST, NRED

c----------------------
c  read record & store
c----------------------
           DO 99 KK = 1, NTRC
                 nbytes = 0
                 CALL RTAPE  ( LUIN , ITR, NBYTES         )
                 if(nbytes .eq. 0) then
                    write(LERR,*)'End of file on input:'
                    write(LERR,*)'  rec= ',jj,'  trace= ',kk
                    go to 999
                 endif
c-------------------
c  save traces
                 istrc = (kk-1) * items
                 do 56  ii = 1, items
                      itrh( istrc + ii) = itr ( ii )
   56            continue
 
   99      CONTINUE

           
c-------------------
c   reverse traces
c-------------------
           IF (reverse) THEN

              ic = 0
              DO   KK = NTRC, 1, -1
                  ic = ic + 1
                  istrc = (kk-1) * items
                  do    ii = 1, items
                        itr ( ii ) = itrh( istrc + ii)
                  enddo
                  if (flip) then
                     call vmov  (itr(ITHWP1), 1, xtr, 1, nsamp)
                     call vrvrs (xtr, 1, nsamp)
                     call vmov  (xtr, 1, itr(ITHWP1), 1, nsamp)
                  endif
                  if ( sign ) then
                       call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                             idist  , TRACEHEADER)
                       idist = -1 * idist 
                       call savew2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                             idist  , TRACEHEADER)

                  endif
                  if (rnum) then
                     call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                           ic     , TRACEHEADER)
                  endif

                  CALL WRTAPE  ( LUOUT , ITR, NBYTES         )
 
              ENDDO
c-------------------
c   flip traces
c-------------------
           ELSE

              ic = 0
              DO   KK = 1, NTRC
                  ic = ic + 1
                  istrc = (kk-1) * items
                  do   ii = 1, items
                       itr ( ii ) = itrh( istrc + ii)
                  enddo
                  if (flip) then
                     call vmov  (itr(ITHWP1), 1, xtr, 1, nsamp)
                     call vrvrs (xtr, 1, nsamp)
                     call vmov  (xtr, 1, itr(ITHWP1), 1, nsamp)
                  endif
                  if ( sign ) then
                       call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                             idist  , TRACEHEADER)
                       idist = -1 * idist
                       call savew2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                             idist  , TRACEHEADER)
 
                  endif
                  if (rnum) then
                     call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                           ic     , TRACEHEADER)
                  endif
 
                  CALL WRTAPE  ( LUOUT , ITR, NBYTES         )
              ENDDO

           ENDIF
           if(verbos) then
              write(LERR,*) 'Transposed Record=  ',jj
           endif
  100 CONTINUE

  999 continue
       call lbclos(luin)
       call lbclos(luout)
      END

c------------------------------
c  online help section
c------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for REVTR: reverse traces'
        write(LER,*)'and/or flip trace record-by-record'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-rs[nrst]  -- start record                 (first)'
        write(LER,*)'-re[nred]  -- end record                    (last)'
        write(LER,*)'-F         -- flip traces (rather than reverse orde
     1r of traces in record)'
        write(LER,*)'-norev     -- turn off reverse trace order'
        write(LER,*)'-R         -- renumber traces'
        write(LER,*)'-S         -- change sign of distances'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        revtr -N[] -O[] -rs[] -re[]'
        write(LER,*)'               [-norev -F -R -S -V]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c    nrst   - I      start record
c    nred   - I      stop end record
c     sign  - L      change sign of trace distances
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,nrst,nred,rnum,verbos, sign,
     1                  reverse,flip)
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      integer    argis,nrst,nred
      logical    verbos, sign, rnum, reverse, flip, norev

          call argstr('-N',ntap,' ',' ') 
          call argstr('-O',otap,' ',' ') 
          call argi4('-rs',nrst,1,1)
          call argi4('-re',nred,0,0)
           rnum  = (argis('-R') .gt. 0)
           sign  = (argis('-S') .gt. 0)
           flip  = (argis('-F') .gt. 0)
           norev = (argis('-norev') .gt. 0)
           reverse = .true.
           if (norev) reverse = .false.
          verbos = (argis('-V') .gt. 0)

      return
      end
