C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c get machine dependent parameters 
c
c     Roald's Interbed Prediction
c     Converted from Roald's original
c     Delft Code to USP by James Gridley
c     Summer 1998
c     USP Team Tulsa Ok
c
c
c
c

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
      integer     itr2 ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     luin2, lbytes2, nx, nf
      integer     ist, iend, irs, ire, argis

      character   ntap*255, ntap2*255, otap*255, name*4

      logical     verbos

c Program Specific _ dynamic memory variables

      integer RecordSize, HeaderSize, errcd1, errcd2,CRecordSize
      integer  errcd3, abort
      integer Headers, TraceSize, XSize, KSize, Headers2

      real    Record, Space,  eps
      real    Record2, ttap, xtap, ktap, etap

      complex ct, cdat_mut, cdat_hor, cx_mut, cx_hor
      complex  cterm,cdat

      pointer (memadr_Record, Record(200000))
      pointer (memadr_Record2, Record2(200000))
      pointer (memadr_Space, Space(200000))
      pointer (memadr_Headers, Headers(200000))
      pointer (memadr_Headers2, Headers2(200000))
      pointer (memadr_ttap, ttap(200000))
      pointer (memadr_xtap, xtap(200000))
      pointer (memadr_ktap, ktap(200000))
      pointer (memadr_etap, etap(200000))
      pointer (memadr_ct, ct(200000))
      pointer (memadr_cdat_mut, cdat_mut(200000))
      pointer (memadr_cdat_hor, cdat_hor(200000))
      pointer (memadr_cx_mut, cx_mut(200000))
      pointer (memadr_cx_hor, cx_hor(200000))
      pointer (memadr_cterm, cterm(200000))
      pointer (memadr_cdat, cdat(200000))

c Program Specific _ static memory variables

      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor

      integer hdr_index, tr_index, JJ, KK

      real pie, df, dlabda
      
      
c Initialize variables

      data abort/1/
      data name/"RIP"/

      pie = 4.0 * atan(1.0)

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif
      
c     open printout file
      
#include <f77/open.h>
      
c     get command line input parameters
      
      call cmdln ( ntap, ntap2, otap, irs, ire, ist, iend, 
     :     name, verbos, nf, nx, dx, eps, ttaper,xtaper )
      
c     open input and output files
      
      call getln(luin , ntap,'r', 0)
      call getln(luin2 , ntap2,'r', 0)
      call getln(luout, otap,'w', 1)
      
      call lbopen (luin2, ntap2,'r')
      
      
c     read input line header and save certain parameters
      
      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'RIP: no line header on input file',ntap
         write(LER,*)'FATAL'
         stop
      endif
      
      call rtape  ( luin2, itr2, lbytes2)
      if(lbytes .eq. 0) then
         write(LER,*)'RIP: no header read from unit ',ntap2
         write(LER,*)'FATAL'
         stop
      endif
      
      
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)


      if (unitsc .eq. 0.) then
         unitsc = 0.001
      endif

c     print HLH to printout file 
      
      call hlhprt (itr, lbytes, name, 4, LERR)
      
c     check user supplied boundary conditions and set defaults
      
      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec
      
      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp
      
      nreco = ire - irs + 1
c
c
c     Calculate the next power of 2 for padding

      if (nf .eq. 0) then
         ipower_nf =1
 240     if(nsamp .gt. 2**ipower_nf .and.
     :        nsamp .le. 2**int(ipower_nf+1)) then
            nf=2* 2**int(ipower_nf+1)
            go to 220
         else
            ipower_nf=ipower_nf+1
            go to 240
         endif
      endif

 220  if (nx .eq. 0) then
         ipower_nx =1
 230     if(ntrc .gt. 2**ipower_nx .and.
     :        ntrc .le. 2**int(ipower_nx+1)) then
            nx=2* 2**int(ipower_nx+1)
            go to 250
         else
            ipower_nx=ipower_nx+1
           
            go to 230
         endif
      endif

c======================================================================  
 250  dt= real(nsi)*unitsc
      df = 1. /(nf*dt)
      dlabda = 1./(nx*dx)
c      nfstart = 0
       nfstart = 1
      nfend = int (1. / ( dt * 2.))
c====================================================================== 
c     Definitions
c     
c     nf = power of 2 *2 in time
c     nx = power of 2 *2 in space
c     nfstart = staring frequency
c     nfend = ending frequency (nyquist)
c     nsamp = number of samples
c     dx = trace spacing
c     dt = time interval
c     eps = complex part of frequencies used
c
c======================================================================

c     modify line header to reflect actual record configuration output
c     NOTE: in this case the trace and sample limits are used to 
c     limit processing only.   All data within the selected record
c     range are actually passed.
      
      call savew(itr, 'NumRec', nreco, LINHED)
      
c     number output bytes
      
      obytes = SZTRHD + SZSMPD * nsamp 
      
c     save out hlh and line header
      
      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )
      
c     set up pointers to header mnemonic StaCor
      
      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )
      
c     verbose output of all pertinent information before processing begins
      
      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, verbos)
      
c     dynamic memory allocation:  

      RecordSize = ntrc * nsamp 
      CRecordSize = nf * nx 
      HeaderSize = ntrc * ITRWRD 
      TraceSize = nsamp
      CTraceSize = nf
      XSize = ntrc
      KSize = nx
	iK2=int(nx/2)
      call galloc (memadr_Record, RecordSize * SZSMPD, errcd0, abort)
      call galloc (memadr_Record2, RecordSize * SZSMPD, errcd1, abort)
      call galloc (memadr_Space, RecordSize * SZSMPD, errcd2, abort)
      call galloc (memadr_Headers, HeaderSize * SZSMPD, errcd3, abort)
      call galloc (memadr_ttap, TraceSize * SZSMPD, errcd4, abort)
      call galloc (memadr_Record, RecordSize * SZSMPD, errcd0, abort)
      call galloc (memadr_xtap, XSize * SZSMPD, errcd5, abort)
      call galloc (memadr_ktap, iK2 * SZSMPD, errcd6, abort) 
      call galloc (memadr_etap, TraceSize * SZSMPD, errcd7, abort)   
      call galloc (memadr_Headers2, HeaderSize * SZSMPD, errcd8, abort)
      call galloc (memadr_cx_mut,  2 * nx * SZSMPD,
     :     errcd10, abort)
      call galloc (memadr_cx_hor,  2 * nx * SZSMPD, 
     :     errcd11, abort)
      call galloc (memadr_cterm,  2 * nx * SZSMPD,
     :     errcd12, abort)
      call galloc (memadr_cdat_mut,  2 * CRecordSize * SZSMPD,
     :     errcd13, abort)
      call galloc (memadr_cdat_hor,  2 * CRecordSize * SZSMPD,
     :     errcd14, abort)
      call galloc (memadr_cdat,  2 * CRecordSize * SZSMPD,
     :     errcd15, abort)
      call galloc (memadr_ct,  2 * nf * SZSMPD, errcd9, abort)
      if ( errcd0 .ne. 0 .or.
     :     errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 .or.
     :     errcd8 .ne. 0 .or.
     :     errcd9 .ne. 0 .or.
     :     errcd10 .ne. 0 .or.
     :     errcd11 .ne. 0 .or.
     :     errc12 .ne. 0 .or.
     :     errc13 .ne. 0 .or.
     :     errc14 .ne. 0 .or.
     :     errcd15 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( Record, 1, RecordSize )
      call vclr ( Record2, 1, RecordSize )
      call vclr ( Space, 1, RecordSize )
      call vclr ( Headers, 1, HeaderSize )
      call vclr ( Headers2, 1, HeaderSize )
c======================================================================  
c     Set up some tapers for the transfrom
c
c     etap = exponential taper
c     ttap = temporal taper
c     xtap = space taper (t-x)
c     ktap = space taper (f-k)

c     Exponential Taper
      
      call vclr (etap, 1, TraceSize )
      do i = 1, nsamp 
         etap(i)=exp((i-1)*dt*eps)
      enddo
      
c     Cosine Taper (ttap)   
      call vclr ( ttap, 1, TraceSize )

	do i=1,nsamp
	ttap(i)=1.
	enddo
        jlow = nsamp-int(ttaper*nsamp)
      do i = jlow,nsamp
         ttap(i)= 0.5*cos(pie*real(i-jlow)/real(nsamp-jlow))+0.5
      enddo
	
c     Cosine Taper (xtap)

      call vclr ( xtap, 1, XSize )
      do i=1,ntrc
         xtap(i)=1.
      enddo
      jlow=ntrc-int(xtaper*ntrc)
      do i = jlow,ntrc
         xtap(i)= 0.5*cos(pie*real(i-jlow)/real(ntrc-jlow))+0.5
      enddo  
      
 
c     Cosine Taper (ktap)

      call vclr ( ktap, 1, iK2 )

	do i=1,nx/2
	ktap(i)=1.
	enddo
        jlow = int(nx/2) - (xtaper*int(nx/2))
      do i = jlow+1,int(nx/2)
        ktap(i)= 0.5*cos(pie*real(i-jlow)/real(int(nx/2)-jlow))+0.5
      enddo 


c======================================================================  
c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

c load record to memory

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

          DO KK = 1, ntrc

            nbytes = 0
            call rtape( luin, itr, nbytes)
            call rtape( luin2, itr2, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c set array load points for this trace 

           tr_index = tr_index + nsamp
           hdr_index = hdr_index + ITRWRD

c process only live traces and zero out dead traces

           call saver2 ( itr, ifmt_StaCor, l_StaCor,
     :      ln_StaCor, StaCor, 
     :          TRACEHEADER )

           if ( StaCor .ne. 30000 ) then

c load trace to array Record[]

              call vmov ( itr(ITHWP1), 1,
     :    Record(tr_index), 1, nsamp )
              call vmov ( itr2(ITHWP1), 1,
     :    Record2(tr_index), 1, nsamp )
           else
              call vclr ( Record(tr_index), 1, nsamp )
              call vclr ( Record2(tr_index), 1, nsamp )
           endif

c load trace header to array Headers[]

            call vmov ( itr, 1, Headers(hdr_index), 1, ITRWRD )
            call vmov ( itr2, 1, Headers2(hdr_index), 1, ITRWRD )
         ENDDO
c====================================================================== 
c     Take the records and do Roald's prediction

      call DoForwardTrans (Record, Headers,
     :     Record2, Headers2,
     :     nsamp, ntrc, ist, iend, dt,dx,  nfend,
     :     nf,nx,nfstart,
     :     etap, ttap, Space, ktap,xtap,
     :     ct, cdat_mut, cdat_hor, cx_mut, cx_hor,
     :     cterm, cdat, dlabda)

c====================================================================== 
c reset array load points for this trace 

           tr_index = 1 - nsamp
           hdr_index = 1 - ITRWRD

c write output data

         DO KK = 1, ntrc

            tr_index = tr_index + nsamp
            hdr_index = hdr_index + ITRWRD

            call vmov ( Space(tr_index), 1, itr(ITHWP1), 1, nsamp )
            call vmov ( Headers(hdr_index), 1, itr(1), 1, ITRWRD )
            call wrtape (luout, itr, obytes)
 
         ENDDO
      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'rip: Normal Termination'
      write(LER,*)'rip: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'rip: ABNORMAL Termination'
      write(LER,*)'rip: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for USP program RIP'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N1[]  -- input Multipled data set        (stdin)'
      write(LER,*)'-N2[]  -- input horizon data set          (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-s[]   -- process start time (ms)             (1)'
      write(LER,*)'-e[]   -- process end time (ms)     (last sample)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)'-dx[]  -- offset interval                     (0)'
      write(LER,*)'-eps[] -- Dampening Factor                    (0)'
      write(LER,*)'-nf[]  -- next power of 2 for frequency       (0)'
      write(LER,*)'         Default calculates the appropriate value'
      write(LER,*)'-nx[]  -- next power of 2 for space           (0)'
      write(LER,*)'         Default calculates the appropriate value'
      write(LER,*)'-ttaper[] -- fractional time taper          (0.1)'
      write(LER,*)'-xtaper[] -- fractional space taper         (0.1)'
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'       rip -N[] -O[] -s[] -e[] -rs[] -re[] '
      write(LER,*)'           -dx[] -eps[] -nf[] -nx[] -ttaper[]'
      write(LER,*)'            -xtaper[]  -V'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, ntap2,  otap, irs, ire, ist, iend, 
     :     name, verbos, nf, nx, dx, eps,ttaper,xtaper )

#include <f77/iounit.h>

      integer    ist, iend, irs, ire, argis,nf, nx
      real       dx, eps, ttaper, xtaper
      character  ntap*(*), otap*(*), name*(*), ntap2*(*)

      logical    verbos

      call argr4 ( '-dx', dx , 0., 0. )

      call argr4 ( '-eps', eps, 0., 0. )
      call argi4 ( '-e', iend, 0, 0 )
      
      call argstr ( '-N1', ntap, ' ', ' ' ) 
      call argstr ( '-N2', ntap2, ' ', ' ' ) 

      call argi4 ( '-nf', nf, 0, 0 )
      call argi4 ( '-nx', nx, 0, 0 )

      call argstr ( '-O', otap, ' ', ' ' ) 
      
      call argi4 ( '-re', ire, 0, 0 )
      call argi4 ( '-rs', irs, 0, 0 )
      
      call argi4 ( '-s', ist, 1, 1 )

      call argr4 ( '-ttaper', ttaper, 0.1, 0.1 )

      verbos = (argis('-V') .gt. 0)

      call argr4 ( '-xtaper', xtaper, 0.1, 0.1 )

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, verbos)

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, nsi

      character  ntap*(*), otap*(*)

      logical    verbos

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name    =  ', otap
      write(LERR,*) ' start record            =  ', irs 
      write(LERR,*) ' end record              =  ', ire 
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





