C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine msize(nsi,nsamp,nfft,ist,iend,lenwnd,lenwnd_out,
     1                  rmin,rmax,mmin,mmax,
     2                  fl,fh,ifl,ifh,nf,nfmax,
     3                  pminmodel,pmaxmodel,np,
     4                  pminnoise,pmaxnoise,
     4                  linear,parabolic,hyperbolic,zref,
     5                  offmax,factor,lerr,dt,wbt)

       parameter(pi=3.14159265)
C
       real      dt,pminmodel,pmaxmodel,pminnoise,pmaxnoise,offmax
       integer   mmin,mmax,rmin,rmax
       logical   linear,parabolic,hyperbolic,wbt
       integer   ipwr(4)
c
       if (wbt) then
          if (iend .eq. nsamp) then
             lenwnd=nsamp
          else
             lenwnd=iend-ist+1
          endif
       else
          lenwnd=iend-ist+1
       endif
c      write(0,*)'ist,iend,lenwnd= ',ist,iend,lenwnd

c______________________________________________________________________
c      calculate length of mixed radix fft that fits lenwnd best.  
c      limit to radices 2,3 and 5 to allow use both cray scilib
c      and qtc routines.
c______________________________________________________________________
       call nrfft(lenwnd,5,nfft,ipwr)
       jpad=.1*lenwnd
       if(nfft-lenwnd .lt. jpad) then
c______________________________________________________________________
c         mixed radix fft has insufficient padding to reduce wrap around.
c         explicitly add it.
c______________________________________________________________________
c          lenwnd=lenwnd+jpad

c changing lenwnd here is bad...as it is used in mivs.F to output the
c data.  This change caused the data to overflow into the headers and
c trash the headers.  I will introduce lenwnd_out here and carry it
c to mivs.F for use on output....Garossino

          lenwnd_out = lenwnd
          lenwnd=lenwnd+jpad


          call nrfft(lenwnd,5,nfft,ipwr)
       endif
       nfmax=nfft/2
c_____________________________________________________________________
c      calculate frequency ranges.
c_____________________________________________________________________
c     if (nsi .le. 64) then
c_____________________________________________________________________
c        sample interval nsi assumed to be in milliseconds.
c_____________________________________________________________________
c        dt=.001*nsi
c     else
c_____________________________________________________________________
c        sample interval nsi assumed to be in microseconds.
c_____________________________________________________________________
c        dt=.000001*nsi
c     endif 
 
      freq0=(2.0*dt)*pi*fl             
      ifl=(freq0*nfmax/pi)   
      ifl=max(ifl,1)
      freq1=(2.0*dt)*pi*fh            
      ifh=nint(freq1*nfmax/pi)   
      nf=ifh-ifl+1
      if(linear) then   
c______________________________________________________________________
c        fit multiple/noise trains with linear curves.
c______________________________________________________________________
         factor=nsi*offmax
      elseif(parabolic) then
c______________________________________________________________________
c        fit multiple/noise trains with parabolic curves.
c______________________________________________________________________
         factor=nsi*offmax**2
      elseif(hyperbolic) then
c______________________________________________________________________
c        fit multiple/noise trains with hyperbolic curves.
c______________________________________________________________________
         factor=nsi*(sqrt(offmax**2+zref**2)-zref)
      endif
c
      pminmodel=float(mmin)/factor         
      pmaxmodel=float(mmax)/factor         
      pminnoise=float(rmin)/factor         
      pmaxnoise=float(rmax)/factor         
      write(lerr,*) 'mmin ',mmin,' pminmodel',pminmodel
      write(lerr,*) 'mmax ',mmax,' pmaxmodel',pmaxmodel
      write(lerr,*) 'rmin ',rmin,' pminnoise',pminnoise
      write(lerr,*) 'rmax ',rmax,' pmaxnoise',pmaxnoise
c
      return
      end
