C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine radinv(u,umodel,radon,signal,
     1                   ifl,ifh,np,noise)
c_______________________________________________________________________
C      calculate inverse radon transform from p --> x
c_______________________________________________________________________
c_______________________________________________________________________
C      intermediate solution
c_______________________________________________________________________
       complex    u(ifl:ifh,np)
c_______________________________________________________________________
c      output noise trace.         
c_______________________________________________________________________
       complex    umodel(ifl:ifh)
c_______________________________________________________________________
c      radon transform operator matrix.                         
c_______________________________________________________________________
       complex  radon(ifl:ifh,np)
c
       logical  signal(np)
c
       logical  noise
c
       if(noise) then
c_______________________________________________________________________
c         model the 'noise' component of the data.                 
c_______________________________________________________________________
          do 30000 ip=1,np                 
           if(.not. signal(ip)) then
              do 20000 ifreq=ifl,ifh
               umodel(ifreq)=umodel(ifreq)                 
     1                       +radon(ifreq,ip)*u(ifreq,ip)
20000         continue
           endif
30000    continue
      else
c_______________________________________________________________________
c        model the 'signal' component of the data.
c_______________________________________________________________________
         do 50001 ip=1,np             
          if(signal(ip)) then
             do 40001 ifreq=ifl,ifh
               umodel(ifreq)=umodel(ifreq)
     1                       +radon(ifreq,ip)*u(ifreq,ip)
40001        continue
          endif
50001    continue
c
      endif
C
      return
      end
