C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine rdparm(nsi,nsamp,nrec,ntr,nsm,nem,nsa,nea,
     1                   ist,iend,fl,fh,mmin,mmax,hdrwrd,wbt,
     2                   np,minlive,rmin,rmax,nttaper,tscl,
     3                   xmin,xmax,offmax,white,verbos,dx,bigmem,
     4                   taper,linear,parabolic,hyperbolic,zref,
     5                   nptaper,interpolate,pass,lerr,ierror,
     6                   mute,unitsc)
 
       character  hdrwrd * 6
       integer    argis
       integer    ist,iend,nsi,nsamp,nsm,nem,nsa,nea,irs,ire
       integer    mmin,mmax
       integer    np,minlive,rmin,rmax,nttaper
       real       white,xmax,dtmsec,unitsc,dt,tscl
       logical    verbos,bigmem
       logical    interpolate
       logical    taper,linear,parabolic,hyperbolic 
       logical    pass
       logical    mute
       logical    wbt
c
       data       undefined/1.23456e+12/
 
       dt = float(nsi) * unitsc
       dtmsec = 1000 * dt

       irs  = 1
       ire  = nrec
       ierror=0           

       call argstr ('-hw', hdrwrd, ' ', ' ')
       if (hdrwrd(1:1) .ne. ' ') then
          wbt = .true.
       else
          wbt = .false.
       endif
       call argr4 ('-tscl',tscl,2.,2.)

       call argi4 ('-s',ist,0,0)
c      call argi4 ('-e',iend,nsi*nsamp,nsi*nsamp)
       call argi4 ('-e',iend, 0 , 0 )
       if (iend .eq. 0) iend = nsi*nsamp

       call argr4 ('-fl',fl,5.,5.)
       call argr4 ('-fh',fh,0.,0.)

       call argr4 ('-dx',dx, 0.0 , 0.0 )
       if (dx .eq. 0.0) dx = undefined

       if(verbos) then
         iprint = 1
       else
         iprint = 0
       endif
c
c________________________________________________________________________
c      enter moveout parameters that are to be modeled:
c      (allow for old shell scripts with -id0 and -id1 to be honored).
c      
c      mmin.....minimum moveout to be modeled. (was -id0 option)
c      mmax.....maximum moveout to be modeled. (was -id1 option)
c________________________________________________________________________
       call argi4 ('-id0',id0,999999,999999)
       call argi4 ('-id1',id1,999999,999999)
       if(id0 .ne. 999999) then
          mmin=id0
       else
          call argi4('-mmin',mmin,0,0)               
       endif
       if(id1 .ne. 999999) then
          mmax=id1
       else
          call argi4('-mmax',mmax,0,0)               
       endif
c________________________________________________________________________
c      enter moveout parameters that are to be rejected:
c      (allow for old shell scripts with -jd0 and -jd1 to be honored).
c      
c      rmin.....minimum moveout to be rejected: (was -jd0 option)
c      rmax.....maximum moveout to be rejected: (was -jd1 option)
c________________________________________________________________________
       call argi4 ('-jd0',jd0, 999999,999999)
       call argi4 ('-jd1',jd1, 999999,999999)
       if(jd0 .ne. 999999) then
          rmin=jd0
       else
          call argi4 ('-rmin',rmin, 999999,999999)
       endif
       if(jd1 .ne. 999999) then
          rmax=jd1
       else
          call argi4 ('-rmax',rmax, 999999,999999)
       endif
c________________________________________________________________________
c      if either of the reject limits have not been set, set them to
c      be equal to the modeled limits.
c________________________________________________________________________
       if(rmin .eq. 999999) then
          rmin=mmin
       endif
       if(rmax .eq. 999999) then
          rmax=mmax
       endif
c
       call argi4 ('-np',np,0,0)

       call argr4 ('-xmin',xmin,0.,0.)               

c      call argr4 ('-xmax',xmax,undefined,undefined)
c      call argr4 ('-zref',zref,undefined,undefined)
       call argr4 ('-xmax',xmax,0.0,0.0)
       call argr4 ('-zref',zref,0.0,0.0)
       if (xmax .eq. 0.0) xmax = undefined
       if (zref .eq. 0.0) zref = undefined

       call argr4 ('-prew',white,5.0,5.0)
       call argi4 ('-live',minlive,1,1)
       call argi4 ('-nsm',nsm,1,1)
       call argi4 ('-nem',nem,0,0)
 
       mute=(argis('-mute') .gt. 0)  
       interpolate=(argis('-I') .gt. 0)  
       if(argis('-L') .gt. 0) then 
          linear=.true.
       else
          linear=.false.
       endif
       if(argis('-P') .gt. 0) then 
          parabolic=.true.
       else
          parabolic=.false.
       endif
       if(argis('-H') .gt. 0) then 
          hyperbolic=.true.
       else
          hyperbolic=.false.
       endif
       if(.not. linear .and. .not. hyperbolic) then
          parabolic=.true.
       endif
       if(argis('-pass') .gt. 0) then 
          pass=.true.
       else
          pass=.false.
       endif

       noptions=0 
       if(linear) noptions=noptions+1
       if(parabolic) noptions=noptions+1
       if(hyperbolic) noptions=noptions+1
       if(noptions .ne. 1) then         
          write(lerr,*) 'error in routine rdparm'
          write(lerr,*) 'must enter one and only one of the'
     1                  //' following options'
          write(lerr,*) '-L,   -P,   -H'                              
          write(lerr,*) 'check command line'
          ierror=ierror+1
       endif
       if (nem .eq. 0) nem = ntr

       call cmdchk(nsm,nem,irs,ire,ntr,nrec)


       call argi4 ('-nsa',nsa,0,0)             
       call argi4 ('-nea',nea,0,0)             
       if (nsa .eq. 0) nsa = nsm
       if (nea .eq. 0) nea = nem

       call argi4 ('-taper',nttaperold,999999,999999)
       call argi4 ('-ttaper',nttaper,0,0)                 

       if (nttaperold .ne. 999999) nttaper = nttaperold
       call argi4 ('-ptaper',nptaper,0,0)
       if(nttaper .gt. 0) then
          taper=.true.
       else
          taper=.false.
       endif

       call cmdchk(nsa,nea,irs,ire,ntr,nrec)

       if(ist.ge.iend) then      
          write(lerr,*) 'error in rdparm !' 
          write(lerr,*) 'start time = ',ist
          write(lerr,*) 'exceeds end time = ',iend
          ierror=ierror+1
       endif
 
       ist = ist/nsi
       iend = iend/nsi
       if (.not.wbt) then
          if (ist .le. 0) ist = 1
       endif
          
       if (iend .le. 0) iend = nsamp
       nttaper = nttaper/nsi
       if(xmax .eq. undefined) then
          write(lerr,*) 'error in routine rdparm'
          write(lerr,*) 'must supply -xmax option'
          ierror=ierror+1
       endif
c
       offmax=max(abs(xmax),abs(xmin))
c
       if(zref .eq. undefined) then
          zref=offmax
       endif
c
       if(dx .eq. undefined) then
          bigmem=.false.
       else
          bigmem=.true.
       endif
       if(xmin .ge. xmax) then
          write(lerr,*) 'error in routine rdparm'
          write(lerr,*) 'xmax must exceed xmin!'
          write(lerr,*) 'xmin = ',xmin
          write(lerr,*) 'xmax = ',xmax
          ierror=ierror+1
       endif
       if(dx .le. 0.) then
          write(lerr,*) 'error in routine rdparm'
          write(lerr,*) 'dx must be entered as a positive number!'
          write(lerr,*) 'dx = ',dx       
          ierror=ierror+1
       endif
c
       fmax=1000./(2.*dtmsec)
       if(fh .eq. 0.) then
          fh=fmax
          write(lerr,*)'Upper freq limit defaulted to ',fh    
       endif
c
       if(fl .lt.0.) then
          write(lerr,*) 'error! fl = ',fl,' less than 0.' 
          ierror=ierror+1
       endif
c
       if(fl .ge. fh) then
          write(lerr,*) 'error! fl .gt. fh '
          write(lerr,*) 'fl = ',fl
          write(lerr,*) 'fh = ',fh
          ierror=ierror+1
       endif
c
       if(fh .gt.fmax) then
          write(lerr,*) 'error! fh exceeds fmax'
          write(lerr,*) 'fh = ',fh
          write(lerr,*) 'fmax = ',fmax
          ierror=ierror+1
       endif
       
       if(np .le. 0) then
          np=2*fh*(mmax-mmin)/1000
          write(lerr,*)'Number of parameters defaulted to ',np
       endif

       if((white.lt.0.0).or.(white.gt.100.)) then
         write(lerr,*) ' invalid white noise parameter:',white
         write(lerr,*) ' needs to lie between 0. and 100.'
         ierror=ierror+1
       endif
       white = white/100.

c
       if (zref .lt. 0.) then  
         write(lerr,*) ' invalid reference depth (zref < 0.)',zref
         ierror=ierror+1
       endif

      if(minlive .le.0) then
         write(lerr,*) ' invalid number of live traces:',minlive
         ierror=ierror+1
      endif

      if(nttaper.gt.(iend-ist)) then
         write(lerr,*) ' taper longer than window length:',nttaper
         write(lerr,*) ' ist       = ',ist
         write(lerr,*) ' iend      = ',iend
         write(lerr,*) ' iend-ist  = ',iend-ist
         write(lerr,*) ' nttaper   = ',nttaper
         ierror=ierror+1
      endif
 
      if(mmin.gt.rmin) then
         write(lerr,*) ' command line error!'        
         write(lerr,*) ' mmin = ',mmin,' exceeds'
         write(lerr,*) ' rmin = ',rmin
         ierror=ierror+1
      endif
 
      if(mmax.lt.rmax) then
         write(lerr,*) ' command line error!'        
         write(lerr,*) ' mmax = ',mmax,' less than'
         write(lerr,*) ' rmax = ',rmax
         ierror=ierror+1
      endif

      if(mmin.ge.mmax) then
         write(lerr,*) 'invalid model parameter range!'       
         write(lerr,*) 'mmin = ',mmin                    
         write(lerr,*) 'mmax = ',mmax                    
         ierror=ierror+1
      endif

      if(rmin.ge.rmax) then
         write(lerr,*) 'invalid noise rejection parameter range!'       
         write(lerr,*) 'rmin = ',rmin                    
         write(lerr,*) 'rmax = ',rmax                    
         ierror=ierror+1
      endif
C
      return
      end
