C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Calculate_StanDev ( Record, Space, nsamp, ntrc, ist, 
     :     iwin_sample, Average_Val, Stan_Dev, A_Dev, Max_A_Dev, 
     :     Number_Windows )

#include <save_defs.h> 
#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer nsamp, ntrc, ist
      integer iwin_sample
      integer Number_Windows
      
      real Record ( nsamp, ntrc )
      real Space ( nsamp, ntrc )
      real Stan_Dev ( nsamp, ntrc )
      real Average_Val ( nsamp, ntrc )
      real A_Dev ( nsamp, ntrc )  
      real Max_A_Dev ( nsamp, ntrc )

c declare local variables

      integer j, k, m, iwin_start

c     process data
      
      DO j = 1, ntrc
         
c     process live traces only
         
         do k = 1, Number_Windows - 1 

            iwin_start = iwin_sample * (k-1) + ist
            
            do m = iwin_start, iwin_start + iwin_sample - 1
               
               Stan_Dev(k,j) = (Stan_Dev(k,j) +
     :              (Record(m,j) - Average_Val(k,j))**2)

c Maximum Average Deviation

                  Max_A_Dev(k,j) = Max_A_Dev(k,j) +
     :              (abs(Record(m,j)) - A_Dev(k,j))

            enddo

            Stan_Dev(k,j) = sqrt(Stan_Dev(k,j)/(iwin_sample-1))
            Max_A_Dev(k,j) = (Max_A_Dev(k,j)/(iwin_sample))

         enddo

c Pick up the end of the data

         if ((Number_Windows-1)*iwin_samples .le. nsamp) then

          do m = nsamp - iwin_sample, nsamp

              Stan_Dev(k,j) = (Stan_Dev(k,j) +
     :             ( (Record(m,j)- Average_Val(k,j))**2))
              Max_A_Dev(k,j) = Max_A_Dev(k,j) +
     :             ( abs(Record(m,j))- A_Dev(k,j))

          enddo

          Stan_Dev(Number_Windows,j) = 
     :      sqrt(Stan_Dev(Number_Windows,j)/(iwin_sample-1))
          Max_A_Dev(Number_Windows,j) = 
     :         (Max_A_Dev(Number_Windows,j)/(iwin_sample))

         endif
         
      ENDDO

c      do i = 1, Number_Windows
c         do j = 1,ntrc
c            write(6,*)i*1.,j*1.,Stan_Dev(i,j),Average_Val(i,j),
c     :        A_Dev(i,j),Max_A_Dev(i,j)
c            write(6,*)i,j,Max_A_Dev(i,j)
c         enddo
c      enddo

      return
      end
