c***********************************************************************
c                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c                                                                      *
c***********************************************************************
c  routine:       mdians                                               *
c  routine type:  function  real                                       *
c  purpose:                                                            *
c      implement a procedure to find the median of the elements in an  *
c      array, some of which may correspond to samples from dead        *
c      traces, for stacking.  a statistical count is kept of the       *
c      number of times the data value from each input array element    *
c      is included in the stack.                                       *
c                                                                      *
c  entry points:                                                       *
c      mdians  real  (luprt,nfold,ntlive,b,livetr,istat,ipntr,tabul8)  *
c  arguments:                                                          *
c      luprt   integer       i           -                             *
c      nfold   integer       i           -                             *
c      ntlive  integer       i           -                             *
c      b       real     ??iou*  (nfold) -                              *
c      livetr  logical  ??iou*  (nfold) -                              *
c      istat   integer  ??iou*  (nfold) -                              *
c      ipntr   integer  ??iou*  (nfold) -                              *
c      tabul8  logical  ??iou*           -                             *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 86/09/19  *
c  language: fortran 77                  date last compiled: 86/09/19  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:                                                    *
c      srtqkp -                                                        *
c  intrinsic functions called:                                         *
c      mod     generic -                                               *
c  files:                                                              *
c      luprt  ( output sequential ) -                                  *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:                                                     *
c      if nfold or ntlive are less than 1, the function value is       *
c      set to zero.                                                    *
c                                                                      *
c  general description:                                                *
c      implement the median algorithm for finding the representative   *
c      value of nfold points in vector b.                              *
c                                                                      *
c  revised by:  bill done                     revision date: 86/09/19  *
c      modified to eliminate need to sort dead trace values to rear    *
c      of b vector.                                                    *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
c
      real function mdians (luprt , nfold , ntlive, b, livetr, istat,
     *                      ipntr , tabul8)
c
      logical livetr(nfold), oddntl, tabul8
      integer istat(nfold), ipntr(nfold)
      real b(nfold)
      data iprint/0/
c
c     print the function name and window size
c
      if (iprint .eq. 0) then
         iprint = 1
         nmd2 = nfold/2
         nmd2p1 = nmd2 + 1
         write (luprt,1200) nfold, nmd2, nmd2p1
 1200    format(/' MDIANS:  nfold = ',i5,3x,'nfold/2 = ',i5,3x,
     *           '(nfold/2)+1 = ',i5/)
      endif
c
c     set mdians to zero if nfold < 1 or ntlive < 1
c
      if ((nfold .lt. 1) .or. (ntlive .lt. 1)) then
         mdians = 0.0
         return
      endif
c
c     set mdians to b(nfold) if nfold = 1.
c
      if (nfold .eq. 1) then
         mdians = b(nfold)
         if (tabul8) istat(nfold) = istat(nfold) + 1
         return
      endif
c
c     sort the ntlive elements of b, which are at the front of b.
c
      call srtqkp(ntlive,b,nfold,ipntr)
c
c     find center index of array b (if ntlive is odd, nd2p1 is center;
c     if ntlive is even, nd2 and nd2p1 are the center 2 values)
c
      nd2 = ntlive/2
      nd2p1 = nd2 + 1
c
c     find the mdians value of the data in b and update the data
c     value count
c
      oddntl = mod(ntlive,2) .eq. 1
      if (oddntl) then
         mdians = b(nd2p1)
       else
         mdians = 0.5*(b(nd2) + b(nd2p1))
      endif
c
c     if this time step is to be tabulated (tabul8 = .true.),
c     then the statistics vector is updated.  the pointer vector
c     is used to update the element in istat corresponding to
c     the data value being stacking in b.
c
      if (tabul8) then
         if (oddntl) then
            istat(ipntr(nd2p1)) = istat(ipntr(nd2p1)) + 1
          else
            istat(ipntr(nd2)) = istat(ipntr(nd2)) + 1
            istat(ipntr(nd2p1)) = istat(ipntr(nd2p1)) + 1
         endif
      endif
      return
      end
