c***********************************************************************
c                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c***********************************************************************
c  routine:       rostae                                               *
c  routine type:  main                                                 *
c  purpose:                                                            *
c      rost forms the input/output driver for testing robust           *
c      estimators for stacking.                                        *
c                                                                      *
c  entry points:  mainline entry                                       *
c  arguments:     none                                                 *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 88/08/30  *
c  language: fortran 77                  date last compiled: 88/08/30  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:                                                    *
c      secon1          -                                               *
c      opnlst          -                                               *
c      gamoco          -                                               *
c      rdparm          -                                               *
c      lbopen          -                                               *
c      ccexit          -                                               *
c      rtape           -                                               *
c      hlhprt          -                                               *
c      wrtape          -                                               *
c      move            -                                               *
c      lbclos          -                                               *
c      detmut          -                                               *
c      mdians  real    -                                               *
c      alftms  real    -                                               *
c      rngtms  real    -                                               *
c      asrtms  real    -                                               *
c      srtint          -                                               *
c  intrinsic functions called:                                         *
c      iabs    integer -                                               *
c      mod     generic -                                               *
c      min0    integer -                                               *
c      max0    integer -                                               *
c  files:                                                              *
c      luprt   ( output sequential ) -                                 *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  errors which cause a termination of the program    *
c                   are concerned mostly with reading the input tape   *
c                   and discrepancies between parameters read from     *
c                   the input tape and this program.                   *
c  general description:                                                *
c      this program provides the input/output control for experimental *
c      stacking algorithms.                                            *
c                                                                      *
c  revised by:  bill done                     revision date: 88/08/30  *
c      rostae created from roste2. install historical line header      *
c      update capability (capatible with sun and cray).  install       *
c      include file ludefs.h.                                          *
c                                                                      *
c  revised by:  bill done                     revision date: 88/08/31  *
c      install include file hdrsize.h, adjust rx and ix so that        *
c      rx(1) = ix(ithwp1), where ithwp1 is the number of words in      *
c      the trace header plus 1 for the computer system in use.         *
c      calls to move are replaced with calls to qtc mathadvantage      *
c      vclr and vmov.  use saver and savew to update line and trace    *
c      headers.                                                        *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
c
      program rostae
c
#include <save_defs.h>
c
#include <f77/LUDefs.h>
#include <f77/lhdrsz.h>
c>ibm parameter (lucard = 5, luprt = 6, luntap = 14, luotap = 24)
c
c#include <f77/HeaderSize.h>
c
      parameter (mxnspt = 6000, mxfold = 300)
      parameter (mxabuf = mxnspt*mxfold, mxhbuf = itrwrd*mxfold)
c
c>ibm integer*2 ilh(3000), ix(ithwp1), itrh(mxhbuf)
c>ibm integer*4 nlh(1500)
      integer   ix(SZLNHD), itrh(mxhbuf)
      integer   nlh(SZLNHD)
      integer   imute(mxfold), istat(mxfold)
      integer   ipntr(mxfold), ipsave(mxfold)
      real      rx(mxnspt), a(mxabuf), b(mxfold), c(mxnspt)
      logical   lvtrsv(mxfold), livetr(mxfold), tabul8, trlive
      logical   renum
c>ibm equivalence (nlh(1),ilh(1))
c     equivalence (rx(1),ix(ithwp1))
c
c     functions
c
      real mdians, alftms, rngtms, asrtms
c
      character arr1*20, arr2(4)*33
      character icard*80, cardid*4, gtitle(2)*33, name*4
      integer lnarr2(4)
c
c     definitions for input/output cray path names and
c     command line arguments
c
      logical verbos
      character ntap*256, otap*256, cfile*256
c
c     data statements for program name and hlh information
c
      data cardid    /'ROST'/
      data arr1      /'ROST -- Robust Stack'/
      data arr2(1)   /'  (median)                       '/
      data arr2(2)   /'  (alpha trimmed mean)           '/
      data arr2(3)   /'  (range trimmed mean)           '/
      data arr2(4)   /'  (asymmetric range trimmed mean)'/
      data lnarr1    /20/
      data lnarr2    /10,22,22,33/
      data gtitle(1) /'                           Robust'/
      data gtitle(2) /' Stack                           '/
c
c     start timing, total program (outer timing loop).
c     initialize parameters for inner loop.
c
      call secon1 (cputo0, wallo0)
      cputi = 0.0
      walli = 0.0
c
c     set up file to receive program run information
c
      call opnlst (LUPRT, LUER, LUPPRT, cardid)
c
c     call banner page routine
c
      call gamoco (gtitle, 1, luprt)
c
c     print program name and version
c
      write (luprt,1000)
 1000 format(//' Program Rost, version rostae'///)
c
c     read data card, interpret card parameters, default or check for
c     unreasonable card parameters.
c
      call rdparm (luso  , luprt , lucard, cardid, name  , ntap  ,
     *             otap  , cfile , ialgor, nfold , range , inirec,
     *             notrpr, icard , verbos, renum)
c
c     open input tape
c
c>ibm call lbopen (luntap)
      if (ntap .ne. ' ') then
c
c        open input for data from a file
c
         call lbopen (luntap, ntap, 'r')
       else
c
c        open input for data from a pipe
c
         luntap = 0
      endif
c
c     check for proper input unit number
c
      if (luntap .lt. 0) then
         write (luprt,1020) luntap
 1020    format(/' Could not open unit ',i3,' for input.'/)
         stop 1020
      endif
c
c     read input line header and check input tape requirements
c
      lbytes = 0
      call rtape (luntap, nlh, lbytes)
c
c         check for successful read
c
      if (lbytes .eq. 0) then
         write (luprt,1100)
 1100    format (' -EOF encountered attempting to read input tape'/
     *           ' -Execution terminated')
         stop 1100
      endif
c
c     define input data set parameters:
c         number of traces/record, records, samples/trace, data format
c
c>ibm ntpr = nlh(13)
c>ibm nrecs = nlh(14)
c>ibm nspt = nlh(16)
c>ibm iform = ilh(33)
      call saver (nlh, 'NumTrc', ntpr , linhed)
      call saver (nlh, 'NumRec', nrecs, linhed)
      call saver (nlh, 'NumSmp', nspt , linhed)
      call saver (nlh, 'Format', iform, linhed)
      call saver (nlh, 'UnitSc', unitsc,LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(nlh, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('FlDtEl',ifmt_FlDtEl,l_FlDtEl,ln_FlDtEl,TRACEHEADER)
      call savelu('SrcPnt',ifmt_SrcPnt,l_SrcPnt,ln_SrcPnt,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)

c
c     input data must be format 3
c
      if (iform .ne. 3) then
         write (luprt,1200)
 1200    format (' -Input tape is not sis format 3'/
     *           ' -Execution terminated')
         stop 1200
      endif
c
c     check that input data trace length is within program limitation
c
      if (nspt .gt. mxnspt) then
         write (luprt,1400) mxnspt
 1400    format (' -Number of samples/trace on input tape is',
     *           ' greater than ',i5/' -Execution terminated')
         stop 1400
      endif
c
c     if nfold is zero, set equal to input record size, ntpr.
c     fold (stacking window width) must equal the number
c     of traces per record in input data.
c
      if (nfold .eq. 0) nfold = ntpr
      if (nfold .ne. ntpr) then
         write (luprt,1410) nfold, ntpr
 1410    format (' -Number of traces to stack = ',i5/
     *           '  is not equal to the input record size = ',i5/
     *           ' -Execution terminated')
         stop 1410
      endif
      if ((nfold .lt. 2) .or. (nfold .gt. mxfold)) then
         write (luprt,1420) nfold, mxfold
 1420    format(' -Number of traces in lateral stacking window = ',i5,
     *          ' is < 2 or > ',i5/
     *          ' -Execution terminated')
         stop 1420
      endif
c
c     store new information in historical line header
c
      write (luprt,1430)
 1430 format(///)
      call hlhprt (nlh, lbytes, arr1        , lnarr1        , luprt)
      call hlhprt (nlh, lbytes, arr2(ialgor), lnarr2(ialgor), luprt)
      write (luprt,1430)
      mbytes = iszbyt*nspt
      nbytes = mbytes + iszbyt*itrwrd
c
c     set output data set number of records and traces/record.
c
      if (mod(nrecs,notrpr) .eq. 0) then
         nrecso = nrecs/notrpr
       else
         nrecso = (nrecs/notrpr) + 1
      endif
c>ibm nlh(13) = notrpr
c>ibm nlh(14) = nrecso
      if(renum) then
         if(notrpr .ne. 1) then
            write(luprt,*) 'ntpr = ',ntpr,' .ne. 1 !'
            write(luprt,*) 'cannot do a simple renumbering using -R'
     1               //' option'
            call exitfu(666)
         endif
         call savew (nlh, 'NumTrc', nrecso, linhed)
         call savew (nlh, 'NumRec', notrpr, linhed)
      else
         call savew (nlh, 'NumTrc', notrpr, linhed)
         call savew (nlh, 'NumRec', nrecso, linhed)
      endif

c
c     open output tape
c
c>ibm call lbopen (luotap)
      if (otap .ne. ' ') then
c
c        open output for data to a file
c
         call lbopen (luotap, otap, 'w')
       else
c
c        open output for data to a pipe
c
         luotap = 1
      endif
c
c     check for proper output unit number
c
      if (luotap .lt. 0) then
         write (luprt,1440) luotap
 1440    format(/' Could not open unit ',i3,' for output.'/)
         stop 1440
      endif
c___________________________________________________________________
c     save historical line header (kjm 2/23/93)
c___________________________________________________________________
      call savhlh(nlh,lbytes,lbyout)
c
c     write output line header
c
      call wrtape (luotap, nlh, lbyout)
c
c     initialize the pointer vector that is saved
c
      do 150 i = 1, nfold
         ipsave(i) = i
  150 continue
c
c     perform stacking.  statement 200 starts the record processing
c     'loop'.  unless inirec = -1, the output record count will begin
c     at inirec and increment by 1.  if inirec = -1, the depth index
c     from the first record is used as the initial record index and
c     incremented by 1 for each record after that.  the trace number
c     is initialized to 1.
c
      numtrc = 1
      numrec = inirec
  200 continue
c
c        start loop over the number of traces per record.
c
         do 220 j = 1, ntpr
            jm1 = j - 1
c
c           read a trace from the input
c
            ibytes = 0
            call rtape (luntap, ix, ibytes)
            call vmov  (ix(ITHWP1), 1, rx, 1, nspt)
c
c           check for successful read.  this section provides for
c           the exit from the 200 loop.  if a read is unsuccessful,
c           an end to the input data set is indicated and output
c           is completed, filling out partially completed output
c           records with dead traces if necessary.
c
            if (ibytes .eq. 0) then
c
c              if numtrc is greater than 1 and less than or equal
c              to notrpr, then fill out the current record with
c              dead traces.
c
               if ((numtrc .gt. 1) .and. (numtrc .le. notrpr)) then
                  call vclr (rx(1), 1, nspt)
                  call vmov (itrh, 1, ix, 1, itrwrd)
c>ibm             ix(125) = 30000
c>ibm             ix(106) = numrec
c>ibm             ix(117) = 0
c>ibm             ix(119) = 0
                  call savew2(ix,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        numrec TRACEHEADER)
                  call savew2(ix,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                        0    , TRACEHEADER)
                  call savew2(ix,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        0    , TRACEHEADER)
                  call savew2(ix,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        30000, TRACEHEADER)
                  do 210 k = numtrc, notrpr
c>ibm                ix(107) = k
                     call savew2(ix,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                           k    , TRACEHEADER)
                     call wrtape (luotap, ix, nbytes)
                     if (verbos) then
c>ibm                   nrtemp = ix(106)
c>ibm                   nttemp = ix(107)
                        call saver2(ix,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                              nrtemp, TRACEHEADER)
                        call saver2(ix,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                              nttemp, TRACEHEADER)
                        write (luprt,3000) nrtemp, nttemp
                        write (luprt,2000)
 2000                   format(4x,'dead trace appended to fill record')
                     endif
  210             continue
               endif
c
c              call accounting routine, and close tapes.
c
               write (luprt,2100)
 2100          format (////' -EOF encountered attempting to read',
     *                 ' input tape'/' -Execution terminated')
               call lbclos (luntap)
               call lbclos (luotap)
c
c              end timing, total program (outer timing loop)
c
               call secon1 (cputo1, wallo1)
               cputo = cputo1 - cputo0
               wallo = wallo1 - wallo0
               write (luprt,2120) cputo, wallo
 2120          format(//' Timing:  outer loop'/5x,' total cpu = ',
     *                f12.3/5x,'wall clock = ',f12.3)
               write (luprt,2140) cputi, walli
 2140          format(//' Timing:  inner loop'/5x,' total cpu = ',
     *                f12.3/5x,'wall clock = ',f12.3//)
               stop
            endif
c
c           load the trace and its header into appropriate
c           position in arrays a and itrh
c
            call vmov (rx(1), 1, a((jm1*nspt)+1)     , 1, nspt)
            call vmov (ix   , 1, itrh((jm1*itrwrd)+1), 1, itrwrd)
  220    continue
c
c        array a now contains the traces to be stacked.
c        array itrh contains the corresponding trace headers.
c
c        if inirec = -1, get the depth index to use as the output
c        record index.  the depth index is taken from the first
c        first trace of the first input record.  this will occur
c        only on the first set of traces read.
c
         if (inirec .eq. -1) then
c>ibm       inirec = itrh(122)
            call saver2(itrh,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                  inirec, TRACEHEADER)
            numrec = inirec
         endif
c
c        count live traces and indicate in vector lvtrsv which
c        traces are live.  this data will not change for the
c        current contents of vectors a and itrh.  also determine
c        the shallowest mute distance.
c
         ntlive = 0
         mutelo = nspt
         do 230 j = 1, ntpr
            jm1 = j - 1
c>ibm       mute41 = itrh((jm1*128)+41)
c           call saver (itrh((jm1*itrwrd)+1), 'FlDtEl', mute41, trched)
            call saver2(itrh((jm1*itrwrd)+1),ifmt_FlDtEl,l_FlDtEl,
     1                  ln_FlDtEl, inirec, TRACEHEADER)
            mutelo = min0(mutelo,mute41)
            lvtrsv(j) = .false.
c>ibm       istatc = itrh((jm1*128)+125)
c           call saver (itrh((jm1*itrwrd)+1), 'StaCor', istatc, trched)
            call saver2(itrh((jm1*itrwrd)+1),ifmt_StaCor,l_StaCor,
     1                  ln_StaCor, istatc, TRACEHEADER)
            if (istatc .eq. 30000) go to 230
            ntlive = ntlive + 1
            lvtrsv(j) = .true.
  230    continue
c
c        find the location of the first non-muted sample and
c        find the deepest first non-muted sample
c
         imdeep = 0
         do 240 j = 1, ntpr
            jm1 = j - 1
            imute(j) = nspt
            if (lvtrsv(j)) then
               call detmut (nspt, a((jm1*nspt)+1), imute(j))
               imdeep = max0(imute(j),imdeep)
            endif
  240    continue
c
c        build output trace header (the ix element refers to ibm location)
c         FlDtEl:  ix( 41)  shallowest mute distance
c         FoldNm:  ix(105)  fold = count of live traces in record = ntlive
c         RecNum:  ix(106)  record number = numrec
c         TrcNum:  ix(107)  trace number = numtrc
c         SrcPnt:  ix(108)  source point number above this depth point, set
c                           negative to mark the value for plotting
c         DstUsg:  ix(117)  trace distance = 0
c         DstSgn:  ix(119)  trace distance = 0 (signed)
c         StaCor:  ix(125)  set static correction to 0
c

         call vmov (itrh, 1, ix, 1, itrwrd)

c>ibm    ix(41) = mutelo
c>ibm    ix(105) = ntlive
c>ibm    ix(106) = numrec
c>ibm    ix(107) = numtrc
c>ibm    isrcpn = ix(108)
c>ibm    ix(108) = -iabs(isrcpn)
c>ibm    ix(117) = 0
c>ibm    ix(119) = 0
c>ibm    ix(125) = 0
c        call savew (ix, 'FlDtEl', mutelo, trched)
c        call savew (ix, 'FoldNm', ntlive, trched)
c        call savew (ix, 'RecNum', numrec, trched)
c        call savew (ix, 'TrcNum', numtrc, trched)
c        call saver (ix, 'SrcPnt', isrcpn, trched)
c        isrcpn = -iabs(isrcpn)
c        call savew (ix, 'SrcPnt', isrcpn, trched)
c        call savew (ix, 'DstUsg', 0     , trched)
c        call savew (ix, 'DstSgn', 0     , trched)
c        call savew (ix, 'StaCor', 0     , trched)
         call savew2(ix,ifmt_FlDtEl,l_FlDtEl, ln_FlDtEl,
     1               mutelo, TRACEHEADER)
         call savew2(ix,ifmt_FoldNm,l_FoldNm, ln_FoldNm,
     1               ntlive, TRACEHEADER)
         call savew2(ix,ifmt_RecNum,l_RecNum, ln_RecNum,
     1               numrec, TRACEHEADER)
         call savew2(ix,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               numtrc, TRACEHEADER)
         call saver2(ix,ifmt_SrcPnt,l_SrcPnt, ln_SrcPnt,
     1               isrcpn, TRACEHEADER)
         isrcpn = -iabs(isrcpn)
         call savew2(ix,ifmt_SrcPnt,l_SrcPnt, ln_SrcPnt,
     1               isrcpn, TRACEHEADER)
         call savew2(ix,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1               0     , TRACEHEADER)
         call savew2(ix,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1               0     , TRACEHEADER)
         call savew2(ix,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               0     , TRACEHEADER)
c
c        if all traces are dead, zero output data vector, mark
c        as a dead trace, and jump to output.
c
         if (ntlive .eq. 0) then
            call vclr (rx(1), 1, nspt)
c>ibm       ix(125) = 30000
c           call savew (ix, 'StaCor', 30000, trched)
            call savew2(ix,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                  30000 , TRACEHEADER)
            go to 300
         endif
c
c        zero the statistical array istat
c
         call vclr (istat, 1, nfold)
c
c        for each time value, collect the data values from
c        array a and store in array b.  live trace values loaded
c        at the front of b, dead at the back.  the live trace
c        indicator must be reloaded into vector livetr for
c        each new time value (k) because the functions change
c        the contents of livetr.  note that livetr will be true
c        if trace j is live and time sample k is greater than
c        or equal to the first non-muted sample location for
c        trace j.  this combination is livetr will preserve
c        the stacked amplitude in mute zones.  ntlivm indicates
c        the number of live traces that are not in the mute zone.
c
c
c        timing, processing (inner timing loop).
c
         call secon1 (cputi0, walli0)
c
         do 280 k = 1, nspt
            ntlivm = 0
            nfront = 1
            nback = ntpr
            do 260 j = 1, ntpr
               jm1nsp = (j - 1)*nspt
               trlive = lvtrsv(j) .and. (k .ge. imute(j))
               if (trlive) then
                  b(nfront) = a(k+jm1nsp)
                  livetr(nfront) = .true.
                  nfront = nfront + 1
                  ntlivm = ntlivm + 1
                else
                  b(nback) = 0.0
                  livetr(nback) = .false.
                  nback = nback - 1
               endif
  260       continue
c
c           restore the pointer vector ipntr to sequential order.
c           set the statistical tabulation flag to true if time
c           sample is deeper than deepest initial mute.
c
            call vmov (ipsave, 1, ipntr, 1, nfold)
            tabul8 = k .ge. imdeep
c
c           call the selected nonlinear stacking algorithm
c
            if (ialgor .eq. 1) then
               c(k) = mdians (luprt , nfold , ntlivm, b     , livetr,
     *                        istat , ipntr , tabul8)
             elseif (ialgor .eq. 2) then
               c(k) = alftms (luprt , range , nfold , ntlivm, b     ,
     *                        livetr, istat , ipntr , tabul8)
             elseif (ialgor .eq. 3) then
               c(k) = rngtms (luprt , range , nfold , ntlivm, b     ,
     *                        livetr, istat , ipntr , tabul8)
             elseif (ialgor .eq. 4) then
               c(k) = asrtms (luprt , range , nfold , ntlivm, b     ,
     *                        livetr, istat , ipntr , tabul8)
            endif
  280    continue
c
c        sort the counts in the statistical vector istat, finding
c        the largest values, corresponding to the trace numbers
c        most frequently used in the stack.
c        also, compute the total of all counts in istat for
c        reporting.
c
         kount = 0.0
         do 290 k = 1, nfold
            kount = kount + istat(k)
  290    continue
         nsrtis = min0(18,ntpr)
         call vmov (ipsave, 1, ipntr, 1, nfold)
         call srtint (nsrtis, nfold, istat, ipntr)
c
c        timing, processing (inner timing loop).
c
         call secon1 (cputi1, walli1)
         cputi = cputi + cputi1 - cputi0
         walli = walli + walli1 - walli0
c
c        move the output data into the output data buffer
c
         call vmov (c, 1, rx(1), 1, nspt)
c
c        write output trace to output tape, print record and trace
c        count and trace usage statistics.
c
  300    continue
         call vmov (rx, 1, ix(ITHWP1), 1, nspt)
         call wrtape (luotap, ix, nbytes)
         if (verbos) then
c>ibm       nrtemp = ix(106)
c>ibm       nttemp = ix(107)
c           call saver (ix, 'RecNum', nrtemp, trched)
c           call saver (ix, 'TrcNum', nttemp, trched)
            call saver2(ix,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                  nrtemp, TRACEHEADER)
            call saver2(ix,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                  nttemp, TRACEHEADER)
            write (luprt,3000) nrtemp, nttemp, kount
 3000       format(/' Output record ',i5,', trace ',i5,5x,
     *             'total count:  ',i8)
            write (luprt,3020) (ipntr(j), j = 1, nsrtis)
 3020       format(4x,'input trace number:',18(2x,i4))
            write (luprt,3025) (istat(j), j = 1, nsrtis)
 3025       format(4x,' trace usage count:',18(2x,i4))
         endif
c
c        update trace and record count.
c
         numtrc = numtrc + 1
         if (numtrc .gt. notrpr) then
            numtrc = 1
            numrec = numrec + 1
         endif
  400 go to 200
      end
