c***********************************************************************
c                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c                                                                      *
c***********************************************************************
c  routine:       srtint                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      sort the n elements of integer vector v so that v(1) is the     *
c      largest and v(n) the smallest.  sorting is accomplished with    *
c      a slow, straight forward algorithm.  only the largest nptsrt    *
c      values in v are sorted.                                         *
c                                                                      *
c  entry points:                                                       *
c      srtint  (nptsrt,n,v,ipntr)                                      *
c  arguments:                                                          *
c      nptsrt  integer  ??iou*      -                                  *
c      n       integer  ??iou*      -                                  *
c      v       integer  ??iou*  (n) -                                  *
c      ipntr   integer  ??iou*  (n) -                                  *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 86/04/04  *
c  language: fortran 77                  date last compiled: 86/04/08  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:  none                                              *
c  intrinsic functions called:  none                                   *
c  files:            none                                              *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:  none                                               *
c  general description:                                                *
c      sort data in an integer vector.                                 *
c                                                                      *
c  revised by:  bill done                     revision date: 86/04/08  *
c      add pointing vector to allow referral to original positions of  *
c      elements.                                                       *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
c
       subroutine srtint (nptsrt, n, v, ipntr)
c
       integer v(n), vtemp, ipntr(n)
c
c      sort the n elements of vector v to find the nptsrt largest
c      values
c
       do 100 l = 1, nptsrt
         lp1 = l + 1
         do 100 k = lp1, n
           if(v(l) .lt. v(k)) then
               vtemp = v(l)
               v(l) = v(k)
               v(k) = vtemp
               iptemp = ipntr(l)
               ipntr(l) = ipntr(k)
               ipntr(k) = iptemp
           endif
100    continue
       return
       end
