C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c     program module rsort
c
c**********************************************************************c
c
c rsort rearranges traces randomly OR
c   returns them to sequential order
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     itr ( SZLNHD)
      integer     itrces
      pointer     (wkaddr, itrces(1))
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes,  lbyout
#include <f77/pid.h>
      integer     jstart(SZLNHD),jend(SZLNHD),key(SZLNHD)
      character   ntap * 256, otap * 256, name*5
      logical     verbos, query, rand,seq,heap
      integer     argis
      integer     errcod, abort

c     equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'RSORT'/
      data abort / 0 /
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
c-----
c     open printout files
c-----
#include <f77/open.h>
      call gcmdln(ntap,otap,ns,ne,irs,ire,
     :		verbos,rand,seq,iseed)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
c-----
c     read line header of input
c     save certain parameters
c-----
	lbytes = 0
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'RSORT'
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call hlhprt (itr, lbytes, name, 5, LERR)
c-----
c     modify line header to reflect actual number of traces output
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr=ne-ns+1
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      	    call verbal(nsamp, nsi, ntrc, nrec, iform, 
     :            	ntap,otap,rand,seq,iseed)

c-----
c     compute an array of sequential and random numbers between 1-ntrc
c-----
 	call random1 (iseed, 8000, 1, ntrc, jstart, jend, kk)


	write(LERR,*)'random sort'
	write(LERR,*)(jend(i),i=1,ntrc)
	if (seq) then 
		call sort (jend,key,ntrc)
		write(LERR,*)'sequential sort'
  		write(LERR,*)(key(i),i=1,ntrc)
	endif
c-----
c     BEGIN PROCESSING
c     read trace, do filtering, write to output file
c-----
      call recskp(1,irs-1,luin,ntrc,itr)


c---------------------------------------------------
c  malloc only space we're going to use
      heap = .true.

c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

      items = ntrc * (nsamp + ITRWRD)
      call galloc (wkaddr, items*SZSMPD, errcod, abort)
      if (errcod .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
      nitems = nsamp + ITRWRD
c-----
c     process desired trace records
c-----
      do 1000 jj = irs, ire

            do 1001 kk=1, ntrc

                  nbytes = 0
                  call rtape ( luin, itr,nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     if (kk .gt. 1) then
                        ntrc = kk - 1
                        go to 998
                     else
                        go to 999
                     endif
                  endif

                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        irec   , TRACEHEADER)

c----------load traces into a matrix
                istrc = (kk-1) * nitems
		call move(1,itrces(istrc+1),itr,nbytes)
 1001             continue

998               continue
c----------rearrange trace order
		if (rand) then
			do 70 i = 1, ntrc
                        istrc = (jend(i)-1) * nitems
			call move(1,itr,itrces(istrc+1),nbytes)
                        call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1                          i    , TRACEHEADER)
                        call wrtape( luout, itr, nbytes)
70			continue		
		elseif(seq) then
			do 80 i = 1, ntrc
                        istrc = (key(i)-1) * nitems
			call move(1,itr,itrces(istrc+1),nbytes)
                        call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1                          i    , TRACEHEADER)
                  	call wrtape( luout, itr, nbytes)
80			continue		
		endif

		if(verbos) write(LERR,*)'processed record',irec
 1000       continue
c-----
c     close data files
c-----
  999 continue
      call lbclos ( luin )
      call lbclos ( luout )
      if(verbos) then
            write(LERR,*)'end of rsort , processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
       endif
      end


      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'Execute rsort  by typing rsort followed by program parameters.'
      write(LER,*)
     :'Note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'Users enter the following parameters, or use the default values'
        write(LER,*)
     :' -N [ntap]    (no default)         : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)         : output data file name'
        write(LER,*)
     :' -rs[irs]     (default = 1st rec)  : starting record number '
        write(LER,*)
     :' -re[ire]     (default = last rec) : final record number '
	write(LER,*)
     :' -R           (no default)         : sort traces randomly'
	write(LER,*)
     :' -S           (no default)         : sort traces sequentially'
	write(LER,*)
     :' -sd [iseed]  (default = 32357)    : Randomization seed'
	write(LER,*)
     :' -V[verbos]   (optional printing)  : print additional info'
	write(LER,*)
	write(LER,*)
     :' EXAMPLE'
	write(LER,*)
     :' rsort -N/home/data/ntap -O/home/data/otap -R '
	write(LER,*)
     :' rsort -N/home/data/ntap -O/home/data/otap -S '
	write(LER,*)
	write(LER,*)
     :'***************************************************************'
      return
      end

      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,verbos,rand,seq,iseed)
c-----
c     get command arguments
c
c     ntap  - c*120     input file name
c     otap  - c*120     output file name
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c     verbos      - l   verbose output or not
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*)
      logical verbos,rand,seq
      integer *4 ns, ne, irs, ire
      integer argis, iseed
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-sd', iseed,   32357  ,  32357    )
            verbos = ( argis( '-V' ) .gt. 0 )
            rand   = ( argis( '-R' ) .gt. 0 )
            seq    = ( argis( '-S' ) .gt. 0 )
      return
      end
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform, 
     :            	ntap,otap,rand,seq,iseed)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      integer nsamp, nsi, ntrc, nrec, iform, iseed
      character ntap*(*), otap*(*)
	logical rand,seq

            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' random sort requested = ', rand
            write(LERR,*) ' sequential sort requested = ', seq
            write(LERR,*) ' Randomization Seed = ', iseed
            write(LERR,*) ' Input file = ', ntap
            write(LERR,*) ' Output file = ', otap
            write(LERR,*)' '

      return
      end

	subroutine random1(iseed, ntries, jlow, jhigh, ibegin, iend,i )

c   ..........random computes a vector of integers from jlow to
c   ..........jhigh and returns them in random order.
 
c   ..........   INPUT ARGUMENTS

c   ................iseed  = integer seed value to get process going
c   ................ntries = number of tries to get random ordering of array
c   ................jlow   = lowest integer to sort
c   ................jhigh  = highest integer to sort

c   .............OUTPUT

c   ................iend   = output vector of integers from jlow to jhigh
c   ................         in random order.
c   ................ibegin = output vector of integers from jlow to jhigh
c   ................         in sequential order.
c   ................i      = number of tries to select random vector

c   ..........declare integer function
#include <f77/lhdrsz.h>

	real c(SZLNHD)
	integer iend(*),isave(SZLNHD),ibegin(*)
	call vrand(iseed, c, 1, ntries)
	do 10 i = 1, ntries
		isave(i) = 1 + int( c(i) * ( ( jhigh - jlow) + 1 ) )
10	continue
	kk = 1
	iend   (1 ) = isave(1)
 	ibegin (1 ) = jlow
	do 20 i = 2, ntries
		icheck = 0
		do 15 j = 1,i-1
			if(isave(i) .eq. isave(j) ) then
				icheck = 1
				go to 20
			endif	
15		continue
		if (icheck .eq. 0) then
			kk = kk + 1
			iend(kk) = isave(i)
	                ibegin(kk) = kk
			if (kk .eq. jhigh) return
		end if	
20	continue
	return
      	end

      subroutine sort(ix,key,no)
c-----
c  
c------------INPUT VARIABLES

c     	ix(i) is the array to be sorted
c     	no is the number of points to be sorted

c------------OUTPUT VARIABLES

c     	ix(i) is the sorted array
c     	key(i) is the pointer array

c     After the sort x(i) will be ordered from least to
c           greatest

c     key(1) will point to the position in the original array
c     with the least value
c-----

      dimension ix(1),key(1)
      do 1 i=1,no
    1 key(i)=i
      mo=no
    2 if(mo-15)21,21,23
   21 if(mo-1)29,29,22
   22 mo=2*(mo/4)+1
      goto 24
   23 mo=2*(mo/8)+1
   24 ko=no-mo
      jo=1
   25 i=jo
   26 if(ix(i)-ix(i+mo))28,28,27
   27 temp=ix(i)
      ix(i)=ix(i+mo)
      ix(i+mo)=temp
      kemp=key(i)
      key(i)=key(i+mo)
      key(i+mo)=kemp
      i=i-mo
      if(i-1)28,26,26
   28 jo=jo+1
      if(jo-ko)25,25,2
   29 return
      end

