C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine taper( nsamp, ntrc, ist, iend, fmin, 
     :     fmax, fint, nsi, Num_Freqs, t, Gaus, itw)
     
c     Subroutine to compute a taper
c
c     James M. Gridley, Greg Partyka
c     USP Team
c     Tulsa OK
c     Fall 1997
c
#include <save_defs.h> 
#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer nsamp, ntrc, ist, iend, Num_Freqs

      real t(SZLNHD)

c local variables


      real pie, radeg
      real fmin, fmax, fint, unit_scale
      logical Gaus
c initialize variables


      pie = 4.0 * atan(1.0) 
      radeg = 180. / pie
      
c     Gaussian taper window
      if (Gaus) then
         iwind=nsamp
         ihalf=iwind/2
         sigma = float (iwind)/(2.*3.)
         sigma2 = 2. * sigma**2
         nf2=ihalf +1
         spi=1./(sqrt(2.*pie)*sigma)
         do i = 1,iwind
            ia = i-nf2
            t(i) = spi * exp(-(float(ia))**2 / sigma2)
            val = max(val,t(i))
         enddo
         do i=1,iwind
            t(i)=t(i)/val
         enddo
      endif
c     Cosine Taper window
      
      if (.not. Gaus) then
         iwind=int((iend-ist+1))
         ihalf=iwind/2
         
         itw=100 - itw
         itw=((int((itw/100.)*iwind))/2)
         
         do ijk=1,iwind
            jkl=ijk-ihalf-1
            if (ijk .le. ihalf-itw ) then
               termy=(float(jkl+itw+1)/float(abs(itw-ihalf)))
               t(ijk)=((cos(pie*termy) +1.)/2.)
            elseif (ijk .gt. ihalf+itw+1) then
               termy=abs(float(jkl-itw)/float(abs(itw-ihalf)))
               t(ijk)=((cos(pie*termy) +1.)/2.)
            else
               t(ijk)=1.0
            endif
            
         enddo
      endif
      
      
      return
      end
