C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine breakup(u,ibuffer,lenu2,nsamp,
     1                   hbegin,lenhed,nbytes_out,luin,luout,lerr,
     2                   npad,ntr,ntrout,nrec_inline,ntrpline,
     3                   nline,dx)
      integer   hbegin
c___________________________________________________________________________
c     ibuffer and u are equivalenced by the calling arguments.
c___________________________________________________________________________
      integer   ibuffer(lenu2,ntrout)               
      real      u(hbegin:nsamp,ntrout)
      logical   eod

      common /thdr/ ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1              ifmt_RecNum,l_RecNum,ln_RecNum,
     2              ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     3              ifmt_RecInd,l_RecInd,ln_RecInd,
     4              ifmt_DphInd,l_DphInd,ln_DphInd,
     5              ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     6              ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     7              ifmt_StaCor,l_StaCor,ln_StaCor,
     8              ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,
     9              ifmt_LRcCDP,l_LRcCDP,ln_LRcCDP

c
      xmid=.5*(ntrout-1)*dx           
      jrec=0
      do 80000 iline=1,nline
       jtrpline=0
       itrace_sort=0
       eod=.false.
c___________________________________________________________________________
c      clear out npad traces to the left.
c___________________________________________________________________________
       do 10000 jtr=1,npad     
        call vclr(u(hbegin,jtr),1,lenhed+nsamp)
c       ibuffer(l_StaCor,jtr)=30000
        call savew2(ibuffer(1,jtr),ifmt_StaCor,l_StaCor, ln_StaCor,
     1               30000, 1)
10000  continue
c___________________________________________________________________________
c      read in the traces to be analyzed, plus those to be padded on the right.
c___________________________________________________________________________
       ifirst=npad+1
       ilast=ntrout
       do 70000 irec=1,nrec_inline
        jrec=jrec+1
c___________________________________________________________________________
c       fill up the rest of the buffer with traces.
c___________________________________________________________________________
        do 20000 jtr=ifirst,ilast
         jtrpline=jtrpline+1
         if(jtrpline .gt. ntrpline .or. eod) then
            call vclr(u(hbegin,jtr),1,lenhed+nsamp)
c           ibuffer(l_StaCor,jtr)=30000
            call savew2(ibuffer(1,jtr),ifmt_StaCor,l_StaCor, ln_StaCor,
     1                   30000, 1)
         else
            nbytes = 0
            call rtape(luin,u(hbegin,jtr),nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',irec,'  trace= ',jtr
               call vclr(u(hbegin,jtr),1,lenhed+nsamp)
c              ibuffer(l_StaCor,jtr)=30000
               call savew2(ibuffer(1,jtr),ifmt_StaCor,l_StaCor,
     1                     ln_StaCor, 30000, 1)
               eod=.true.
            endif
         endif
20000   continue
        ifirst=2*npad+1  
c___________________________________________________________________________
c       traces now read in.
c       assign trace distances and write out.
c___________________________________________________________________________
        do 30000 jtr=1,ntrout
         itrace_sort=itrace_sort+1
         x=(jtr-1)*dx
         idstsgn=nint(x-xmid)            
         call savew2(ibuffer(1,jtr),ifmt_DstSgn,l_DstSgn,
     1               ln_DstSgn, idstsgn, 1)
         ival = iabs (idstsgn)
         call savew2(ibuffer(1,jtr),ifmt_DstUsg,l_DstUsg,
     1               ln_DstUsg, ival   , 1)
         call savew2(ibuffer(1,jtr),ifmt_RecNum,l_RecNum,
     1               ln_RecNum, jrec   , 1)
         call savew2(ibuffer(1,jtr),ifmt_LRcCDP,l_LRcCDP,
     1               ln_LRcCDP, itrace_sort, 1)
         call wrtape(luout,u(hbegin,jtr),nbytes_out)
30000   continue
c____ _______________________________________________________________________
c       shift over ntr traces.
c___________________________________________________________________________
        do 40000 jtr=ntr+1,ntrout
         call vmov(u(hbegin,jtr),1,
     1             u(hbegin,jtr-ntr),1,lenhed+nsamp)
40000   continue
70000  continue
80000 continue
c
      return
      end

