C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE RAMP(LX,X,IRAM)                                        RAM01000
C     A CONFIDENTIAL AMOCO SUBROUTINE                                   RAM02000
C        FORTRAN BY KEN PEACOCK  9-20-88                                RAM03000
C     RAMP APPLIES A COSINE TAPER TO THE X ARRAY.  HALF THE TOTAL       RAM04000
C     RAMPING IS APPLIED TO EACH END.                                   RAM05000
C     INPUTS ARE...                                                     RAM06000
C        LX, LENGTH OF THE X ARRAY.                                     RAM07000
C        X, THE INPUT ARRAY.                                            RAM08000
C        IRAM, AMOUNT OF ARRAY TO TAPER, PERCENT.                       RAM09000
C     OUTPUT IS...                                                      RAM10000
C        X, THE MODIFIED ARRAY.                                         RAM11000
C     CODED FOR THE SUN COMPUTER.                                       RAM12000
C     VERSION AS OF 9-20-88                                             RAM13000
C                                                                       RAM14000
      DIMENSION X(1)                                                    RAM15000
      IST = .5*.01*IRAM*LX+.5                                           RAM16000
      DO 1 I=1,IST                                                      RAM17000
      TERM = .5+.5*COS(3.1415927*(-1.+I/(IST+1.)))                      RAM18000
      X(I) = X(I)*TERM                                                  RAM19000
      J = LX+1-I                                                        RAM20000
    1 X(J) = X(J)*TERM                                                  RAM21000
      RETURN                                                            RAM22000
      END                                                               RAM23000
