C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

c     program samps - seismic amplitude and phase spectra
c     samps reads in seismic traces and outputs associated amplitude and
c     phase spectra (phase is optional).
c     fortran by ken peacock   7-11-88
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer   itr(SZLNHD)
      integer   lhed(SZLNHD)    
      integer   irs,ire,its,ite,iwst,iwed,ipt

c     irs is record start
c     ire is record end
c     its is trace start
c     ite is trace end
c     iwst is window start
c     iwed is window end
c     ipt is taper, percent
c     freq1 is beginning frequency
c     freq2 is ending frequency
c     finc is frequency increment

      integer   nsamp,nsi,ntrc,nrec,iform
      integer   nsampp,jtr,nrecc,iformm,nsip,iws,iwe
      integer   luin,luout,lbytes,nbytes,lbyout

#include <f77/pid.h>

      real   tri(SZLNHD)
      real   am(SZLNHD),ph(SZLNHD)
      character ntap*256,otap*256,name*5
      logical verbos,query, xy, phase
      integer argis

c     equivalence (itr(129),tri(1))
      equivalence(itr(1),lhed(1))

      data lbytes/0/, nbytes/0/, name/'SAMPS'/

      query = (arg is ('-?').gt.0)
      if(query) then
            call help()
            stop
      endif

c             read parameters
#include <f77/open.h>

      call gcmdln(ntap,otap,irs,ire,its,ite,iwst,iwed,ipt,freq1,freq2,
     *finc,phase,xy,verbos,db)

      call getln(luin,ntap,'r',0)
      if ( .not. xy) then
	call getln(luout,otap,'w',1)
      else
	luout = 8
        open(luout,file=otap)
      endif
c           read line header, extract key parameters
      call rtape (luin,itr,lbytes)
      if(lbytes.eq.0)then
            write(lot,*)'SAMPS: no header read from unit ',luin
            stop
      endif

      call saver(itr,'NumSmp',nsamp,LINHED)
      call saver(itr,'SmpInt',nsi,LINHED)
      call saver(itr,'NumTrc',ntrc,LINHED)
      call saver(itr,'NumRec',nrec,LINHED)
      call saver(itr,'Format',iform,LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c           check compatability of data parameters
      call cmdchk(its,ite,irs,ire,ntrc,nrec)

c           update line header
      nrecc = ire-irs+1
      call savew(itr,'NumRec',nrecc,LINHED)
      jtr = ite-its+1
      call savew(itr,'NumTrc',jtr,LINHED)
      iformm = 3
      call savew(itr,'Format',iformm,LINHED)

      tdel = real (nsi) * unitsc


c           verbose output on option
      if(verbos) then
            call verbal(ntap,otap,nrec,ntrc,nsamp,nsi,iform,iwst,iwed,
     *      ipt,freq1,freq2,finc)
      endif

c           convert ms to samples
      iws = iwst/nsi+1
      iwe = iwed/nsi+1
      if(iwe.eq.1)iwe = nsamp
      ld = iwe-iws+1
      ls = ld/2*2+1
      if(ls.gt.nsamp)ls = ls-2

c     if (nsi .le. 32) then
          fnyq = .5/tdel
          if(freq2.eq.0.)freq2 = 1./(2.*nsi*unitsc)
          write(LERR,*)'Hi-cut frequency set to  ',freq2
c     else
c         fnyq = 500000./nsi
c         if(freq2.eq.0.)freq2 = 1./(2.*nsi*.000001)
c         write(LERR,*)'Hi-cut frequency set to  ',freq2
c     endif

      if (freq2 .gt. fnyq) then
          write(LERR,*)'Hi-cut frequency set to  ',freq2
      endif
      if(finc.eq.0.)finc = 1./(ls*nsi*unitsc)
      nsip = finc*1000.

      call savew(itr,'SmpInt',nsip,LINHED)
      call savhlh(itr,lbytes,LBYOUT)

      nhar = freq2/finc+1.01
      freq2 = (nhar-1.)*finc
      nhs = freq1/finc+1.01
      freq1 = (nhs-1.)*finc
      nsampp = nhar
      call savew(itr,'NumSmp',nsampp,LINHED)
      nbyout = SZTRHD+SZSMPD*nsampp
      if ( .not. xy ) call wrtape(luout,itr,lbyout)

c           skip unwanted records
      call recskp(1,irs-1,luin,ntrc,itr)

c           process desired traces
      do 1000 jj=irs,ire
      call trcskp(jj,1,its-1,luin,ntrc,itr)
      k=0
      do 500 kk=its,ite
      k=k+1
      nbytes = 0
      call rtape (luin,itr,nbytes)
      if(nbytes.eq.0)then
            write(lerr,*)'premature end of data at rec ',jj,'trc ',kk,
     *      'check input data set'
            stop999
      endif
      call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
      if(ipt.ne.0)call ramp(ls,tri(iws),ipt)
      call timfr(ls,tri(iws),tdel,finc,freq1,freq2,lap,am,ph)

      if (phase) then
c         call drum (nhar, ph)
      else
          call smooth (nhar, am)
      endif

      do 1 i=1,nhs
    1 tri(i) = 0.
      do 2 i=nhs,nhar
           index = i-nhs+1
           if (phase) then
               if ( ph(index) .gt. 180.) ph(index) = ph(index) - 360.
               tri(i) = ph(index)
           else
               tri(i) = am(index)
           endif
2     continue
c     irec = itr(106)
c     itrc = itr(107)
      call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            irec, TRACEHEADER)
      call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1            itrc, TRACEHEADER)
c
      if ( (db .gt. 0.) .and. (.not.phase) )  then
         amax = 0.
c
c - added provisions for setting amin. it was previously used without being set
c - j.m.wade 8/21/92
c
	 amin = tri(1)
         do 444 i = 1, nhar
                if ( tri(i) .gt. amax) amax = tri(i)
                if ( tri(i) .lt. amin) amin = tri(i)
444      continue
         do 445  i= 1, nhar
                 anorm = tri(i) / amax
                 tri(i) = 20. * alog10( anorm )
                 if ( tri(i) .lt. -db) tri(i) = -db
                 tri(i) = tri(i) + db
445      continue
         do 446 i = 1, nhar
         tri(i) = tri(i) - amin
446      continue
      endif
c
      if (xy) then
         do 451  i = 1, nhar
                 freq = freq1 + (i-1)*finc
                 write(luout,*) freq,tri(i)
451      continue

c---------------------
c  between records put
c  null line
                  write(luout,101)
101               format()
      else
         call vmov  (tri, 1, itr(ITHWP1), 1, nsampp)
         call wrtape(luout,itr,nbyout)
      endif
c
c
500   continue
c           skip to end of record
c
c
c - changed nc to be ite; nc was never declared or set
c - I think "ifrom" is a typo !?
c - j.m.wade 8/21/92
c
 1000 call trcskp(jj,ite+1,ntrc,luin,ntrc,itr)
c           close out
      call lbclos(luin)
      if ( xy ) then
	close(luout)
      else
        call lbclos(luout)
      endif

      if(verbos)then
            write(lerr,*)'end of run, processed ',nrec,' record
     *(s) with ',ntrc,' traces'
      endif
      end

      subroutine gcmdln(ntap,otap,irs,ire,its,ite,iwst,iwed,ipt,freq1,
     *freq2,finc,phase,xy,verbos,db)

c           subroutine to get command line
c           ntap        -c*100      input file name
c           otap        -c*100      output file name
c           irs         -i*4        starting record
c           ire         -i*4        ending record
c           its         -i*4        starting trace
c           ite         -i*4        ending trace
c           iwst        -i*4        window start
c           iwed        -i*4        window end
c           ipt         -i*4        taper percent
c           freq1       -r*4        starting frequency
c           freq2       -r*4        ending frequency
c           finc        -r*4        frequency increment
c           xy          -l          write output in form of xy pairs
c           phase       -l          phase output flag
c           verbos      -l          verbose output flag

#include <f77/iounit.h>
      character ntap*(*),otap*(*)
      integer*4 irs,ire,its,ite,iwst,iwed,ipt
      real*4 freq1,freq2,finc,db
      logical verbos, phase, xy
      integer argis

      call argstr('-N',NTAP,' ',' ')
      call argstr('-O',OTAP,' ',' ')
      call argi4('-rs',irs,0,0)
      call argi4('-re',ire,0,0)
      call argi4('-ts',its,0,0)
      call argi4('-te',ite,0,0)
      call argi4('-s',iwst,0,0)
      call argi4('-e',iwed,0,0)
      call argi4('-t',ipt,0,0)
      call argr4('-f1',freq1,0.,0.)
      call argr4('-f2',freq2,0.,0.)
      call argr4('-fi',finc,0.,0.)
      call argr4('-dB',db,0.,0.)
      xy     = (argis('-XY').gt.0)
      phase  = (argis('-P').gt.0)
      verbos = (argis('-V').gt.0)
      return
      end
      subroutine verbal(ntap,otap,nrec,ntrc,nsamp,nsi,iform
     *,iwst,iwed,ipt,freq1,freq2,finc)
#include <f77/iounit.h>
      character ntap*(*),otap*(*)
      integer*4 nrec,ntrc,nsamp,nsi,iform,iwst,iwed,ipt
      real*4 freq1,freq2,finc
c     write(lerr,*)'inside sr verbal'
c           verbose listing of parameters
c     ntap        -c*100      input file name
c     otap        -c*100      output file name
c     nrec        -i*4        number of records in line
c     ntrc        -i*4        traces per record
c     nsamp       -i*4        samples per trace
c     nsi         -i*4        sample increment
c     iform       -i*4        data format 
c     iwst        -i*4        window start
c     iwed        -i*4        window end
c     ipt         -i*4        taper,percent 
c     freq1       -r*4        1st frequency
c     freq2       -r*4        last frequency
c     finc        -r*4        frequency increment
      write(lerr,*)'recording and processing parameters with defaults'
      write(lerr,*)'input data set name is ',ntap
      write(lerr,*)'output data set name is ',otap
      write(lerr,*)'number of records is ',nrec
      write(lerr,*)'traces per record is ',ntrc
      write(lerr,*)'samples per trace is ',nsamp
      write(lerr,*)'sample increment is ',nsi  
      write(lerr,*)'data format is ',iform
      write(lerr,*)'window start is ',iwst
      write(lerr,*)'window end is ',iwed
      write(lerr,*)'window taper is ',ipt,' percent'
      write(lerr,*)'frequency 1 is ',freq1
      write(lerr,*)'frequency 2 is ',freq2
      write(lerr,*)'frequency increment is ',finc
      return      
      end


C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*)
     :'execute samps by typing samps and a list of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)
     :' -N [ntap]    (default stdin)      : input data file name'
        write(LER,*)
     :' -O [otap]    (default stdout)      : output data file name'
        write(LER,*)
     :' -s[ist] (default = 0 ms):  start time of harmonic analysis (ms)'
        write(LER,*)
     :' -e[iend] (default = end trace): end time harmonic analysis (ms)'
        write(LER,*)
     :' -ts[its]      (default = first)         : start trace number'
        write(LER,*)
     :' -te[ite]      (default = last)         : end trace number'
        write(LER,*)
     :' -rs[irs]      (default = first)         : start record number'
        write(LER,*)
     :' -ne[ire]      (default = last)         : end record number'
        write(LER,*)
     :' -t [ipt] (def = none): % taper to apply to window'
        write(LER,*)
     :' -f1 [freq1] (def = 0hz): start freq of harmonic analysis (hz)'
        write(LER,*)
     :' -f2 [freq2] (def = Nyq): end freq of harmonic analysis (hz)'
        write(LER,*)
     :' -fi [finc] (def = 1./[window length (sec)]): freq increment(hz)'
        write(LER,*)
     :' -P  if present output phase (phase ref. equals window center)'
        write(LER,*)
     :' -dB  if output amplitude in decibels is desired, enter the'
        write(LER,*)
     :'      maximum decibel deflection.'
        write(LER,*)
     :' -XY  if present output x-y pairs to stdout (for plotting with xy
     : plotter'
        write(LER,*)
     :' -V  if present verbose output'
          write(LER,*)
     :'usage:   samps -N[ntap] -O[otap] -t[ipt] -f1[freq1] -f2[freq2]',
     :' -fi[finc] -s[ist] -e[iend] -its[its] -ite[ite] -rs[irs]',
     :' -re[ire] -XY -P -V'
         write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************




      subroutine drum (lphz, phz)
      real      phz(*)
      integer   lphz
      pi = 180.

      pj = 0.
      do  40 i = 2, lphz

          if (abs(phz(i)+pj-phz(i-1))-pi) 40,40,10

10        if (phz(i)+pj-phz(i-1)) 20,40,30

20        pj = pj +  2*pi
          go to 40

30        pj = pj -  2*pi

40        phz(i) = phz(i) + pj

      return
      end
