C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine polfit(y,x,npt,a,npol)

c     this subroutine calls the svdfit routine to calculate a
c     polynomial fit of npol coeficients to array y

c     program note: if "mp" is changed here then "nmax" must be changed
c                   in subroutine svdfit.

      external fpoly
      parameter(mp=4096,np=6)
      real*4 x(*),y(*),sig(mp),a(*)
      real*4 u(mp,np),v(np,np),w(np)



      do 10 i = 1,npt
        sig(i) = 1.0
   10 continue

      call svdfit(x,y,sig,npt,a,npol,u,v,w,mp,np,chisq,fpoly)

      return
      end


      subroutine svdfit(x,y,sig,ndata,a,ma,u,v,w,mp,np,chisq,fpoly)

      parameter(nmax=4096,mmax=6,tol=1.e-6)
      dimension x(*),y(*),sig(*),a(*),v(np,np),
     :    u(mp,np),w(np),b(nmax),afunc(mmax)

c - j.m.wade - 8/26/92 - had to add this declaration to pacify the hp
      external fpoly

      do 20 i=1,ndata
        call fpoly(x(i),afunc,ma)
        tmp=1./sig(i)
        do 10 j=1,ma
          u(i,j)=afunc(j)*tmp
   10   continue
        b(i)=y(i)*tmp
   20 continue
      call svdcmp(u,ndata,ma,mp,np,w,v)
      wmax=0.
      do 30 j=1,ma
        if(w(j).gt.wmax)wmax=w(j)
   30 continue
      thresh=tol*wmax
      do 40 j=1,ma
        if(w(j).lt.thresh)w(j)=0.
   40 continue
      call svbksb(u,w,v,ndata,ma,mp,np,b,a)
      chisq=0.
      do 60 i=1,ndata
        call fpoly(x(i),afunc,ma)
        sum=0.
        do 50 j=1,ma
          sum=sum+a(j)*afunc(j)
   50   continue
        chisq=chisq+((y(i)-sum)/sig(i))**2
   60 continue
      return
      end

      subroutine svbksb(u,w,v,m,n,mp,np,b,x)
      parameter (nmax=100)
      dimension u(mp,np),w(np),v(np,np),b(mp),x(np),tmp(nmax)
      do 20 j=1,n
        s=0.
        if(w(j).ne.0.)then
          do 10 i=1,m
            s=s+u(i,j)*b(i)
   10     continue
          s=s/w(j)
        endif
        tmp(j)=s
   20 continue
      do 40 j=1,n
        s=0.
        do 30 jj=1,n
          s=s+v(j,jj)*tmp(jj)
   30   continue
        x(j)=s
   40 continue
      return
      end

      subroutine svdcmp(a,m,n,mp,np,w,v)
      parameter (nmax=100)
      dimension a(mp,np),w(np),v(np,np),rv1(nmax)
      g=0.0
      scale=0.0
      anorm=0.0
      do 140 i=1,n
        l=i+1
        rv1(i)=scale*g
        g=0.0
        s=0.0
        scale=0.0
        if (i.le.m) then
          do 10 k=i,m
            scale=scale+abs(a(k,i))
   10     continue
          if (scale.ne.0.0) then
            do 20 k=i,m
              a(k,i)=a(k,i)/scale
              s=s+a(k,i)*a(k,i)
   20       continue
            f=a(i,i)
            g=-sign(sqrt(s),f)
            h=f*g-s
            a(i,i)=f-g
            if (i.ne.n) then
              do 50 j=l,n
                s=0.0
                do 30 k=i,m
                  s=s+a(k,i)*a(k,j)
   30           continue
                f=s/h
                do 40 k=i,m
                  a(k,j)=a(k,j)+f*a(k,i)
   40           continue
   50         continue
            endif
            do 60 k= i,m
              a(k,i)=scale*a(k,i)
   60       continue
          endif
        endif
        w(i)=scale *g
        g=0.0
        s=0.0
        scale=0.0
        if ((i.le.m).and.(i.ne.n)) then
          do 70 k=l,n
            scale=scale+abs(a(i,k))
   70     continue
          if (scale.ne.0.0) then
            do 80 k=l,n
              a(i,k)=a(i,k)/scale
              s=s+a(i,k)*a(i,k)
   80       continue
            f=a(i,l)
            g=-sign(sqrt(s),f)
            h=f*g-s
            a(i,l)=f-g
            do 90 k=l,n
              rv1(k)=a(i,k)/h
   90       continue
            if (i.ne.m) then
              do 120 j=l,m
                s=0.0
                do 100 k=l,n
                  s=s+a(j,k)*a(i,k)
  100           continue
                do 110 k=l,n
                  a(j,k)=a(j,k)+s*rv1(k)
  110           continue
  120         continue
            endif
            do 130 k=l,n
              a(i,k)=scale*a(i,k)
  130       continue
          endif
        endif
        anorm=max(anorm,(abs(w(i))+abs(rv1(i))))
  140 continue
      do 200 i=n,1,-1
        if (i.lt.n) then
          if (g.ne.0.0) then
            do 150 j=l,n
              v(j,i)=(a(i,j)/a(i,l))/g
  150       continue
            do 180 j=l,n
              s=0.0
              do 160 k=l,n
                s=s+a(i,k)*v(k,j)
  160         continue
              do 170 k=l,n
                v(k,j)=v(k,j)+s*v(k,i)
  170         continue
  180       continue
          endif
          do 190 j=l,n
            v(i,j)=0.0
            v(j,i)=0.0
  190     continue
        endif
        v(i,i)=1.0
        g=rv1(i)
        l=i
  200 continue
      do 270 i=n,1,-1
        l=i+1
        g=w(i)
        if (i.lt.n) then
          do 210 j=l,n
            a(i,j)=0.0
  210     continue
        endif
        if (g.ne.0.0) then
          g=1.0/g
          if (i.ne.n) then
            do 240 j=l,n
              s=0.0
              do 220 k=l,m
                s=s+a(k,i)*a(k,j)
  220         continue
              f=(s/a(i,i))*g
              do 230 k=i,m
                a(k,j)=a(k,j)+f*a(k,i)
  230         continue
  240       continue
          endif
          do 250 j=i,m
            a(j,i)=a(j,i)*g
  250     continue
        else
          do 260 j= i,m
            a(j,i)=0.0
  260     continue
        endif
        a(i,i)=a(i,i)+1.0
  270 continue
      do 390 k=n,1,-1
        do 370 its=1,30
          do 280 l=k,1,-1
            nm=l-1
            if ((abs(rv1(l))+anorm).eq.anorm)  go to 320
            if ((abs(w(nm))+anorm).eq.anorm)  go to 290
  280     continue
  290     c=0.0
          s=1.0
          do 310 i=l,k
            f=s*rv1(i)
            if ((abs(f)+anorm).ne.anorm) then
              g=w(i)
              h=sqrt(f*f+g*g)
              w(i)=h
              h=1.0/h
              c= (g*h)
              s=-(f*h)
              do 300 j=1,m
                y=a(j,nm)
                z=a(j,i)
                a(j,nm)=(y*c)+(z*s)
                a(j,i)=-(y*s)+(z*c)
  300         continue
            endif
  310     continue
  320     z=w(k)
          if (l.eq.k) then
            if (z.lt.0.0) then
              w(k)=-z
              do 330 j=1,n
                v(j,k)=-v(j,k)
  330         continue
            endif
            go to 380
          endif
          if (its.eq.30) pause 'no convergence in 30 iterations'
          x=w(l)
          nm=k-1
          y=w(nm)
          g=rv1(nm)
          h=rv1(k)
          f=((y-z)*(y+z)+(g-h)*(g+h))/(2.0*h*y)
          g=sqrt(f*f+1.0)
          f=((x-z)*(x+z)+h*((y/(f+sign(g,f)))-h))/x
          c=1.0
          s=1.0
          do 360 j=l,nm
            i=j+1
            g=rv1(i)
            y=w(i)
            h=s*g
            g=c*g
            z=sqrt(f*f+h*h)
            rv1(j)=z
            c=f/z
            s=h/z
            f= (x*c)+(g*s)
            g=-(x*s)+(g*c)
            h=y*s
            y=y*c
            do 340 nm=1,n
              x=v(nm,j)
              z=v(nm,i)
              v(nm,j)= (x*c)+(z*s)
              v(nm,i)=-(x*s)+(z*c)
  340       continue
            z=sqrt(f*f+h*h)
            w(j)=z
            if (z.ne.0.0) then
              z=1.0/z
              c=f*z
              s=h*z
            endif
            f= (c*g)+(s*y)
            x=-(s*g)+(c*y)
            do 350 nm=1,m
              y=a(nm,j)
              z=a(nm,i)
              a(nm,j)= (y*c)+(z*s)
              a(nm,i)=-(y*s)+(z*c)
  350       continue
  360     continue
          rv1(l)=0.0
          rv1(k)=f
          w(k)=x
  370   continue
  380   continue
  390 continue
      return
      end
      subroutine fpoly(x,p,np)
c     subroutine for fitting a set of with a polynomial of order np-1
      dimension p(np)
      p(1)=1.
      do 10 j=2,np
       p(j)=p(j-1)*x
   10 continue

       return
       end
