C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
          subroutine qloss(amp,t,q,x,vrms,nsamp,fl,fh,ierr)
      real amp(*),t(*),vrms(*),q(*)
      real x,parm,t0
      integer nsamp,i,ierr
c  amp       == gain factor  ie  gain corr trace(t) = amp(t) * trace(t)
c  t         == input time of each sample - array
c  q         == input q value at each time - array
c  x         == input x --- source reciever seperation scalar
c  vrms      == rms velocity - array
c  nsamp     == number of samples
c  ierr      == error flag  no/err= 0    / error      == 1
c
c

          pi = 4.0 * atan(1.0)


      do 100 i=1,nsamp

         if (q(i) .ne. 0) then
            t0 = t(i)

            if (vrms(i) .ne. 0) then
              tx = sqrt( t0**2 + x**2/vrms(i)**2 )
            else
              tx = t0
            endif

c           amp(i) =  exp( -pi * tx / q(i) )
            parm =exp( -pi * tx * fl/ q(i) )- exp( -pi * tx *fh/q(i))
            if (parm .ne. 0) then
                 amp(i)=1./ parm
            else
                 amp(i)=1.
            endif
          else

            ierr = 3

          endif
  100 continue

          return

          end
