C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rmsint(rms,vint,t,npairs)

c     this subroutine calculates rms velocity from interval velocity

c***********************************************************************
c* rms    -- (o) rms velocity which is calculated.
c* vint   -- (i) interval velocity to be converted to rms velocity.
c* t      -- (i) times associated with rms velocity
c* npairs -- (i) number of elements in rms and t
c***********************************************************************

      real*4 rms(*),vint(*),tempa,tempb,t(*)
      integer*4 npairs

      tempa=0.
      tempb=0.

      do 10 n=1,npairs

        tempa=  t(n)*vint(n)**2  + tempa

        tempb=  t(n) + tempb

        if (tempb .ne. 0.) then
         rms(n) =  sqrt(tempa/tempb)
        else
         rms(n) =  rms(n)
        endif
   10 continue
c
      return
      end
