C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      parameter (maxri = 10000)

      character
     :ntap*256, otap*256, mtap*256, vsis*256, tdfnf*256, name*5, 
     :veltyp*3

      character*50  
     :errtdf(6)

      integer   
     :itr(SZLNHD), rinumsv(maxri), rinudxv(maxri)

      integer 
     :nrecs, obytes, luin , luout,  lbytes, nbytes, lbyout,
     :nsamps, iforms, luins, argis, iexist, riless, rimore, 
     :numless, ri, nummore, npol, lumod, mode, ivelri, 
     :iq, iarray, isphd, icomp, static

c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      real
     :tri(SZLNHD),       vpv(SZLNHD),       vint(SZLNHD),
     :vrms(SZLNHD),      vmore(SZLNHD),     timesv(SZLNHD),
     :vless(SZLNHD),     
     :ampmck(SZLNHD),    qs(SZLNHD),        tless(SZLNHD),
     :tmore(SZLNHD),     aless(6),          aint(6),
     :arms(6),           amore(6),          trwrk(SZLNHD),
     :tracem(SZLNHD,256), offset, rless, rmore, velri

      logical
     :verbos, query
 
c     equivalence ( itr(129), tri (1) )
      data lbytes / 0 /, nbytes / 0 /, name/'SCALU'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif 
   
      ntap = ' '
      otap = ' '
      mtap = ' '
      vsis = ' '
      tdfnf = ' '
      call move(0,vpv,0,SZLNHD*SZSMPD)

      do 60 iz = 1, 6
60      errtdf(iz)(1:50) = ' '

      errtdf(1)  = ' no input file was found.'
      errtdf(2)  = ' non tdfn card encountered while gathering ris.'
      errtdf(3)  = ' end of file encountered reading ri numbers.'
      errtdf(4)  = ' ri numbers were not in ascending order.'
      errtdf(5)  = ' requested ri number has been passed.'
      errtdf(6)  = ' end of file encountered trying to read ri.'
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
      call gcmdln(ntap,mtap,vsis,tdfnf,veltyp,otap,mode,
     :  qvalue,iq,iarray,isphd,icomp,lerr,verbos)

      call parchk(ntap,mtap,vsis,tdfnf,veltyp,otap,mode,
     :     qvalue,iq,iarray,isphd,icomp,lerr,verbos)

c-----
c get logical units
c-----

      luins = -99
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      if (vsis(1:1) .ne. ' ' ) then
        call getln(luins, vsis,'r', 0)
        if ( luins .lt. 0 ) then
          write(lerr,*)'ERROR!'
          write(lerr,*)'Fatal error in obtaining logical unit'
          write(lerr,*)'for sis velocity file.'
          write(lerr,*) ' '
          istop = 1
        endif 
      endif 

      if (mode .eq. 2 .or. mode .eq. 3 ) then
        if (mtap(1:1) .ne. ' ' ) then
          call getln(lumod, mtap,'r', 0)
          if ( lumod .lt. 0 ) then
            write(lerr,*)'ERROR!'
            write(lerr,*)'Fatal error in obtaining logical unit'
            write(lerr,*)'for scaler file.'
            write(lerr,*) ' '
            istop = 1
          endif 
        endif 
      endif 

      if ( luin .lt. 0 .or. luout .lt. 0 ) then
         write(lerr,*)'ERROR!'
         write(lerr,*)'fatal error in obtaining logical unit'
         write(lerr,*)'for input and/or output seismic files'
         write(lerr,*) ' '
         istop = 1
      endif 
      if ( istop .ne. 0 ) stop

c------
c open scaler tape
c------
      nsampm = 0
      if (mode .eq. 2 .or. mode .eq. 3 ) then
        call charct(mtap,100,lenm)
        nbytes = 0
        call rtape  ( lumod, itr, nbytes)
        if (nbytes .eq. 0) then
           write(lerr,*)' '     
           write(lerr,*)'ERROR!'
           write(lerr,*)'no header read '
           write(lerr,*)'File = ',mtap(:lenm)
           call lbclos(lumod)
           stop
        endif 
c------
c get line hdr poop for scaler file
c------
        istop = 0
        call saver(itr, 'NumSmp', nsampm, LINHED)
        call saver(itr, 'SmpInt', nsim ,  LINHED)
        call saver(itr, 'NumTrc', ifoldm, LINHED)
        call saver(itr, 'NumRec', nrecm,  LINHED)
        call saver(itr, 'Format', iformm, LINHED)
c       call saver(itr, 'FoldNm', ifoldm, LINHED)
        call saver(itr, 'UnitFl', iunitm, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
        deltatm = float(nsim) * unitsc
        deltatm = float (nint(deltatm / unitsc)) * unitsc

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

        if ( iformm .ne. 3 .and. iformm .ne. 1 ) then
          write (lerr,*)' '
          write (lerr,*)'Problem with format of file'
          write (lerr,*)'File = ',mtap(:lenm)
          write (lerr,*)'format = ',iformm
          call lbclos(luout)
          call lbclos(luin)
          call lbclos(lumod)
          istop = 1
        endif  

        if ( nsampm .gt. SZLNHD ) then
          write (lerr,*)' '
          write (lerr,*)'File = ',mtap(:lenm)
          write (lerr,*)'ERROR'
          write (lerr,*)'Scaler file - No. Samples/trace = ',nsampm
          write (lerr,*)'The max allowed is ',SZLNHD 
          call lbclos(luout)
          call lbclos(luin)
          call lbclos(lumod)
          istop = 1
        endif 

        if ( ifoldm .gt. 256 ) then
          write (lerr,*)' '
          write (lerr,*)'File = ',mtap(:lenm)
          write (lerr,*)'ERROR'
          write (lerr,*)'Scaler file - No. traces/record = ',ifoldm
          write (lerr,*)'The max allowed is 256' 
          call lbclos(luout)
          call lbclos(luin)
          call lbclos(lumod)
          istop = 1
        endif 
        if ( istop .ne. 0 ) stop   
c-------
c       ready to read in data for ri
c-------
 
c----
c       bytes per trace
c----
        nbtrm = SZSMPD * nsampm 
        do 100 j = 1, ifoldm
          nbytes = 0
          call rtape (lumod, itr, nbytes)
          if (nbytes .eq. 0 ) then
            write(lerr,*)' '
            write(lerr,*)'possible programming problem at the'
            write(lerr,*)'do 100 loop - encountered EOF'
            call lbclos(lumod)
            call lbclos(luout)
            call lbclos(luin)
            stop
          endif 
          call vmov (itr(ITHWP1), 1, tri, 1, nsampm)
c           write(lerr,*)' Reading scaler trace ',j
            call move ( 1, tracem(1,j), itr(ITHWP1), nbtrm ) 
100     continue 
        call lbclos(lumod)
      endif 

c------
c open surface seismic
c-----

c     write(lerr,*)' ready to open seismic'  
      call charct(ntap,100,lenn)
      nbytes = 0
      call rtape(luin,itr,nbytes)
      if ( nbytes .eq. 0 ) then
        write(lerr,*)' '
        write(lerr,*)'ERROR!'
        write(lerr,*)'File = ',ntap(:lenn)
        write(lerr,*)'No header read '
        call lbclos(luin)
        call lbclos(luout)
        stop
      endif 

c------
c get line hdr poop for surface seismic file
c------

      istop = 0
      call saver(itr, 'NumSmp', nsamps, LINHED)
      call saver(itr, 'SmpInt', nsis ,  LINHED)
      deltats = float(nsis) / 1000.00
      deltats = float (nint(deltats * 1000.00)) / 1000.0
      call saver(itr, 'NumTrc', ifolds,  LINHED)
      call saver(itr, 'NumRec', nrecs,  LINHED)
      call saver(itr, 'Format', iforms, LINHED)
c     call saver(itr, 'FoldNm', ifolds, LINHED)
      call saver(itr, 'UnitFl', iunits, LINHED)
      if ( iforms .ne. 3 .and. iforms .ne. 1 ) then
        write (lerr,*)' '
        write (lerr,*)'File = ',ntap(:lenn)
        write (lerr,*)'Problem with format of file'
        write (lerr,*)'format = ',iforms
        call lbclos(luins)
        call lbclos(luin)
        call lbclos(luout)
        istop = 1
      endif  
      if ( nsamps .gt. SZLNHD ) then
        write (lerr,*)' '
        write (lerr,*)'File = ',ntap(:lenn)
        write (lerr,*)'ERROR'
        write (lerr,*)'Seis. input - No. Samples/trace = ',nsamps
        write (lerr,*)'The max allowed is ',SZLNHD 
        call lbclos(luout)
        call lbclos(luin)
        istop = 1
      endif 

      if ( ifolds .gt. 256 ) then
        write (lerr,*)' '
        write (lerr,*)'File = ',ntap(:lenn)
        write (lerr,*)'ERROR'
        write (lerr,*)'Seis. input - No. traces/record = ',ifolds
        write (lerr,*)'The max allowed is 256' 
        call lbclos(luout)
        call lbclos(luin)
        istop = 1
      endif 
      if ( istop .ne. 0 ) stop   

c------
c lineheader: output to printer file and update
c------
      call hlhprt (itr, nbytes, name, 5, LERR)
c----
c determine whether the input scaler dataset or the input surface
c seismic dataset had more samples and calculate times accoringly.
c----
   
      if (nsampm .ge. nsamps) then
        maxnum = nsampm
        call savew(itr, 'NumSmp', maxnum, LINHED)
      else
        maxnum = nsamps
      endif 
      obytes = SZSMPD*maxnum + SZTRHD
      
      if ( iforms .eq. 1 ) then
        ifrout = 3
        call savew(itr, 'Format', ifrout, LINHED)
      endif 

      call savhlh(itr, nbytes, lbyout)
      call wrtape (luout, itr, lbyout)
c-----
c compare scaler and surf. seis. sample intervals
c-----
      if ( mode .eq. 2 .or. mode .eq. 3 ) then
        if (deltats .ne. deltatm ) then
          write(lerr,*)' '
          write(lerr,*)'Surface seismic sample interval = ',nsis
          write(lerr,*)'Scaler file sample interval = ',nsim
          write(lerr,*)' '
          write(lerr,*)'Sample intervals do not agree'
          istop = 1
        endif 
c-----
c compare scaler and surf. seis fold
c-----
        if (ifolds .ne. ifoldm ) then
          write(lerr,*)' '
          write(lerr,*)'Surface seismic fold = ',ifolds
          write(lerr,*)'Scaler file fold = ',ifoldm
          write(lerr,*)' '
          write(lerr,*)'Folds do not agree'
          istop = 1
        endif 
c-----
c compare scaler file and surf. seis. unit flags
c-----
        if (iunits .ne. iunitm ) then
          write(lerr,*)' '
          write(lerr,*)'Surface seismic unit flag = ',iunits
          write(lerr,*)'Scaler file unit flag = ',iunitm
          write(lerr,*)' '
          write(lerr,*)'Unit flags do not agree'
          istop = 1
        endif 

        if ( istop .ne. 0 ) then
          call lbclos(luin)
          call lbclos(luout)
          stop
        endif 
      endif 

c     write(lerr,*)'have opened seismic'
c     write(lerr,*)' '
c     write(lerr,*)'nsamps,nsis,deltats,ifolds = ',
c    :nsamps,nsis, deltats,ifolds
c     write(lerr,*)'nrecs,iforms,ifolds,iunits = ',
c    :nrecs,iforms,ifolds,iunits

      if ( mode .eq. 1 .or. mode .eq. 3 ) then 
        if ( vsis(1:1) .ne. ' ') then
c------
c         open velocity sis file
c-----
          call charct(vsis,100,lenv)
          nbytes = 0
          call rtape(luins,itr,nbytes)
          if ( nbytes .eq. 0 ) then
            write(lerr,*)' '
            write(lerr,*)'ERROR!'
            write(lerr,*)'No header read '
            write(lerr,*)'File = ',vsis(:lenv)
            call lbclos(luin)
            call lbclos(luin)
            call lbclos(luout)
            stop
          endif 

c------
c get line hdr poop for sis velocity file
c------
          istop = 0
          call saver(itr, 'NumSmp', nsampv, LINHED)
          nbytv = SZSMPD*nsampv
          call saver(itr, 'SmpInt', nsiv ,  LINHED)
          deltatv = float(nsiv) / 1000.00
          deltatv = float (nint(deltatv * 1000.00)) / 1000.0
          call saver(itr, 'NumTrc', ifoldv, LINHED)
          call saver(itr, 'NumRec', nrecv,  LINHED)
          call saver(itr, 'Format', iformv, LINHED)
          call saver(itr, 'UnitFl', iunitv, LINHED)
          if ( iformv .ne. 3 .and. iformv .ne. 1 ) then
            write (lerr,*)' '
            write (lerr,*)'File = ',vsis(:lenv)
            write (lerr,*)'ERROR'
            write (lerr,*)'Problem with format of file'
            write (lerr,*)'Format = ',iformv
            call lbclos(luins)
            call lbclos(luin)
            call lbclos(luout)
            istop = 1
          endif  
          if ( nsampv .gt. SZLNHD ) then
            write (lerr,*)' '
            write (lerr,*)'File = ',vsis(:lenv)
            write (lerr,*)'ERROR'
            write (lerr,*)'Seis. input - No. Samples/trace = ',nsampv
            write (lerr,*)'The max allowed is ',SZLNHD 
            call lbclos(luout)
            call lbclos(luin)
            istop = 1
          endif 
          if ( istop .ne. 0 ) stop   

c----
c         now capture ri numbers from file.
c----
          lenc = len(vsis)
          call charct(vsis,lenc,lenv)
          call kapris (luins,maxri,itr,numriv,rinumsv,rinudxv,ierror)
          if ( ierror .ne. 0 ) then
            if ( ierror .eq. 1 ) then
              write (lerr,*)' '
              write (lerr,*)'File =',vsis(:lenv)          
              write (lerr,*)'ERROR'
              write (lerr,*)'no data in velocity sis file.'
              call lbclos(luout)
              call lbclos(luin)
              call lbclos(luins)
              stop
            endif 
            if ( ierror .eq. 2 ) then
              write (lerr,*)' '
              write (lerr,*)'File =',vsis(:lenv)          
              write (lerr,*)'ERROR'
              write (lerr,*)'Too many records for pgm.' 
              write (lerr,*)'Exceeds ',maxri
              call lbclos(luout)
              call lbclos(luin)
              call lbclos(luins)
              stop
            endif 
          endif 
          minvri = rinumsv(1)
          maxvri = rinumsv(numriv)
          if (verbos) then
            write(lerr,*)' '
            write(lerr,*)'Minimum velocity RI = ',minvri
            write(lerr,*)'Maximum velocity RI = ',maxvri
            write(lerr,*)' '
          endif 
        endif 
    
        if ( tdfnf(1:1) .ne. ' ') then
          call charct(tdfnf,100,lent)
          ierror = 0
          iopen = 0
          ri    = 0
          lusisv = 52
          call tdfninb (vpv, timesv, nsampv, rinumsv, numriv, iopen,
     :             ri, tdfnf, lusisv, ierror)
          if ( ierror .eq. 1 ) then
            write(lerr,*)' '
            write(lerr,*)'Unable to open file'
            write(lerr,*)'File = ',tdfnf(:lent)
            call lbclos(luin)
            call lbclos(luout)
            stop
          endif 
          if ( ierror .ne. 0 ) then
            write(lerr,*)' '
            write(lerr,*)'Programming bust in tdfninb or problem'
            write(lerr,*)'with file'
            write(lerr,*)'ierror = ',ierror     
            write(lerr,*)'File = ',tdfnf(:lent)
            call lbclos(luin)
            call lbclos(luout)
            stop
          endif 

c-----
c get ri numbers from tdfn file
c-----

          iopen = 1
          ierror = 0
          ri    = 0
          call tdfninb (vpv, timesv, nsampv, rinumsv, numriv, iopen,
     :             ri, tdfnf, lusisv, ierror)
          if ( ierror .ne. 0 ) then
            write(lerr,*)' '
            write(lerr,*)'Problem reading file'
            write(lerr,*)'ierror = ',ierror     
            write(lerr,*)'File = ',tdfnf(:lent)
            call lbclos(luin)
            call lbclos(luout)
            close(lusisv)
            stop
          endif 
          minvri = rinumsv(1)
          maxvri = rinumsv(numriv)
          if (verbos) then
            write(lerr,*)' '
            write(lerr,*)'Minimum TDFN RI = ',minvri  
            write(lerr,*)'Maximum TDFN RI = ',maxvri
            write(lerr,*)' '
c           write(lerr,*)(rinumsv(kk),kk = 1,numriv)
          endif 
        else 
          if ( vsis(1:1) .eq. ' ' ) then
            write(lerr,*)' '
            write(lerr,*)'Problem with velocity file specification.'
            write(lerr,*)'Most likely a program bug'
            call lbclos(luin)
            call lbclos(luins)
            call lbclos(luout)
            stop
          endif 
        endif 
         
      endif 
c-----------------------
c  here's the meat...
c----------------------

c-----
c     process trace records
c
c     if mode = 1 or 3 process through subroutine gain
c     if mode = 2 or 3 apply scaler record.
c-----

      ic = 0
      nbyts = SZSMPD * nsamps
      do 9000 m = 1, nrecs
        ic = ic + 1

        do 8000 j = 1 ,ifolds
          nbytes = 0
          call rtape(luin,itr,nbytes)
          if ( nbytes .eq. 0) then
            write(lerr,*)' '
            write(lerr,*)' EOF condition encountered'
            write(lerr,*)' in input seismic file'
            write(lerr,*)' '
            if ( ic .eq. 0 ) then
              write(lerr,*)'ERROR ' 
              write(lerr,*)'File = ',ntap(:lenn)
              write(lerr,*)'No data'
              call lbclos(luin)
              call lbclos(luout)
              stop
            endif  
            if ( j .gt. 1 ) then
              write(lerr,*)'ERROR ' 
              write(lerr,*)'File = ',ntap(:lenn)
              write(lerr,*)'Problem with line header parm'
              write(lerr,*)'traces/record'
              write(lerr,*)'or last record not complete'
              write(lerr,*)' ' 
              call lbclos(luin)
              call lbclos(luout)
              stop
            endif  
          endif  
          if (verbos .and. j .eq. 1 )write(LERR,*)'Scaled RI ',itr(106)

          if((mode.eq.1.or.mode.eq.3) .and. j .eq. 1 ) then

c           ivelri = itr(106)
            call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                  ivelri , TRACEHEADER)

            if ( vsis(1:1) .ne. ' ') then
c----
c             is  ri command line within the found set of 
c             velocity ri's
c----

c-----
c         deal with the case of the user specifying an ri number 
c         less than the first existing ri. in this case the first 
c         existing ri will be used.
c-----
              if (ivelri .lt. minvri) then
                ri = minvri
                if ( verbos ) write ( lerr, 10003) ri
                iexist = 1
                call sisseek(luins,1)
c----
c used in interactive pgm
c   call velsis (lh, hlh, lhlh, th, vpv, ri, tn, iopen,
c    :                 fnsisv, error, ibms, iformt, lusisv)
c----
                nbytes = 0
                call rtape (luins, itr, nbytes)
                if (nbytes .eq. 0 ) then
                  write(lerr,*)' '
                  write(lerr,*)'possible programming problem at'
                  write(lerr,*)'case 1 - sis velocity'
                  write(lerr,*)'maybe EOF'
                  call lbclos(luins)
                  call lbclos(luin)
                  call lbclos(luout)
                  stop
                endif 
                if ( iformv .eq. 3 ) then
                  call move ( 1, vpv, itr(ITHWP1),nbytv)
                else
                  it = 128
                  do 1095 j1 = 1, nsampv
                    it = it + 1
                    vpv(j1) = itr(it)
1095              continue
                endif 
c
c calculate the times to be needed later on for the curve fit.
c
                do 1100  i8 = 1, nsampv
                  timesv(i8) = float(i8-1) * deltatv
1100            continue
                go to 1180
              endif 

c-----
c deal with the case of the user specifying an ri number > than
c the last existing ri. in this case the first existing ri will
c be used.
c-----
              if (ivelri .gt. maxvri) then
                iexist = 1
                ri = rinudxv(numriv)
                if ( verbos ) write ( lerr, 10003) ri
10003             format('Extrapolated a velocity from function at RI ',
     :              i5)
                call sisseek(luins,ri)
c----
c used in interactive pgm
c   call velsis (lh, hlh, lhlh, th, vpv, ri, tn, iopen,
c    :                 fnsisv, error, ibms, iformt, lusisv)
c----
                nbytes = 0
                call rtape (luins, itr, nbytes)
                if (nbytes .eq. 0 ) then
                  write(lerr,*)' '
                  write(lerr,*)'possible programming problem at'
                  write(lerr,*)'case 2 - sis velocity'
                  write(lerr,*)'maybe EOF'
                  call lbclos(luins)
                  call lbclos(luin)
                  call lbclos(luout)
                  stop
                endif 
                if ( iformv .eq. 3 ) then
                  call move ( 1, vpv, itr(ITHWP1),nbytv)
                else
                  it = 128
                  do 1135 j1 = 1, nsampv
                    it = it + 1
                    vpv(j1) = itr(it)
1135              continue
                endif 
c
c calculate the times to be needed later on for the curve fit.
c
                do 1110  i8 = 1, nsampv
                  timesv(i8) = float(i8-1) * deltatv
1110            continue
                go to 1180
              endif 
c----
c now see if we are dealing with the case of the user specified ri
c being between the minimum and maximum existing ri's and see if it
c is actually one of the existing ri's. if so trap it and go on.
c----
              if (ivelri.ge.minvri.and.ivelri.le.maxvri) then
                igot = 0
                do 1120  i = 1, numriv
                  ivri = rinumsv(i)
                  if (ivelri .eq. ivri) then
                    igot = i
                    go to 1130
                  endif 
1120            continue
1130            continue
                if (igot .gt. 0) then
                  iexist = 1
                  ri = rinudxv(igot)
                  if ( verbos ) write (lerr,10002)ivri
10002               format('Using velocity function at RI ',i5)
                  call sisseek(luins,ri)
c----
c used in interactive pgm
c            call velsis (lh, hlh, lhlh, th, vpv, ri, tn, iopen,
c                        fnsisv, error, ibms, iformt, lusisv)
c-----
                  nbytes = 0
                  call rtape (luins, itr, nbytes)
                  if (nbytes .eq. 0 ) then
                    write(lerr,*)' '
                    write(lerr,*)'possible programming problem at'
                    write(lerr,*)'case 3 - sis velocity'
                    write(lerr,*)'maybe EOF'
                    call lbclos(luins)
                    call lbclos(luin)
                    call lbclos(luout)
                    stop
                  endif 
                  if ( iformv .eq. 3 ) then
                    call move ( 1, vpv, itr(ITHWP1),nbytv)
                  else
                    it = 128
                    do 1136 j1 = 1, nsampv
                      it = it + 1
                      vpv(j1) = itr(it)
1136                continue
                  endif 
c-----
c calculate the times to be needed later on for the curve fit.
c-----
                  do 1140  i = 1, nsampv
                    timesv(i) = float(i-1) * deltatv
1140              continue
                  go to 1180
                endif 
              endif 
c-----
c now see if we are dealing with the fourth and final possible
c case. that being the case when the user specifies an ri that
c is in between two existing ri's. if that is the case trap the
c ri on either side for later use.
c-----
              if (ivelri .gt. minvri. and. ivelri .lt. maxvri) then
                igot = 0
                do 1150  i = 1, numriv - 1
                  ivri = rinumsv(i)
                  ivrip1 = rinumsv(i+1)
                  if (ivelri.gt.ivri.and.ivelri.lt.ivrip1) then
                    igot = i
                    go to 1160
                  endif 
1150            continue
1160            continue
                iexist = 0
                riless = rinudxv(igot)
                rimore = rinudxv(igot+1)
                if ( verbos )
     :            write(lerr,10001)riless,rimore
10001             format('Interpolating a function using velocity functi
     :ons for RI ',i5,' and ',i5)
                call sisseek(luins,riless)
c-----
c used in interactive pgm
c    call velsis (lh, hlh, lhlh, th, vless, riless, tn,
c   :    iopen, fnsisv, error, ibms, iformt, lusisv)
c-----
                nbytes = 0
                call rtape (luins, itr, nbytes)
                if (nbytes .eq. 0 ) then
                  write(lerr,*)' '
                  write(lerr,*)'possible programming problem at'
                  write(lerr,*)'case 4 - sis velocity'
                  write(lerr,*)'maybe EOF'
                  call lbclos(luins)
                  call lbclos(luin)
                  call lbclos(luout)
                  stop
                endif 
                if ( iformv .eq. 3 ) then
                  call move ( 1, vless, itr(ITHWP1),nbytv)
                else
                  it = 128
                  do 1155 j1 = 1, nsampv
                    it = it + 1
                    vless(j1) = itr(it)
1155              continue
                endif 

                call sisseek(luins,rimore)
c----
c used in interactive pgm
c    call velsis (lh, hlh, lhlh, th, vmore, rimore, tn,
c   : iopen, fnsisv, error, ibms, iformt,lusisv)
c----
                nbytes = 0
                call rtape (luins, itr, nbytes)
                if (nbytes .eq. 0 ) then
                  write(lerr,*)' '
                  write(lerr,*)'possible programming problem at'
                  write(lerr,*)'case 4 - sis velocity'
                  write(lerr,*)'maybe EOF'
                  call lbclos(luins)
                  call lbclos(luin)
                  call lbclos(luout)
                  stop
                endif 
                if ( iformv .eq. 3 ) then
                  call move ( 1, vmore, itr(ITHWP1),nbytv)
                else
                  it = 128
                  do 1165 j1 = 1, nsampv
                    it = it + 1
                    vmore(j1) = itr(it)
1165              continue
                endif 
c-----
c calculate the times to be needed later on for the curve fit.
c-----
                do 1170  i = 1, nsampv
                  timesv(i) = float(i-1) * deltatv
1170            continue
              endif 
1180          continue

            endif 

            if ( tdfnf(1:1) .ne. ' ') then

c----
c deal with the case of the user specifying an ri number less than 
c the first existing ri. in this case the first existing ri will 
c be used.
c----
              if (ivelri .lt. minvri) then
                iexist = 1
                ierror = 0
                iopen  = 2
                ri     = rinumsv(1)
                if ( verbos ) write ( lerr, 10003) ri
                call tdfninb (vpv,timesv,nsampv,rinumsv,numriv,iopen,
     :                 ri, tdfnf, lusisv, ierror)
                if ( ierror .ne. 0 ) then
                  write(lerr,*)' '
                  write(lerr,*)'File = ',tdfnf(:lent)
                  write(lerr,*) errtdf(ierror)
                  call lbclos(luin)
                  call lbclos(luout)
                  close(lusisv)
                  stop
                endif 
                go to 1520
              endif 

c----
c deal with the case of the user specifying an ri number greater
c than the last existing ri. in this case the last existing ri
c will be used.
c----

              if (ivelri .gt. maxvri) then
                iexist = 1
                ierror = 0
                iopen  = 2
                ri = rinumsv(numriv)
                if ( verbos ) write ( lerr, 10003) ri
                call tdfninb (vpv,timesv,nsampv,rinumsv,numriv,iopen,
     :             ri, tdfnf, lusisv, ierror)
                if ( ierror .ne. 0 ) then
                  write(lerr,*)' '
                  write(lerr,*)'File = ',tdfnf(:lent)
                  write(lerr,*) errtdf(ierror)
                  call lbclos(luin)
                  call lbclos(luout)
                  close(lusisv)
                  stop
                endif 
                go to 1520
              endif 

c-----
c now see if we are dealing with the case of the user specified ri
c being between the minimum and maximum existing ri's and see if it
c is actually one of the existing ri's. if so trap it and go on.
c-----
              if (ivelri.ge.minvri.and.ivelri.le.maxvri) then
                igot = 0
                do 1480  i = 1, numriv
                  ivri = rinumsv(i)
                  if (ivelri .eq. ivri) then
                    igot = i
                    go to 1490
                  endif 
1480            continue
1490            continue
                if ( igot .gt. 0 ) then
                  ierror  = 0
                  iexist = 1
                  iopen  = 2
                  ri     = rinumsv(igot)
                  if ( verbos ) write (lerr,10002)ri
                  call tdfninb (vpv, timesv,nsampv, rinumsv, numriv,
     :                iopen, ri, tdfnf, lusisv, ierror)
                  if ( ierror .ne. 0 ) then
                    write(lerr,*)' '
                    write(lerr,*)'File = ',tdfnf(:lent)
                    write(lerr,*) errtdf(ierror)
                    call lbclos(luin)
                    call lbclos(luout)
                    close(lusisv)
                    stop
                  endif 
c                 write (lerr,*)' ri = ',ri
c                 do 3333 kk = 1,nsampv
c                   write(lerr,*)timesv(kk),vpv(kk)
c3333              continue
                  go to 1520
                endif 
              endif 

c-----
c now see if we are dealing with the fourth and final possible case.
c that being the case when the user specifies an ri that is in
c between two existing ri's. if that is the case trap the ri on
c either side for later use.
c-----

              if (ivelri.gt.minvri.and.ivelri.lt.maxvri) then
                igot = 0
                do 1500  i = 1, numriv - 1
                  ivri = rinumsv(i)
                  ivrip1 = rinumsv(i+1)
                  if (ivelri.gt.ivri.and.ivelri.lt.ivrip1) then
                    igot = i
                    go to 1510
                  endif 
1500            continue
1510            continue
                ierror  = 0
                iexist = 0
                iopen  = 2
                riless = rinumsv(igot)
                rimore = rinumsv(igot + 1)
                if ( verbos )
     :            write(lerr,10001)riless,rimore

                call tdfninb (vless,tless,numless,rinumsv,numriv,iopen,
     :             riless, tdfnf, lusisv, ierror)
                if ( ierror .ne. 0 ) then
                  write(lerr,*)' '
                  write(lerr,*)'File = ',tdfnf(:lent)
                  write(lerr,*) errtdf(ierror)
                  call lbclos(luin)
                  call lbclos(luout)
                  close(lusisv)
                  stop
                endif 
                call tdfninb (vmore,tmore,nummore,rinumsv,numriv,iopen,
     :           rimore, tdfnf, lusisv, ierror)
                if ( ierror .ne. 0 ) then
                  write(lerr,*)' '
                  write(lerr,*)'File = ',tdfnf(:lent)
                  write(lerr,*) errtdf(ierror)
                  call lbclos(luin)
                  call lbclos(luout)
                  close(lusisv)
                  stop
                endif 
              endif 
c             write(lerr,*)'vless ****'
c             write(lerr,*)(tless(kuzz),vless(kuzz),kuzz = 1,numless)
c             write(lerr,*)'vmore ****'
c             write(lerr,*)(tmore(kuzz),vmore(kuzz),kuzz = 1,nummore)

c-----
c close tdfn file
c-----
c1520          close(lusisv)
1520          continue
            endif 
       
c------
c to get here we have input a velocity dataset in either sis or tdfn
c format. this velocity data could have been in the form of rms
c velocities or interval velocities. this next section of code will
c deal with calculating the form of velocities not input from those
c that were input (rms from interval or interval from rms).
c
c
c the following if block will deal with the case of the user 
c specifying an ri number that resulted in an existing ri being 
c input into the program. in this case no interpolation will be 
c needed.
c------
           if (iexist .eq. 1) then

             npol = 6
             if (veltyp .eq. 'int') then
               call polfit (vpv, timesv, nsampv, aint, npol)
             else
               call polfit (vpv, timesv, nsampv, arms, npol)
             endif 

             do 1530 i = 1, maxnum
               timesv(i) = float(i - 1) * deltats
1530         continue
c----
c see if interval velocities or rms velocities were input and
c calculate a full size set of velocities to match the total number
c of times just calculated.
c----

             if (veltyp .eq. 'int') then
               do 1540 ii = 1, maxnum
                 vint(ii) = aint(1) + aint(2) * timesv(ii) +
     :                       aint(3) * timesv(ii) ** 2 +
     :                       aint(4) * timesv(ii) ** 3 +
     :                       aint(5) * timesv(ii) ** 4 +
     :                       aint(6) * timesv(ii) ** 5
1540           continue
             else
               do 1550 ii = 1, maxnum
                 vrms(ii) = arms(1) + arms(2) * timesv(ii) +
     :                     arms(3) * timesv(ii) ** 2 +
     :                     arms(4) * timesv(ii) ** 3 +
     :                     arms(5) * timesv(ii) ** 4 +
     :                     arms(6) * timesv(ii) ** 5
1550           continue
             endif 

           endif 
c----
c The following if block will deal with the case of the user
c specifying an ri number that did not result in an existing ri
c being used. In this case interpolation will be needed. the
c number of time velocity pairs might vary in the tdfn case
c between ri's so watch what arguments are used in the following
c lines.
c----
           if (iexist .eq. 0) then
              npol = 6
              if (vsis(1:1) .ne. ' ' ) then
                call polfit (vless, timesv, nsampv, aless, npol)
                call polfit (vmore, timesv, nsampv, amore, npol)
c             elseif (veltyp .eq. 'rms') then
              else
                call polfit (vless, tless, numless, aless, npol)
                call polfit (vmore, tmore, nummore, amore, npol)
              endif 
c     
              do 1560 ij = 1, maxnum
                 timesv(ij) = float(ij - 1) * deltats
1560          continue
c     
              do 1570 i = 1, maxnum
                vless(i) = aless(1) + aless(2) * timesv(i) +
     :                     aless(3) * timesv(i) ** 2 +
     :                     aless(4) * timesv(i) ** 3 +
     :                     aless(5) * timesv(i) ** 4 +
     :                     aless(6) * timesv(i) ** 5
c     
                vmore(i) = amore(1) + amore(2) * timesv(i) +
     :                     amore(3) * timesv(i) ** 2 +
     :                     amore(4) * timesv(i) ** 3 +
     :                     amore(5) * timesv(i) ** 4 +
     :                     amore(6) * timesv(i) ** 5
1570          continue

c-----
c now we need to interpolate a velocity array for the ri specifed by
c the user by using the existing ri on either side of it.
c-----
              rless = float(riless)
              rmore = float(rimore)
              velri = float(ivelri)
              if (veltyp .eq. 'int') then
                do 1580 i = 1, maxnum
                  vint(i) = vless(i) + (((velri - rless) /
     :                    (rmore - rless)) * (vmore(i) - vless(i)))
c                 vint(i) = (((velri - rless) / (rmore - rless))
c    :                        * vless(i)) + (((rmore - velri) /
c    :                          (rmore - rless)) * vmore(i))
1580            continue
c             elseif (veltyp .eq. 'rms') then
              else
                do 1590 i = 1, maxnum
                  vrms(i) = (((velri - rless) / (rmore - rless))
     :                        * vless(i)) + (((rmore - velri) /
     :                          (rmore - rless)) * vmore(i))
1590            continue
              endif 
c----
c now calculate a new polynomial for the curve you just created and
c then recreate the curve where it will match the polynomial.
c----
c
              npol = 6
              if (veltyp .eq. 'int') then
                   call polfit (vint, timesv, maxnum, aint, npol)
c             elseif (veltyp .eq. 'rms') then
              else
                   call polfit (vrms, timesv, maxnum, arms, npol)
              endif 
c
              if (veltyp .eq. 'int') then
                do 1600 i = 1, maxnum
                  vint(i) = aint(1) + aint(2) * timesv(i) +
     :                      aint(3) * timesv(i) ** 2 +
     :                      aint(4) * timesv(i) ** 3 +
     :                      aint(5) * timesv(i) ** 4 +
     :                      aint(6) * timesv(i) ** 5
1600            continue
c             elseif (veltyp .eq. 'rms') then
              else
                do 1610 i = 1, maxnum
                  vrms(i) = arms(1) + arms(2) * timesv(i) +
     :                      arms(3) * timesv(i) ** 2 +
     :                      arms(4) * timesv(i) ** 3 +
     :                      arms(5) * timesv(i) ** 4 +
     :                      arms(6) * timesv(i) ** 5
1610            continue
              endif 
           endif 
c------
c now we need to deal with generating the velocity set opposite
c of what was entered by the user. what i'm saying is if the user
c entered rms velocities we need to generated interval velocities
c and visa versa.
c------
           if (veltyp .eq. 'int') then
             call rmsint (vrms, vint, timesv, maxnum)
           else
             error = 0
             call intrms (vrms, vint, timesv, maxnum, error)
             if (error .ne. 0) then
               print*,'intrms returned an error code indicating'
               print*,'a decrease in rms velocity was found.'
               stop
             endif 
           endif 
c
c now calculate a polynomial to represent the velocity array just
c generated and then regenerate the velocity array using the
c polynomial.
c
           npol = 6
           if (veltyp .eq. 'int') then
              call polfit (vrms, timesv, maxnum, arms, npol)
              do 1620 i = 1, maxnum
                   vrms(i) = arms(1) + arms(2) * timesv(i) +
     :                       arms(3) * timesv(i) ** 2 +
     :                       arms(4) * timesv(i) ** 3 +
     :                       arms(5) * timesv(i) ** 4 +
     :                       arms(6) * timesv(i) ** 5
1620          continue
           else
              call polfit (vint, timesv, maxnum, aint, npol)
              do 1630 i = 1, maxnum
                   vint(i) = aint(1) + aint(2) * timesv(i) +
     :                       aint(3) * timesv(i) ** 2 +
     :                       aint(4) * timesv(i) ** 3 +
     :                       aint(5) * timesv(i) ** 4 +
     :                       aint(6) * timesv(i) ** 5
1630          continue
            endif 

            if ( iq .eq. 1 ) then
              do 1720 ip = 1, maxnum
                qs(ip) = qvalue
1720          continue
            endif 

          endif 
c--------
c have velocities - let's do it
c--------
          call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                static , TRACEHEADER)
          if ( static .eq. 30000 ) then
            call move (0, tri, 0, nbyts )
            go to 7800
          endif  
          if (iforms .eq. 3 ) then
            call move ( 1, trwrk, tri, nbyts )
          else
            it = 128
            do 4095 iu = 1, nsamps
              it = it + 1
4095          trwrk(iu) = itr(it)
          call move ( 1, tri, trwrk, nbyts)
          endif 
c----
c debug
c----
c         if ( j .eq. 46 .or. j .eq. 47 ) then
c           write(lerr,*)'seismic input'
c           write(lerr,*)'trace no. = ',itr(107)
c           write(lerr,*)(tri(kuzz), kuzz = 1,50)
c         endif 
c----
c debug
c----
         
          if ( mode .eq. 1 .or. mode .eq. 3 ) then

            call saver2(itr,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                  idista , TRACEHEADER)
            call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                  idist  , TRACEHEADER)
            if ( idist .ne. 0 ) then
              itr117 = idista
              offset = float(itr117)
            else
              itr119 = idist
              offset = float(itr119)
            endif 
            ierror = 0
            call gain (ampmck, timesv, vint, vrms, offset, qs,
     :               icomp, iarray, iq, isphd, maxnum, ierror)
            if (ierror .ne. 0) then
              write(lerr,*)' ' 
              write(lerr,*)'ERROR'
              write(lerr,*)'in gain correction '
              write(lerr,*)' ' 
              call lbclos(luin)
              call lbclos(luout)
              if ( mode .eq. 3 ) call lbclos(lumod)
              stop
            endif  
            call vmul(tri(1),1,ampmck(1),1,trwrk(1),1,maxnum)
          endif 

          if ( mode .eq. 2 .or. mode .eq. 3 ) then

            call vmul(trwrk(1),1,tracem(1,j),1,tri(1),1,maxnum)
            go to 7800
          endif 
c-----
c output
c-----
          call move ( 1, itr(ITHWP1),trwrk(1),nbyts)
7800      call wrtape (luout, itr, obytes)
    
8000    continue

9000  continue

      write(lerr,*)'No. Records scaled = ',ic

c-----
c     close data files
c-----
1999  call lbclos ( luin )
      call lbclos ( luout )
      if ( vsis(1:1) .ne. ' ') close(luins)
      if ( tdfnf(1:1) .ne. ' ') close(lusisv)
      stop
      end
