C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine sphere(amp,icomp,vi,vrms,x,t,nsamp,ierr)
      real amp(*),t(*),vi(*),vrms(*),tao(4096)
      real x, parm2
      integer nsamp,i,ierr,icomp
c  amp       == gain factor  ie  gain corr trace(t) = amp(t) * trace(t)
c  icomp     == component ( = omni  = verticle )
c  vi        == intervals velocity - array
c  vrms      == rms velocity - array
c  x         == input x --- source reciever seperation scalar
c  t         == input time of each sample - array
c  nsamp     == number of samples
c  ierr      == error code
c
c


c
c  this subroutine calculates the corrections in the trajectory
c  which gives the corrections in angle and gain.
c
c   call horder(tao,vi,vrms,x,t,nsamp)

c
c   verical component wanted (land data)
c
        if(icomp .eq. 1) then

          do 10 i=1,nsamp

            t0 = t(i)

            if (vrms(i) .ne. 0) then
              tx = sqrt( t0**2 + x**2/vrms(i)**2 )
            else
              tx = t0
            endif

            tao(i) = 1.

            tao1 = tao(i)

            parm = (vi(1)*t0*sqrt(tao1))

            if(parm .ne. 0) then

             amp(i) = (vrms(i)**2*tx**2)/parm

            else

             amp(i) = 1.0

            endif

  10      continue

        endif

c
c   omni-directional case wanted (marine data)
c
        if(icomp .eq. 0) then

          do 120 i=1,nsamp

            t0 = t(i)

            if (vrms(i) .ne. 0) then
              tx = sqrt( t0**2 + x**2/vrms(i)**2 )
            else
              tx = t0
            endif

            tao(i) = 1.

            tao1 = tao(i)

            delta =0.


c           costrm  =  asin( vrms(1)*((2*x/vrms(i)**2)/tx) )

c           amp(i) = costrm * (vrms(i)**2*tx)/(vrms(1)*t0)*sqrt(tao)))

      parm = (vi(1)*t0*sqrt(tao1))

      if(parm .ne. 0) then

         parm2 = (t0**2+(x**2/vrms(i)**4)*(vrms(i)**2-vi(1)**2
     &            *(1+delta)**2))

         if (parm2 .gt. 0.0) then

            amp(i) = (tx*vrms(i)**2)*sqrt( t0**2+(x**2/vrms(i)**4)*
     *               (vrms(i)**2-vi(1)**2*(1+delta)**2) ) / parm
         else
            amp(i) = 1.0
         endif
      else

         amp(i) = 1.0

      endif
  120     continue

          endif


          return
          end
