C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C     PROGRAM MODULE SCANVOL
C
C**********************************************************************C
C
C SCANVOL 
C Useful for univariate statistical analysis of amplitudes on 3D volumes
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

      integer     itr (2*SZLNHD)
      integer     luin, lbytes, nbytes
      integer     len1, len2, len3, len4
      integer     luout, lugt, lugp
      integer     lenth
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     ns, ne, irs, ire, ibin
      integer     ist, iend, isincr, nsampo
      integer     live, llive, indx, lndx, indxpktr, lndxpktr
      integer     i1, i2, i3, i4, i5, i6, i7, i8, i9
      integer     ipk1, ipk2, ipk3, ipk4, ipk5, ipk6, ipk7, ipk8, ipk9
      integer     ntraces, nrecords
      integer     pipout, luout2
      integer     pipe_count, pipchk
      integer     lutty, istty

      real        tri (4*SZSMPM)
      real        distt,distr,dista
      real        distrpt, distapt
      real        pktr
      real        record
      real        dataset, datapktr
      real        xmax, xmin, recmax, recmin, allmax, allmin, binsize
      real        avgsmp, peak, trough, stddev, median
      real        rmean, rpeak, rtrough, rstddev, rmedian, rmode
      real        rvariance, rcoefvar
      real        r1decile, r2decile, r3decile, r4decile, r5decile
      real        r6decile, r7decile, r8decile, r9decile
      real        rpkmean, rpkpeak, rpktrough, rpkstddev, rpkmedian
      real        rpkmode, rpkvariance, rpkcoefvar
      real        rpk1decile, rpk2decile, rpk3decile, rpk4decile
      real        rpk5decile, rpk6decile, rpk7decile, rpk8decile
      real        rpk9decile
      real        dmean, dpeak, dtrough, dstddev, dmedian, dmode
      real        dvariance, dcoefvar
      real        d1decile, d2decile, d3decile, d4decile, d5decile
      real        d6decile, d7decile, d8decile, d9decile
      real        dpkmean, dpkpeak, dpktrough, dpkstddev, dpkmedian
      real        dpkmode, dpkvariance, dpkcoefvar
      real        dpk1decile, dpk2decile, dpk3decile, dpk4decile
      real        dpk5decile, dpk6decile, dpk7decile, dpk8decile
      real        dpk9decile

      pointer     (memadr_distt, distt(2))
      pointer     (memadr_distr, distr(2))
      pointer     (memadr_dista, dista(2))
      pointer     (memadr_distrpt, distrpt(2))
      pointer     (memadr_distapt, distapt(2))
      pointer     (memadr_pktr, pktr(2))
      pointer     (memadr_record, record(2))
      pointer     (memadr_dataset, dataset(2))
      pointer     (memadr_datapktr, datapktr(2))

      character   ntap*256, otap*256, ogt*256, ogp*256
      character   name*7

      logical     verbos
      logical     query
      integer     argis
      integer     stacor

      data  nbytes / 0 /, lbytes / 0 /
      data  luout2 /-1/, pipout/1/
      data  verbos/.true./, name/'SCANVOL'/


c-----
c      read program parameters from command line
c-----
      query = (argis('-?') .gt. 0 .or. argis('-h') .gt. 0 
     :         .or. argis('-help') .gt. 0)
      if(query) then
            call help()
            stop
      endif
c

#include <f77/open.h>

c-----
c      parse command line arguments
c-----
      call gcmdln(ntap, otap, ogt, ogp, irs, ire, irincr,
     :            ns, ne, nincr, ist, iend, isincr, ibin, verbos)
c-----
c      get logical unit numbers for input
c-----
      call getln( luin,ntap,'r',0 )
c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape (luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LER,*)'SCAN: no header read from unit ',luin
         write(LER,*)'FATAL'
         write(LERR,*)'SCANVOL: no header read from unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINEHEADER)
      call saver(itr, 'SmpInt', nsi  , LINEHEADER)
      call saver(itr, 'NumTrc', ntrc , LINEHEADER)
      call saver(itr, 'NumRec', nrec , LINEHEADER)
      call saver(itr, 'Format', iform, LINEHEADER)

c------
c     save certain parameters

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----
c      ensure that command line values are compatible with data set
c      set defaults
c-----
    
      if (ntap .eq. ' ') ntap = 'stdin'

      len1 = lenth(ntap)

      if (otap .eq. ' ') then
          otap(1:len1) = ntap(1:len1)
          otap(len1+1:len1+5) = '_STAT'
      endif

      if (ogt .eq. ' ') then
          ogt(1:len1) = ntap(1:len1)
          ogt(len1+1:len1+5) = '_Txy'
      endif

      if (ogp .eq. ' ') then
          ogp(1:len1) = ntap(1:len1)
          ogp(len1+1:len1+5) = '_Pxy'
      endif
          
      len2 = lenth(otap)
      len3 = lenth(ogt)
      len4 = lenth(ogp)

      call alloclun(luout)
      call alloclun(lugt)
      call alloclun(lugp)

      open (unit=luout, file=otap(1:len2), status='unknown')
      open (unit=lugt,  file=ogt(1:len3),  status='unknown')
      open (unit=lugp,  file=ogp(1:len4),  status='unknown')

      istatus = -1
      pipe_count = pipchk(pipout,istatus)
      if (istatus .eq. 0) luout2 = 1
      if (luout2 .eq. 1) then
          istty = 0
          istty = lutty(luout2)
          if (istty .eq. 1) luout2 = -1
          if (istty .ne. 1) luout2 = LOT
      endif
      
      if (ns .eq. 0) ns = 1
      if (ne .eq. 0) ne = ntrc
      if (nincr .eq. 0) nincr = 1
      ntraces = (ne - ns) / nincr + 1

      if (irs .eq. 0) irs = 1
      if (ire .eq. 0) ire = nrec
      if (irincr .eq. 0) irincr = (ire - irs) / 20
      if (irincr .eq. 0) irincr = 1
      nrecords = (ire - irs) / irincr + 1

      if (iend . gt. 0) then
          iend = nint ( float(iend/nsi) ) + 1
      else
          iend = 0
      endif
      ist = nint ( float (ist/nsi) ) + 1
      if (ist .le. 1) ist = 1

      if (iend .eq. 0) iend = nsamp

      nsampo = float (iend - ist + isincr) / float (isincr)
      nsi = nsi * isincr

      call galloc (memadr_distt, ibin*SZSMPD, ierr1, abort) 
      call galloc (memadr_distr, ibin*SZSMPD, ierr2, abort) 
      call galloc (memadr_dista, ibin*SZSMPD, ierr3, abort) 
      call galloc (memadr_distrpt, ibin*SZSMPD, ierr4, abort) 
      call galloc (memadr_distapt, ibin*SZSMPD, ierr5, abort) 
      call galloc (memadr_pktr, ntraces*2*SZSMPD, ierr6, abort) 
      call galloc (memadr_record, ntraces*nsampo*SZSMPD, ierr7, abort) 
      call galloc (memadr_dataset, nrecords*ntraces*nsampo*SZSMPD, ierr8,
     :             abort)
      call galloc (memadr_datapktr, nrecords*ntraces*2*SZSMPD, ierr9,
     :             abort)
 
      if (ierr1 .ne. 0 .or. ierr2 .ne. 0 .or. ierr3 .ne. 0 .or.
     :    ierr5 .ne. 0 .or. ierr6 .ne. 0 .or. ierr7 .ne. 0 .or.
     :    ierr8 .ne. 0 .or. ierr9 .ne. 0) then
         write (LERR,*) '****************************'
         write (LERR,*) 'Unable to allocate workspace'
         write (LERR,*) ibin*5*SZSMPD,' bytes'
         write (LERR,*) ntraces*2*SZSMPD, ' bytes'
         write (LERR,*) ntraces*nsampo*SZSMPD, ' bytes'
         write (LERR,*) nrecords*ntraces*nsampo*SZSMPD, ' bytes'
         write (LERR,*) nrecords*ntraces*2*SZSMPD, ' bytes'
         write (LERR,*) 'FATAL'
         write (LERR,*) '****************************'
         write (LER,*) '****************************'
         write (LER,*) 'Unable to allocate workspace'
         write (LER,*) ibin*5*SZSMPD,' bytes'
         write (LER,*) ntraces*2*SZSMPD, ' bytes'
         write (LER,*) ntraces*nsampo*SZSMPD, ' bytes'
         write (LERR,*) nrecords*ntraces*nsampo*SZSMPD, ' bytes'
         write (LERR,*) nrecords*ntraces*2*SZSMPD, ' bytes'
         write (LER,*) 'FATAL'
         write (LER,*) '****************************'
         stop
       else
         write (LERR,*) '****************************'
         write (LERR,*) 'Allocating workspace'
         write (LERR,*) ibin*5*SZSMPD,' bytes'
         write (LERR,*) ntraces*2*SZSMPD, ' bytes'
         write (LERR,*) ntraces*nsampo*SZSMPD, ' bytes'
         write (LERR,*) nrecords*ntraces*nsampo*SZSMPD, ' bytes'
         write (LERR,*) nrecords*ntraces*2*SZSMPD, ' bytes'
         write (LERR,*) '****************************'
       endif
         
c-----
c      verbose output of all pertinent information before
c      processing begins
c-----
c-----
c     dump historical line header information
c-----
      call savhlh(itr,lbytes,lbyout)

      if(verbos) then
            call verbal(lbytes,nsamp,nsi,ntrc,nrec,iform,ntap,otap,
     :                  ogt,ogp,ns,ne,nincr,irs,ire,irincr,
     :                  ist,iend,isincr,verbos,luin,ibin)
      endif

c-----
c      BEGIN PROCESSING
c      read trace
c----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)

c-----
c     process desired trace records
c-----

      allmin = +1.e+30
      allmax = -1.e+30
c-------------------
c  initialize
c  dataset hist vector
c
      call vclr (dista,1,ibin)
      call vclr (distapt,1,ibin)
      call vclr (dataset,1,nrecords*ntraces*nsampo)
      call vclr (datapktr,1,nrecords*ntraces*2)

      llive = 0
      lndx = 1
      lndxpktr = 0

c-------------------

      DO  1000 jj = irs, ire, irincr

            recmax = -1.e+30
            recmin = +1.e+30
            live = 0
            large = 0
            little = 0

c-----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c-----------------------

c-------------------
c  initialize
c  rec hist vector
            call vclr (distr,1,ibin)
            call vclr (distrpt,1,ibin)
            call vclr (record,1,ntraces*nsampo)
            call vclr (pktr,1,ntraces*2)
            indx = 1
            indxpktr = 0
c-------------------

            do 1001 kk = ns, ne, nincr
                  nbytes = 0
                  call rtape (luin,itr,nbytes)
                  if(nbytes .eq. 0) go to 999
                  call vmov  (itr(ITHWP1+ist-1), isincr, tri, 1, nsampo)

                  call saver2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,
     :                        irec  , TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     :                        itrc  , TRACEHEADER)
                  call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,
     :                        stacor, TRACEHEADER)



c--------------------------
c  initialize
c  trc hist vector, calc
c  hist for each trace &
c  accumulate hist foreach
c  record
c--------------------------

                  call vclr (distt,1,ibin)

                  if(stacor .ne. 30000) then

                     live = live + 1
                     llive = llive + 1
                     call vmov (tri,1,record(indx),1,nsampo)
                     call vmov (tri,1,dataset(lndx),1,nsampo)
                     indx = indx + nsampo
                     lndx = lndx + nsampo
                     call maxv (tri,1,xmax,indxu,nsampo)
                     call minv (tri,1,xmin,indxl,nsampo)
                     indxpktr = indxpktr + 1
                     lndxpktr = lndxpktr + 1
                     pktr(indxpktr) = xmin
                     datapktr(lndxpktr) = xmin
                     indxpktr = indxpktr + 1
                     lndxpktr = lndxpktr + 1
                     pktr(indxpktr) = xmax
                     datapktr(lndxpktr) = xmax
                     if (xmax .ge. recmax) then
                         recmax = xmax
                         large = itrc
	                 lrgsmp = indxu
                     endif
                     if(xmin .le. recmin) then
                        recmin = xmin
                        little = itrc
	                ltlsmp = indxl
                     endif
                     call hist (tri,1,distr,nsampo,ibin,recmax,recmin)

                     if (recmax .ge. allmax) then
                         allmax = recmax
                         largrec = jj
                         largest = large
                         largestsmp = lrgsmp
                     endif
                     if (recmin .le. allmin) then
                         allmin = recmin
                         smallrec = jj
                         smallest = little
                         smallestsmp = ltlsmp
                     endif
                     call hist (tri,1,dista,nsampo,ibin,allmax,allmin)

                  else
                     xmax = 0.
                     xmin = 0.
                     call vclr (distt,1,ibin)
                  endif

                  if (nincr .gt. 1) then
                      ks = kk
                      ke = kk + nincr - 1
                      if (ke .gt. ne) then ke = ne
                      call trcskp (jj, ks+1, ke, luin, ntrc, itr)
                  endif

 1001       continue

c-----------------------
c skip to end of current
c record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)

            if (irincr .gt. 1) then
                call recskp (jj+1, jj+irincr-1, luin, ntrc, itr)
            endif

c-----------------------

            if (live .ne. 0) then

             call hist (pktr,1,distrpt,indxpktr,ibin,recmax,recmin)

             call hist (pktr,1,distapt,indxpktr,ibin,allmax,allmin)

             call hsort1 (live*2, pktr)
             call hsort1 (live*nsampo, record)

             rmean = avgsmp(record,1,ntraces*nsampo,1,live*nsampo,0.)
             rpeak = peak(record,1,ntraces*nsampo,1,live*nsampo,0.)
             rtrough = trough(record,1,ntraces*nsampo,1,live*nsampo,0.)
             rstddev = stddev(record,1,ntraces*nsampo,1,live*nsampo,0.)
             
             jindx = live*nsampo
             jmid = jindx / 2
             rjmid = float(jindx) / 2.0
 
             if (jmid .eq. rjmid) then 
                 rmedian = (record(jmid) + record(jmid+1)) / 2 
             else
                 rmedian = record(jmid+1)
             endif

c jev        rmedian = median(record,1,ntraces*nsampo,1,live*nsampo)

             call mode(record,1,ntraces*nsampo,1,live*nsampo,rmode,
     :                 modecnt)
             rvariance = rmedian ** 2
             rcoefvar = 0.0
             if (rmean .ne. 0) then
                 rcoefvar = 100 * rstddev / rmean
             endif

             call decile(record,1,ntraces*nsampo,live*nsampo,1,i1,
     :                   r1decile)
             call decile(record,1,ntraces*nsampo,live*nsampo,2,i2,
     :                   r2decile)
             call decile(record,1,ntraces*nsampo,live*nsampo,3,i3,
     :                   r3decile)
             call decile(record,1,ntraces*nsampo,live*nsampo,4,i4,
     :                   r4decile)
             call decile(record,1,ntraces*nsampo,live*nsampo,5,i5,
     :                   r5decile)
             call decile(record,1,ntraces*nsampo,live*nsampo,6,i6,
     :                   r6decile)
             call decile(record,1,ntraces*nsampo,live*nsampo,7,i7,
     :                   r7decile)
             call decile(record,1,ntraces*nsampo,live*nsampo,8,i8,
     :                   r8decile)
             call decile(record,1,ntraces*nsampo,live*nsampo,9,i9,
     :                   r9decile)
            
             rpkmean = avgsmp(pktr,1,ntraces*2,1,live*2,0.)
             rpkpeak = peak(pktr,1,ntraces*2,1,live*2,0.)
             rpktrough = trough(pktr,1,ntraces*2,1,live*2,0.)
             rpkstddev = stddev(pktr,1,ntraces*2,1,live*2,0.)
             
             jindx = live*2
             jmid = jindx / 2
             rjmid = float(jindx) / 2.0

             if (jmid .eq. rjmid) then 
                 rpkmedian = (pktr(jmid) + pktr(jmid+1)) / 2 
             else
                 rpkmedian = pktr(jmid+1)
             endif

c jev        rpkmedian = median(pktr,1,ntraces*2,1,live*2)

             call mode(pktr,1,ntraces*2,1,live*2,rpkmode,modecntpk)
             rpkvariance = rpkmedian ** 2
             rpkcoefvar = 0.0
             if (rpkmean .ne. 0) then
                 rpkcoefvar = 100 * rpkstddev / rpkmean
             endif
 
             call decile (pktr,1,ntraces*2,live*2,1,ipk1,rpk1decile)
             call decile (pktr,1,ntraces*2,live*2,2,ipk2,rpk2decile)
             call decile (pktr,1,ntraces*2,live*2,3,ipk3,rpk3decile)
             call decile (pktr,1,ntraces*2,live*2,4,ipk4,rpk4decile)
             call decile (pktr,1,ntraces*2,live*2,5,ipk5,rpk5decile)
             call decile (pktr,1,ntraces*2,live*2,6,ipk6,rpk6decile)
             call decile (pktr,1,ntraces*2,live*2,7,ipk7,rpk7decile)
             call decile (pktr,1,ntraces*2,live*2,8,ipk8,rpk8decile)
             call decile (pktr,1,ntraces*2,live*2,9,ipk9,rpk9decile)
 
             write (luout,*)
             write (luout,*) ' statistics for record ', jj
             write (luout,*) ' mean = ', rmean
c            write (luout,*) ' peak = ', rpeak
c            write (luout,*) ' trough = ', rtrough
             write (luout,*) ' min = ', recmin
             write (luout,*) ' max = ', recmax
             write (luout,*) ' stddev = ', rstddev
             write (luout,*) ' median = ', rmedian
             write (luout,*) ' variance = ', rvariance
             write (luout,*) ' coefvar = ', rcoefvar
             write (luout,*) ' mode = ', rmode, ' count = ', modecnt
             write (luout,*) ' decile1 = ', r1decile, ' i1 = ', i1
             write (luout,*) ' decile2 = ', r2decile, ' i2 = ', i2
             write (luout,*) ' decile3 = ', r3decile, ' i3 = ', i3
             write (luout,*) ' decile4 = ', r4decile, ' i4 = ', i4
             write (luout,*) ' decile5 = ', r5decile, ' i5 = ', i5
             write (luout,*) ' decile6 = ', r6decile, ' i6 = ', i6
             write (luout,*) ' decile7 = ', r7decile, ' i7 = ', i7
             write (luout,*) ' decile8 = ', r8decile, ' i8 = ', i8
             write (luout,*) ' decile9 = ', r9decile, ' i9 = ', i9

             write (luout,*)
             write (luout,*) ' statistics for peak/trough record ', jj
             write (luout,*) ' mean = ', rpkmean
c            write (luout,*) ' peak = ', rpkpeak
c            write (luout,*) ' trough = ', rpktrough
             write (luout,*) ' min = ', recmin
             write (luout,*) ' max = ', recmax
             write (luout,*) ' stddev = ', rpkstddev
             write (luout,*) ' median = ', rpkmedian
             write (luout,*) ' variance = ', rpkvariance
             write (luout,*) ' coefvar = ', rpkcoefvar
             write (luout,*) ' mode = ', rpkmode, ' count = ', modecntpk
             write (luout,*) ' decile1 = ', rpk1decile, ' i1 = ', ipk1
             write (luout,*) ' decile2 = ', rpk2decile, ' i2 = ', ipk2
             write (luout,*) ' decile3 = ', rpk3decile, ' i3 = ', ipk3
             write (luout,*) ' decile4 = ', rpk4decile, ' i4 = ', ipk4
             write (luout,*) ' decile5 = ', rpk5decile, ' i5 = ', ipk5
             write (luout,*) ' decile6 = ', rpk6decile, ' i6 = ', ipk6
             write (luout,*) ' decile7 = ', rpk7decile, ' i7 = ', ipk7
             write (luout,*) ' decile8 = ', rpk8decile, ' i8 = ', ipk8
             write (luout,*) ' decile9 = ', rpk9decile, ' i9 = ', ipk9
 
             if (luout2 .eq. LOT) then
             write (luout2,*)
             write (luout2,*) ' statistics for record ', jj
             write (luout2,*) ' mean = ', rmean
c            write (luout2,*) ' peak = ', rpeak
c            write (luout2,*) ' trough = ', rtrough
             write (luout2,*) ' min = ', recmin
             write (luout2,*) ' max = ', recmax
             write (luout2,*) ' stddev = ', rstddev
             write (luout2,*) ' median = ', rmedian
             write (luout2,*) ' variance = ', rvariance
             write (luout2,*) ' coefvar = ', rcoefvar
             write (luout2,*) ' mode = ', rmode, ' count = ', modecnt
             write (luout2,*) ' decile1 = ', r1decile, ' i1 = ', i1
             write (luout2,*) ' decile2 = ', r2decile, ' i2 = ', i2
             write (luout2,*) ' decile3 = ', r3decile, ' i3 = ', i3
             write (luout2,*) ' decile4 = ', r4decile, ' i4 = ', i4
             write (luout2,*) ' decile5 = ', r5decile, ' i5 = ', i5
             write (luout2,*) ' decile6 = ', r6decile, ' i6 = ', i6
             write (luout2,*) ' decile7 = ', r7decile, ' i7 = ', i7
             write (luout2,*) ' decile8 = ', r8decile, ' i8 = ', i8
             write (luout2,*) ' decile9 = ', r9decile, ' i9 = ', i9

             write (luout2,*)
             write (luout2,*) ' statistics for peak/trough record ', jj
             write (luout2,*) ' mean = ', rpkmean
c            write (luout2,*) ' peak = ', rpkpeak
c            write (luout2,*) ' trough = ', rpktrough
             write (luout2,*) ' min = ', recmin
             write (luout2,*) ' max = ', recmax
             write (luout2,*) ' stddev = ', rpkstddev
             write (luout2,*) ' median = ', rpkmedian
             write (luout2,*) ' variance = ', rpkvariance
             write (luout2,*) ' coefvar = ', rpkcoefvar
             write (luout2,*) ' mode = ', rpkmode, ' count = ', modecntpk
             write (luout2,*) ' decile1 = ', rpk1decile, ' i1 = ', ipk1
             write (luout2,*) ' decile2 = ', rpk2decile, ' i2 = ', ipk2
             write (luout2,*) ' decile3 = ', rpk3decile, ' i3 = ', ipk3
             write (luout2,*) ' decile4 = ', rpk4decile, ' i4 = ', ipk4
             write (luout2,*) ' decile5 = ', rpk5decile, ' i5 = ', ipk5
             write (luout2,*) ' decile6 = ', rpk6decile, ' i6 = ', ipk6
             write (luout2,*) ' decile7 = ', rpk7decile, ' i7 = ', ipk7
             write (luout2,*) ' decile8 = ', rpk8decile, ' i8 = ', ipk8
             write (luout2,*) ' decile9 = ', rpk9decile, ' i9 = ', ipk9
             endif
 
             binsize = (recmax - recmin) / ibin

            write (LERR,*)
            write (LERR,*) 'Record peaktrough histogram'   
            write (LERR,*) ' record = ', jj
            write (LERR,*) ' minimum = ', recmin
            write (LERR,*) ' maximum = ', recmax

             write (lugp,*)
             write (lugp,*) '  "Record ', jj
             do i = 1, ibin
                write (lugp,*) recmin+(i-1)*binsize, distrpt(i)
             enddo

            write (LERR,*)
            write (LERR,*) 'Record histogram'   
            write (LERR,*) ' record = ', jj
            write (LERR,*) ' minimum = ', recmin
            write (LERR,*) ' trace = ', little, ' sample = ', ltlsmp
            write (LERR,*) ' maximum = ', recmax
            write (LERR,*) ' trace = ', large, ' sample = ', lrgsmp

             write (lugt,*)
             write (lugt,*) '  "Record', jj
             do i = 1, ibin
                write (lugt,*) recmin+(i-1)*binsize, distr(i)
             enddo
  850        format(2i10)           
 
            else 

             write (LERR,*) ' Record ', jj, ' no live traces'
             write (LERR,*) ' No statistics or histograms calculated'
             recmax = 0.
             recmin = 0.
             call vfill (0.0, distr, 1, ibin)

            endif

 1000 CONTINUE

            if (llive .ne. 0) then

             call hsort1 (llive*2, datapktr)
             call hsort1 (llive*nsampo, dataset)

             dmean = avgsmp(dataset,1,nrecords*ntraces*nsampo,1,
     :                      llive*nsampo,0.)
             dpeak = peak(dataset,1,nrecords*ntraces*nsampo,1,
     :                    llive*nsampo,0.)
             dtrough = trough(dataset,1,nrecords*ntraces*nsampo,1,
     :                       llive*nsampo,0.)
             dstddev = stddev(dataset,1,nrecords*ntraces*nsampo,1,
     :                        llive*nsampo,0.)
             
             jindx = llive*nsampo
             jmid = jindx / 2
             rjmid = float(jindx) / 2.0

             if (jmid .eq. rjmid) then 
                 dmedian = (dataset(jmid) + dataset(jmid+1)) / 2 
             else
                 dmedian = dataset(jmid+1)
             endif

c jev        dmedian = median(dataset,1,nrecords*ntraces*nsampo,1,
c jev:                        llive*nsampo)
 
             call mode(dataset,1,nrecords*ntraces*nsampo,1,
     :                 llive*nsampo,dmode,modecnt)
             dvariance = dmedian ** 2
             dcoefvar = 0.0
             if (dmean .ne. 0) then
                 dcoefvar = 100 * dstddev / dmean
             endif

             call decile(dataset,1,nrecords*ntraces*nsampo,llive*nsampo,
     :                   1,i1,d1decile)
             call decile(dataset,1,nrecords*ntraces*nsampo,llive*nsampo,
     :                   2,i2,d2decile)
             call decile(dataset,1,nrecords*ntraces*nsampo,llive*nsampo,
     :                   3,i3,d3decile)
             call decile(dataset,1,nrecords*ntraces*nsampo,llive*nsampo,
     :                   4,i4,d4decile)
             call decile(dataset,1,nrecords*ntraces*nsampo,llive*nsampo,
     :                   5,i5,d5decile)
             call decile(dataset,1,nrecords*ntraces*nsampo,llive*nsampo,
     :                   6,i6,d6decile)
             call decile(dataset,1,nrecords*ntraces*nsampo,llive*nsampo,
     :                   7,i7,d7decile)
             call decile(dataset,1,nrecords*ntraces*nsampo,llive*nsampo,
     :                   8,i8,d8decile)
             call decile(dataset,1,nrecords*ntraces*nsampo,llive*nsampo,
     :                   9,i9,d9decile)
            
             dpkmean = avgsmp(datapktr,1,nrecords*ntraces*2,1,
     :                        llive*2,0.)
             dpkpeak = peak(datapktr,1,nrecords*ntraces*2,1,llive*2,0.)
             dpktrough = trough(datapktr,1,nrecords*ntraces*2,1,
     :                          llive*2,0.)
             dpkstddev = stddev(datapktr,1,nrecords*ntraces*2,1,
     :                          llive*2,0.)
             
             jindx = llive*2
             jmid = jindx / 2
             rjmid = float(jindx) / 2.0

             if (jmid .eq. rjmid) then 
                 dpkmedian = (datapktr(jmid) + datapktr(jmid+1)) / 2 
             else
                 dpkmedian = datapktr(jmid+1)
             endif

c jev        dpkmedian = median(datapktr,1,nrecords*ntraces*2,1,llive*2)

             call mode(datapktr,1,nrecords*ntraces*2,1,llive*2,dpkmode,
     :                 modecntpk)
             dpkvariance = dpkmedian ** 2
             dpkcoefvar = 0.0
             if (dpkmean .ne. 0) then
                 dpkcoefvar = 100 * dpkstddev / dpkmean
             endif
 
             call decile (datapktr,1,nrecords*ntraces*2,llive*2,1,ipk1,dpk1decile)
     :                    dpk1decile)
             call decile (datapktr,1,nrecords*ntraces*2,llive*2,2,ipk2,
     :                    dpk2decile)
             call decile (datapktr,1,nrecords*ntraces*2,llive*2,3,ipk3,
     :                    dpk3decile)
             call decile (datapktr,1,nrecords*ntraces*2,llive*2,4,ipk4,
     :                    dpk4decile)
             call decile (datapktr,1,nrecords*ntraces*2,llive*2,5,ipk5,
     :                    dpk5decile)
             call decile (datapktr,1,nrecords*ntraces*2,llive*2,6,ipk6,
     :                    dpk6decile)
             call decile (datapktr,1,nrecords*ntraces*2,llive*2,7,ipk7,
     :                    dpk7decile)
             call decile (datapktr,1,nrecords*ntraces*2,llive*2,8,ipk8,
     :                    dpk8decile)
             call decile (datapktr,1,nrecords*ntraces*2,llive*2,9,ipk9,
     :                    dpk9decile)
 
             write (luout,*)
             write (luout,*) ' statistics for dataset '
             write (luout,*) ' mean = ', dmean
c            write (luout,*) ' peak = ', dpeak
c            write (luout,*) ' trough = ', dtrough
             write (luout,*) ' min = ', allmin
             write (luout,*) ' max = ', allmax
             write (luout,*) ' stddev = ', dstddev
             write (luout,*) ' median = ', dmedian
             write (luout,*) ' variance = ', dvariance
             write (luout,*) ' coefvar = ', dcoefvar
             write (luout,*) ' mode = ', dmode, ' count = ', modecnt
             write (luout,*) ' decile1 = ', d1decile, ' i1 = ', i1
             write (luout,*) ' decile2 = ', d2decile, ' i2 = ', i2
             write (luout,*) ' decile3 = ', d3decile, ' i3 = ', i3
             write (luout,*) ' decile4 = ', d4decile, ' i4 = ', i4
             write (luout,*) ' decile5 = ', d5decile, ' i5 = ', i5
             write (luout,*) ' decile6 = ', d6decile, ' i6 = ', i6
             write (luout,*) ' decile7 = ', d7decile, ' i7 = ', i7
             write (luout,*) ' decile8 = ', d8decile, ' i8 = ', i8
             write (luout,*) ' decile9 = ', d9decile, ' i9 = ', i9

             write (luout,*)
             write (luout,*) ' statistics for peak/trough dataset '
             write (luout,*) ' mean = ', dpkmean
c            write (luout,*) ' peak = ', dpkpeak
c            write (luout,*) ' trough = ', dpktrough
             write (luout,*) ' min = ', allmin
             write (luout,*) ' max = ', allmax
             write (luout,*) ' stddev = ', dpkstddev
             write (luout,*) ' median = ', dpkmedian
             write (luout,*) ' variance = ', dpkvariance
             write (luout,*) ' coefvar = ', dpkcoefvar
             write (luout,*) ' mode = ', dpkmode, ' count = ', modecntpk
             write (luout,*) ' decile1 = ', dpk1decile, ' i1 = ', ipk1
             write (luout,*) ' decile2 = ', dpk2decile, ' i2 = ', ipk2
             write (luout,*) ' decile3 = ', dpk3decile, ' i3 = ', ipk3
             write (luout,*) ' decile4 = ', dpk4decile, ' i4 = ', ipk4
             write (luout,*) ' decile5 = ', dpk5decile, ' i5 = ', ipk5
             write (luout,*) ' decile6 = ', dpk6decile, ' i6 = ', ipk6
             write (luout,*) ' decile7 = ', dpk7decile, ' i7 = ', ipk7
             write (luout,*) ' decile8 = ', dpk8decile, ' i8 = ', ipk8
             write (luout,*) ' decile9 = ', dpk9decile, ' i9 = ', ipk9
 
             if (luout2 .eq. LOT) then
             write (luout2,*)
             write (luout2,*) ' statistics for dataset '
             write (luout2,*) ' mean = ', dmean
c            write (luout2,*) ' peak = ', dpeak
c            write (luout2,*) ' trough = ', dtrough
             write (luout2,*) ' min = ', allmin
             write (luout2,*) ' max = ', allmax
             write (luout2,*) ' stddev = ', dstddev
             write (luout2,*) ' median = ', dmedian
             write (luout2,*) ' variance = ', dvariance
             write (luout2,*) ' coefvar = ', dcoefvar
             write (luout2,*) ' mode = ', dmode, ' count = ', modecnt
             write (luout2,*) ' decile1 = ', d1decile, ' i1 = ', i1
             write (luout2,*) ' decile2 = ', d2decile, ' i2 = ', i2
             write (luout2,*) ' decile3 = ', d3decile, ' i3 = ', i3
             write (luout2,*) ' decile4 = ', d4decile, ' i4 = ', i4
             write (luout2,*) ' decile5 = ', d5decile, ' i5 = ', i5
             write (luout2,*) ' decile6 = ', d6decile, ' i6 = ', i6
             write (luout2,*) ' decile7 = ', d7decile, ' i7 = ', i7
             write (luout2,*) ' decile8 = ', d8decile, ' i8 = ', i8
             write (luout2,*) ' decile9 = ', d9decile, ' i9 = ', i9

             write (luout2,*)
             write (luout2,*) ' statistics for peak/trough dataset '
             write (luout2,*) ' mean = ', dpkmean
c            write (luout2,*) ' peak = ', dpkpeak
c            write (luout2,*) ' trough = ', dpktrough
             write (luout2,*) ' min = ', allmin
             write (luout2,*) ' max = ', allmax
             write (luout2,*) ' stddev = ', dpkstddev
             write (luout2,*) ' median = ', dpkmedian
             write (luout2,*) ' variance = ', dpkvariance
             write (luout2,*) ' coefvar = ', dpkcoefvar
             write (luout2,*) ' mode = ', dpkmode, ' count = ', modecntpk
             write (luout2,*) ' decile1 = ', dpk1decile, ' i1 = ', ipk1
             write (luout2,*) ' decile2 = ', dpk2decile, ' i2 = ', ipk2
             write (luout2,*) ' decile3 = ', dpk3decile, ' i3 = ', ipk3
             write (luout2,*) ' decile4 = ', dpk4decile, ' i4 = ', ipk4
             write (luout2,*) ' decile5 = ', dpk5decile, ' i5 = ', ipk5
             write (luout2,*) ' decile6 = ', dpk6decile, ' i6 = ', ipk6
             write (luout2,*) ' decile7 = ', dpk7decile, ' i7 = ', ipk7
             write (luout2,*) ' decile8 = ', dpk8decile, ' i8 = ', ipk8
             write (luout2,*) ' decile9 = ', dpk9decile, ' i9 = ', ipk9
             endif
 
             binsize = (allmax - allmin) / ibin

            write (LERR,*)
            write (LERR,*) 'Dataset histogram'   
            write (LERR,*) ' record = ', smallrec
            write (LERR,*) ' minimum = ', allmin
            write (LERR,*) ' trace = ', smallest
            write (LERR,*) ' sample = ', smallestsmp
            write (LERR,*) ' record = ', largrec
            write (LERR,*) ' maximum = ', allmax
            write (LERR,*) ' trace = ', largest
            write (LERR,*) ' sample = ', largestsmp

             write (lugt,*)
             write (lugt,*) '  "Dataset'
             do i = 1, ibin
                write (lugt,*) allmin+(i-1)*binsize, dista(i)
             enddo

            write (LERR,*)
            write (LERR,*) 'Dataset peaktrough histogram'   
            write (LERR,*) ' minimum = ', allmin
            write (LERR,*) ' maximum = ', allmax

             write (lugp,*)
             write (lugp,*) '  "Dataset '
             do i = 1, ibin
                write (lugp,*) allmin+(i-1)*binsize, distapt(i)
             enddo

            endif

  999 continue

      

      close(luout)
      close(lugt)
      close(lugp)
      call lbclos(luin)

      stop 0
      end


      subroutine help
#include <f77/iounit.h>
      write(LER,*)
     :'***************************************************************'
      write(LER,*)' '
      write(LER,*)
     :'Execute scanvol by typing scanvol with the following arguments'
      write(LER,*)
     :' -N [ntap]    (stdin) : Input data file name'
      write(LER,*) 
     :' -O [otap]    (ntap_STAT) : Statistical report of all analyses'
      write(LER,*)
     :' -GT [ogt]    (ntap_Txy) : Frequency histogram of all samples'
      write(LER,*)
     :' -GP [ogp]    (ntap_Pxy) : Frequency histogram of peaks/troughs'
      write(LER,*)
     :' -ns [ns]      (default=first) : start trace # (sequential)'
      write(LER,*)
     :' -ne [ne]      (default=last)  : end trace # (sequential)'
      write(LER,*)
     :' -T0 [nincr)   (default=1) : trace increment'
      write(LER,*)
     :' -rs [irs]      (default=first) : start record # (sequential)'
      write(LER,*)
     :' -re [ire]      (default=last)  : end record # (sequential)'
      write(LER,*)
     :' -R0 [irincr]   (default=(re-rs)/20) : record increment'
      write(LER,*)
     :' -s [ist]       (default=0 ms) : start time'
      write(LER,*)
     :' -e [iend]      (default=last samp)  : end time'
      write(LER,*)
     :' -S0 [isincr]   (default=1) : sample increment'
      write(LER,*)
     :' -b [ibin]    (default=255)    : number bins for histogram' 
      write(LER,*)
     :' -V           : verbose output'
      write(LER,*)' '
      write(LER,*)
     :'Usage:      scanvol -N[ntap] -O[otap] -GT[ogt] -GP[ogp]',
     :'                    -ns[ns] -ne[ne] -T0[nincr]',
     :'                    -rs[irs] -re[ire] -R0[irincr]',
     :'                    -s[ist] -e[iend] -S0[isincr]',
     :'                    -b[ibin] -V'
      write(LER,*)
     :'***************************************************************'
      return
      end

      subroutine gcmdln(ntap, otap, ogt, ogp, irs, ire, irincr,
     :                  ns, ne, nincr, ist, iend, isincr, ibin, verbos)

#include <f77/iounit.h>
      integer   ns, ne, irs, ire, irincr, nincr
      integer   ist, iend, isincr
      character ntap*(*), otap*(*), ogt*(*), ogp*(*)
      integer   argis, ibin
      logical   verbos

            call argstr('-N', ntap, ' ', ' ' )
            call argstr('-O', otap, ' ', ' ' )
            call argstr('-GT', ogt, ' ', ' ' )
            call argstr('-GP', ogp, ' ', ' ' )

            call argi4 ('-ns', ns, 1, 1)
            call argi4 ('-ne', ne, 0, 0)
            call argi4 ('-T0', nincr, 1, 1)
            call argi4 ('-rs', irs, 1, 1)
            call argi4 ('-re', ire, 0, 0)
            call argi4('-R0', irincr, 0, 0)
            call argi4 ('-s', ist, 0, 0)
            call argi4 ('-e', iend, 0, 0)
            call argi4('-S0', isincr, 1, 1)
            call argi4('-b', ibin, 255, 255)
            
            verbos = (argis( '-V' ) .gt. 0)

      return
      end

      subroutine verbal(lbytes,nsamp,nsi,ntrc,nrec,iform,ntap,otap,
     1 ogt,ogp,ns,ne,nincr,irs,ire,irincr,ist,iend,isincr,verbos,
     2 luin,ibin)

c-----
c     verbose output of processing parameters
c
c     lbytes- I*4 number of bytes in line header
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*120     input file name
c     ns    - I*4 starting trace
c     ne    - I*4 ending trace in each record
c     nincr - I*4 trace increment
c     irs    - I*4 starting record
c     ire    - I*4 ending record
c     irincr - I*4 record increment
c     ist    - I*4 starting sample
c     iend   - I*4 ending sample
c     isincr - I*4 sample increment
c     ibin  - I*4 no. histogram bins
c     verbos- L   verbose information
c-----
#include <f77/iounit.h>

      integer   lbytes, nsamp, nsi, ntrc, nrec, iform
      character ntap*(*),otap*(*),ogt*(*),ogp*(*)
      integer   ns, ne, irs, ire, ibin
      logical   verbos
      integer   lenth

            ln = lenth(ntap)
            lno = lenth(otap)
            lnt = lenth(ogt)
            lnp = lenth(ogp)
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of bytes in line header=',lbytes
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) 
            write(LERR,*) ' input data set name =  ', ntap(1:ln)
            write(LERR,*) ' statistical report = ', otap(1:lno)
            write(LERR,*) ' histogram of all samples = ', ogt(1:lnt)
            write(LERR,*) ' histogram of peaks/troughs = ', ogp(1:lnp)
            write(LERR,*) ' ns (starting trace)    =  ',ns
            write(LERR,*) ' ne (ending trace  )    =  ',ne
            write(LERR,*) ' T0 (trace increment )  =  ',nincr
            write(LERR,*) ' rs (starting record)   =  ',irs
            write(LERR,*) ' re (ending record)     =  ',ire
            write(LERR,*) ' irincr (record increment ) = ', irincr
            write(LERR,*) ' ist (starting sample)   =  ',ist
            write(LERR,*) ' iend (ending sample)     =  ',iend
            write(LERR,*) ' isincr (sample increment ) = ', isincr
            write(LERR,*) ' Number ampl. histogrm bins= ',ibin
            write(LERR,*) ' NOTE: a bin = (trcmax-trcmin)/ibin'
            write(LERR,*) ' verbose output         =  ',verbos
            write(LERR,*)' '
      return
      end
