C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE EDITPK ( NUMCHG, I, R, C, M, ARRAY, NBLK, LBLK,
     *                    NTRBLK, NITEMS )
C***********************************************************************
C
C     SUBROUTINE NAME: EDITPK
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: UNKNOWN
C
C     DATE WRITTEN: UNKNOWN
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                          - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: SUBROUTINE EDITPK EDITS PICKS BY COMPUTING THE
C               ERROR ASSOCIATED WITH A SET OF PICKS AND
C               SUBSTITUTING FOR THESE PICKS TO COME UP WITH
C               THE ERROR AS SMALL AS POSSIBLE.  THE SUBSTITUTIONS
C               COME FROM THE EVENT TAPE.
C
C     MODIFICATION HISTORY: ??/??/??  -  ?.?.
C
C     PARAMETERS PASSED:
C        NUMCHG - NUMBER OF PICKS THAT ARE CHANGED
C        I      - INITIATION CORRECTIONS
C        R      - RECEPTION CORRECTIONS
C        C      - STRUCTURE CORRECTIONS
C        M      - MOVEOUT CORRECTIONS
C        ARRAY  - BUFFER FOR READING DISK INFO
C        NBLK   - DISKIO BLOCK COUNTER
C        LBLK   - TOTAL NUMBER OF BLOCKS DISKIO NEEDS
C        NTRBLK - NUMBER OF TRACES PER BLOCK
C        NITEMS - NUMBER OF SAMPLES PER DISK "TRACE"
C
C***********************************************************************

#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C
      REAL        I(12001), R(12001), C(30001), M(30001), ARRAY(8190)
C
      INTEGER     DI, GI, TPRI
C
      DATA DEAD /-10000./
C
      SAVE ! CRAY
C
      NUMCHG = 0
C
C---- READ THROUGH ALL TRACES...
      DO 300 IPNT1 = 1,NBLK
         N = NTRBLK
         IF ( IPNT1 .EQ. NBLK ) N = LBLK
         CALL ELREAD ( IPNT1, ARRAY )
C
         DO 200 IPNT2 = 1,N
            INDEX = ( IPNT2 - 1 ) * NITEMS + 1
C
C---- GET NECESSARY INDICES...
            IF ( ARRAY(INDEX) .EQ. DEAD ) GO TO 200
            DI   = ARRAY( INDEX + 6 )
            GI   = ARRAY( INDEX + 7 )
            TPRI = ARRAY( INDEX + 8 )
C
C---- COMPUTE TOTAL CORRECTION...
            FACT = I(TPRI) + R(GI) + C(DI) + M(DI) * ARRAY( INDEX + 9 )
C
C---- COMPUTE INITIAL ERROR WITH BEST PICK....
            ERROR1 = ARRAY(INDEX) - FACT
C
C---- WAS THERE AN ALTERNATE PICK ???
            IF ( ARRAY( INDEX + 2 ) .EQ. DEAD ) GO TO 100
C
C---- USE IT TO FIGURE ERROR...
            ERROR2 = ARRAY( INDEX + 2 ) - FACT
C
C---- WAS ERROR FOR ALTERNATE PICK LESS ???
            IF ( ABS( ERROR1 ) .LE. ABS( ERROR2 ) ) GO TO 100
C
C---- LET'S SUBSTITUTE SOME PICKS...
            TEMP   = ERROR1
            ERROR1 = ERROR2
            ERROR2 = TEMP
            TEMP   = ARRAY(INDEX )
C
            ARRAY( INDEX )     = ARRAY( INDEX + 2 )
            ARRAY( INDEX + 2 ) = TEMP
            TEMP               = ARRAY( INDEX + 1 )
            ARRAY( INDEX + 1 ) = ARRAY( INDEX + 3 )
            ARRAY( INDEX + 3 ) = TEMP
C
C---- KEEP TRACK OF HOW MANY
C---- WE'VE CHANGED...
            NUMCHG = NUMCHG + 1
C
C---- CHECK OTHER ALTERNATE PICK...
  100       IF ( ARRAY( INDEX + 4 ) .EQ. DEAD ) GO TO 200
            ERROR3 = ARRAY( INDEX + 4 ) - FACT
C
C---- IS IT A BETTER PICK THAN PRIMARY...
            IF ( ABS( ERROR1 ) .LE. ABS( ERROR3 ) ) GO TO 200
C
C---- SUBSTITUTE AWAY...
            TEMP   = ERROR1
            ERROR1 = ERROR3
            ERROR3 = TEMP
            TEMP   = ARRAY(INDEX)
C
            ARRAY( INDEX )     = ARRAY(INDEX+4)
            ARRAY( INDEX + 4 ) = TEMP
            TEMP               = ARRAY(INDEX+1)
            ARRAY( INDEX + 1 ) = ARRAY(INDEX+5)
            ARRAY( INDEX + 5 ) = TEMP
C
C---- KEEP TRACK OF HOW MANY...
            NUMCHG = NUMCHG + 1
  200    CONTINUE
C
C---- WRITE INFO BACK OUT...
         CALL ELWRTE ( IPNT1, ARRAY )
  300 CONTINUE
C
C---- BOOGIE WOOGIE....
      RETURN
      END
