C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE EVPIKR ( FREC, LREC, REC1, REC2, BASESQ, CFOLD, IBUF,
     *                    WEIGHT, CDPMN, IGRP, ARRAY, NBLK, LBLK,
     * NTRBLK, NITEMS, GIDIM, DIDIM, ITRWRD, SZSMPD, SZLNHD, nwds,iunit,
     * ifmt_TrcNum,l_TrcNum, ln_TrcNum,ifmt_RecNum,l_RecNum, ln_RecNum,
     * ifmt_DphInd,l_DphInd, ln_DphInd,ifmt_RecInd,l_RecInd, ln_RecInd,
     * ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,ifmt_StaCor,l_StaCor, ln_StaCor,
     * ifmt_DstSgn,l_DstSgn, ln_DstSgn,ifmt_LinInd,l_LinInd, ln_LinInd,
     * verbos)
C***********************************************************************
C
C     SUBROUTINE NAME: EVPIKR
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: UNKNOWN
C
C     DATE WRITTEN: UNKNOWN
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                          - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: SUBROUTINE EVPIKR READS AN EVENT TAPE CREATED BY
C               PROGRAM PICK, REMOVES THE MEAN FROM THE TIMES WITHIN
C               EACH CDP, AND WRITES INFORMATION TO DISK FOR
C               SUBSEQUENT USE IN STATICS CALCULATIONS.
C
C     MODIFICATION HISTORY: ??/??/??  -  ?.?.
C                           02/01/83  -  G.SHIBA
C                           IMPLEMENT TWO-DIMENSIONAL CDP NUMBERING
C                           SCHEME.
C
C     PARAMETERS PASSED:
C        FREC   - FIRST RECORD TO PROCESS FROM 1SCOR CARD
C        LREC   - LAST RECORD TO PROCESS FROM 1SCOR CARD
C        REC1   - FIRST RECORD ON EVENT TAPE
C        REC2   - LAST RECORD ON EVENT TAPE
C        BASESQ - BASE DISTANCE SQUARED FOR NMO CALCULATIONS
C        CFOLD  - FOLD FROM 1SCOR CARD
C        IBUF   - EVENT TRACE BUFFER
C        WEIGHT - WEIGHTING FLAG FROM 1SCOR CARD
C        CDPMN  - AVERAGE DIFFERENTIALS FOR CDP'S
C        IGRP   - 3D PROCESSING FLAG
C        ARRAY  - BUFFER FOR READING DISK INFO
C        NBLK   - DISKIO BLOCK COUNTER
C        LBLK   - TOTAL NUMBER OF BLOCKS DISKIO NEEDS
C        NTRBLK - NUMBER OF TRACES PER BLOCK
C        NITEMS - NUMBER OF SAMPLES PER DISK "TRACE"
C        GIDIM  - GROUP INDEX LIMIT
C        DIDIM  - DEPTH INDEX LIMIT
C
C***********************************************************************

c#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>

C
      REAL        ARRAY(8190), CDPMN(30001)
C
      INTEGER     GIDIM, DIDIM, DI, GI, TPRI, TOTPIK, CFOLD, BLKCNT,
     *            FREC, REC1, REC2, WEIGHT,ITRWRD, SZSMPD, SZLNHD,
     *            nwds, iunit
C
      INTEGER     IBUF(8192)
      logical     verbos
C
      COMMON /LUNITS/ INEVNT, INPUT, OUTPUT, IPRNTR
C
      DATA MFLAG/0/, BSTSUM/0./, DI/1/, TOTPIK/0/, LIVPIK/0/,
     *     BLKCNT/0/, INDEX/1/, IDEAD/-10000/
C
      SAVE ! Cray

      ITHWP1 = ITRWRD + 1
      unit = iunit
C
C---- CLEAR THE CDP MEAN BUFFER
      CALL MOVE ( 0, CDPMN, 0, DIDIM * SZSMPD ) ! Cray
      NBLK = 0
C
C---- READ AN EVENT TRACE...
      LENGTH = 0
      CALL RTAPE ( INEVNT, IBUF,      LENGTH ) ! Cray
      IF ( LENGTH .NE. 0 ) GO TO 200
C
      WRITE (IPRNTR,100)
  100 FORMAT(/,12X, ' ** M7204 ** ERROR DETECTED BY SUBROUTINE EVPIKR:',
     *       /,25X, 'END-OF-FILE ENCOUNTERED ON THE EVENT TAPE BEFORE',
     *       /,25X, 'ANY TRACES WERE READ.  VERIFY THE DATA SET NAME',
     *       /,25X, 'AND CHECK FOR ERRORS IN PREVIOUS PROCESSING ',
     *              'STEPS.',/)
      GO TO 2900
C
C---- DETERMINE IF 56 OR 256
C---- BYTE TRACE HEADERS AND SET BIASES...
  200 IREAD = 1

      write(LERR,*)'length= ',LENGTH
 
C---- TRAP FIRST RECORD NUMBER....
  500 continue
              call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    REC1 , 1)
 
C---- READ ANOTHER TRACE...
  600 LENGTH = 0
      CALL RTAPE ( INEVNT, IBUF,        LENGTH ) ! Cray

      IF ( LENGTH .EQ. 0 ) GO TO 800
C
C---- ARE WE WITHIN USER
C---- SPECIFIED LIMITS ???
  700 CONTINUE
              call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    irect, 1)
      IF ( irect .LT. FREC ) GO TO 600
      IF ( irect .LE. LREC ) GO TO 900
C
C---- END OF FILE HIT...
  800 MFLAG = 1
      IF ( TOTPIK .EQ. 0 ) GO TO 2300
      CFOLD = TOTPIK
      GO TO 1800
C
C-----------------------------------------------------------------------
C---- BUFFER LOCATIONS ( INDEX + "N" ) DESCRIPTIONS OF "N" BELOW....
C     N                             N
C   ----                           ----
C     0 = BEST PICK                  1 = WEIGHT FOR BEST PICK
C     2 = POSITIVE ALTERNATE         3 = WEIGHT FOR POSITIVE ALTERNATE
C     4 = NEGATIVE ALTERNATE         5 = WEIGHT FOR NEGATIVE ALTERNATE
C     6 = DEPTH INDEX                7 = GROUP INDEX
C     8 = SOURCE INDEX(DI-GI OR PRI) 9 = DISTANCE * * 2 / BASE * * 2
C    10 = PERMANENT RECORD INDEX    11 = LINE INDEX ( 3-D )
C    12 = DEPTH INDEX ( 3-D )
C-----------------------------------------------------------------------
C
C---- INITIATE ACCUMULATORS...
C---- TOTPIK IS TOTAL NUMBER OF PICKS IN A CDP...
C---- LIVPIK IS TOTAL NUMBER OF LIVE PICKS IN A CDP...
C---- BLKCNT IS COUNTER TO SEE IF WE'VE GONE
C---- THROUGH A BLOCK OF DATA YET....
C
  900 TOTPIK = TOTPIK + 1
      LIVPIK = LIVPIK + 1
      BLKCNT = BLKCNT + 1
C
C---- START STUFFING PICK INFORMATION..
C---- NOTE:  WEIGHTS ARE STORED FROM
C---- PICK MULTIPLIED BY 10000......
c PRIMARY PICK
c PRIMARY WEIGHT
c POS ALT PICK
c POS ALT WEIGHT
c NEG ALT PICK
c NEG ALT WEIGHT
      i = ITRWRD
c     ARRAY( INDEX + 0 ) = IBUF(129)
c     ARRAY( INDEX + 1 ) = IBUF(130) * .0001e0
c     ARRAY( INDEX + 2 ) = IBUF(131)
c     ARRAY( INDEX + 3 ) = IBUF(132) * .0001e0
c     ARRAY( INDEX + 4 ) = IBUF(133)
c     ARRAY( INDEX + 5 ) = IBUF(134) * .0001e0

      call vmov (IBUF(ITHWP1  ), 1, tm0, 1, 1)
      call vmov (IBUF(ITHWP1+1), 1, wt0, 1, 1)
      call vmov (IBUF(ITHWP1+2), 1, tm1, 1, 1)
      call vmov (IBUF(ITHWP1+3), 1, wt1, 1, 1)
      call vmov (IBUF(ITHWP1+4), 1, tm2, 1, 1)
      call vmov (IBUF(ITHWP1+5), 1, wt2, 1, 1)
      iflag = tm0

      if (iflag .ne. IDEAD) then
         tm0 = tm0 / unit
         iflag = tm0
         wt0 = wt0 * .0001
         tm1 = tm1 / unit
         wt1 = wt1 * .0001
         tm2 = tm2 / unit
         wt2 = wt2 * .0001
      endif

      ARRAY(INDEX+0) = tm0
      ARRAY(INDEX+1) = wt0
      ARRAY(INDEX+2) = tm1
      ARRAY(INDEX+3) = wt1
      ARRAY(INDEX+4) = tm2
      ARRAY(INDEX+5) = wt2

c     ARRAY( INDEX + 0 ) = IBUF(i+1)
c     ARRAY( INDEX + 1 ) = IBUF(i+2) * .0001e0
c     ARRAY( INDEX + 2 ) = IBUF(i+3)
c     ARRAY( INDEX + 3 ) = IBUF(i+4) * .0001e0
c     ARRAY( INDEX + 4 ) = IBUF(i+5)
c     ARRAY( INDEX + 5 ) = IBUF(i+6) * .0001e0

C
C---- START STUFFING PERTINENT INFORMATION....
c     write(iprntr,*)'Rec= ',ibuf(106),' trc= ',ibuf(107),'di=',
c    *	ibuf(122),'gi=',ibuf(118),'pri=',ibuf(110)
C    1' DI= ',di,ibuf(122),'  GI= ',gi,ibuf(118)
      GI                    = IBUF(118)
c     write(iprntr,*)'...now gi= ',gi

              call saver2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    itrct , 1)
              call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    irect , 1)
              call saver2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                    idi   , 1)
              call saver2(IBUF ,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                    ili   , 1)
              call saver2(IBUF ,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                    igi   , 1)
              call saver2(IBUF ,ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,
     1                    iprn  , 1)
              call saver2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                    istat , 1)
              call saver2(IBUF ,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                    idist , 1)

      if (verbos) then
      write(iprntr,*)'Rec, trc= ',irect,itrct,' stat= ',tm0
      endif

      IF ( IGRP .NE. 3 ) DI = idi
      ARRAY( INDEX + 6 )    = DI
      GI                    = igi
      ARRAY( INDEX + 7 )    = GI
      TPRI                  = DI - GI
      IF ( IGRP .EQ. 3 )
     *                 TPRI = iprn
      ARRAY( INDEX + 8 )    = TPRI
      ARRAY( INDEX + 11 )   = ili
      ARRAY( INDEX + 12 )   = idi
C
C---- IS PICK DEAD ???
      IF ( iflag .EQ. IDEAD ) GO TO 1500
C
C---- VERIFY INDICES ARE WITHIN LIMITS....
      IF ( DI .LE. DIDIM ) GO TO 1100
      WRITE (IPRNTR,1000) irect, itrct, DI, DIDIM
 1000 FORMAT(/,12X, ' ** M7201 ** ERROR DETECTED BY SUBROUTINE EVPIKR:',
     *       /,25X, 'THE DEPTH INDEX (DI) FOR RECORD ',I5,
     *       /,25X, 'TRACE ',I4,' IS ',I5,'.  THE MAXIMUM DI ALLOWED',
     *       /,25X, 'IS ',I5,'.  CHECK TRACE HEADER WORD 122 FOR',
     *       /,25X, 'ENTRIES BEYOND PROGRAM RESTRICTIONS AND EXCLUDE',
     *       /,25X, 'THOSE RECORDS BY USING THE FIRST/LAST RECORDS',
     *       /,25X, 'TO PROCESS ENTRIES (CC 31-35, 36-40).',/)
      GO TO 2900
C
 1100 IF ( GI .LE. GIDIM ) GO TO 1300
      WRITE (IPRNTR,1200) irect, itrct, GI, GIDIM
 1200 FORMAT(/,12X, ' ** M7202 ** ERROR DETECTED BY SUBROUTINE EVPIKR:',
     *       /,25X, 'THE GROUP INDEX (GI) FOR RECORD ',I5,
     *       /,25X, 'TRACE ',I4,' IS ',I5,'.  THE MAXIMUM GI ALLOWED',
     *       /,25X, 'IS ',I5,'.  CHECK TRACE HEADER WORD 118 FOR',
     *       /,25X, 'ENTRIES BEYOND PROGRAM RESTRICTIONS AND EXCLUDE',
     *       /,25X, 'THOSE RECORDS BY USING THE FIRST-LAST RECORDS',
     *       /,25X, 'TO PROCESS ENTRIES (CC 31-35, 36-40).',/)
      GO TO 2900
C
c1300 IF ( TPRI .LE. GIDIM ) GO TO 1500
 1300 IF ( TPRI .LE. GIDIM .AND. TPRI .GE. 1) GO TO 1500
      WRITE(IPRNTR,1400) irect, itrct, TPRI, GIDIM, DI, GI
 1400 FORMAT(/,12X, ' ** M7203 ** ERROR DETECTED BY SUBROUTINE EVPIKR:',
     *       /,25X, 'THE SOURCE LOCATION INDEX (SLI) FOR RECORD ',I5,
     *       /,25X, 'TRACE ',I4,' IS ',I5,'.  THE MAXIMUM SLI ALLOWED',
     *       /,25X, 'IS ',I5,'.  THE MINIMUM SLI ALLOWED IS 1.'
     *       /,25X, 'IF TWO-DIMENSIONAL PROCESSING IS',
     *       /,25X, 'REQUESTED (CC 20 = 0 OR 1), THE SOURCE',
     *       /,25X, 'LOCATION INDEX IS THE RESULTANT DIFFERENCE',
     *       /,25X, 'BETWEEN THE DEPTH INDEX (DI) AND THE GROUP INDEX',
     *       /,25X, '(GI). FOR THIS RECORD AND TRACE, THE DI (WORD',
     *       /,25X, '122) IS ',I5,' AND THE GI (WORD 118) IS ',I5,'.',
     *       /,25X, 'IF THREE-DIMENSIONAL PROCESSING IS REQUESTED',
     *       /,25X, '(CC 20 = 3), THE SOURCE LOCATION INDEX IS THE',
     *       /,25X, 'PERMANENT RECORD INDEX (WORD 110).',/)
      WRITE(IPRNTR,1450)
 1450 FORMAT(  25X, 'CHECK THE TRACE HEADER WORDS THAT VIOLATE ',
     *       /,25X, 'PROGRAM RESTRICTIONS AND EXCLUDE THOSE RECORDS',
     *       /,25X, 'BY USING THE FIRST-LAST RECORDS TO PROCESS',
     *       /,25X, 'ENTRIES (CC 31-35, 36-40).',/)

      GO TO 2900
C
C---- GET TRACE DISTANCE AND SLI
 1500 continue
      IF ( TPRI .LT. 1) iflag = IDEAD

      TRDIST = idist
      ARRAY( INDEX +  9 ) = ( TRDIST * TRDIST ) / BASESQ
      ARRAY( INDEX + 10 ) = iprn
C
C---- SET WEIGHTS TO 1.0
C---- IF WEIGHTED SOLUTION NOT WANTED....
      IF ( WEIGHT .EQ. 0)  GO TO 1600
      ARRAY( INDEX + 1 ) = 1.0
      ARRAY( INDEX + 3 ) = 1.0
      ARRAY( INDEX + 5 ) = 1.0
C
C---- IS PICK DEAD ???
 1600 IF ( iflag .EQ. IDEAD ) GO TO 1700
C
C---- SUM UP BEST PICKS...
      BSTSUM = BSTSUM + tm0
      GO TO 1800
C
C---- DECREMENT COUNTER
C---- FOR AVERAGING IF PICK IS DEAD....
 1700 LIVPIK = LIVPIK - 1
C
C---- HAVE WE LOOKED AT ALL
C---- TRACES OF A CDP FOLD YET ???
 1800 IF ( TOTPIK .LT. CFOLD ) GO TO 2000
      IF ( LIVPIK .EQ.     0 ) GO TO 1900
C
C---- COMPUTE MEAN FOR EACH
C---- CDP AND STORE IT....
      CDPMN(DI) = BSTSUM / LIVPIK
C
C---- RESET COUNTER(S), SUM AND POINTER...
      LIVPIK = 0
 1900 TOTPIK = 0
      BSTSUM = 0.0
      DI     = DI + 1
C
C---- WRITE BLOCK TO DISK
C---- (WE'RE DOING OUR OWN BLOCKED I/O)..
 2000 IF ( BLKCNT .LT. NTRBLK ) GO TO 2100
      NBLK = NBLK + 1
      CALL ELWRTE ( NBLK, ARRAY )
      BLKCNT = 0
      INDEX  = 1
      GO TO 2200
C
C---- BUMP POINTER TO NEXT DISK LOCATION....
 2100 INDEX = INDEX + NITEMS
C
C---- END OF FILE ???
 2200 IF ( MFLAG .EQ. 0 ) GO TO 600
C
C---- TRAP THE LAST RECORD NUMBER
 2300 REC2 = irect
      LBLK = NTRBLK
C
C---- HAVE WE FILLED UP ALL BLOCKS ??
      IF ( BLKCNT .EQ. 0      ) GO TO 2500
      IF ( BLKCNT .EQ. NTRBLK ) GO TO 2400
      LBLK   = BLKCNT
      IBYTES = ( NTRBLK - BLKCNT ) * ( SZSMPD * NITEMS ) ! Cray
C
C---- ZERO OUT TO END...
      CALL MOVE ( 0, ARRAY( BLKCNT * NITEMS + 1 ), 0, IBYTES )
 2400 NBLK = NBLK + 1
      CALL ELWRTE ( NBLK, ARRAY )
C
C---- READ ALL TRACE INFO FROM DISK...
 2500 DO 2800 IPNT1 = 1,NBLK
         N = NTRBLK
         IF ( IPNT1 .EQ. NBLK ) N = LBLK
         CALL ELREAD ( IPNT1, ARRAY )
C
         DO 2700 IPNT2 = 1,N
            INDEX = ( IPNT2 - 1 ) * NITEMS + 1
            DI    = ARRAY( INDEX + 6 )
C
C---- SUBTRACT OUT MEAN CDP TIME
C---- IF CDP HAS VALID PICKS....
            IF ( ARRAY( INDEX + 0 ) .EQ. -10000. ) GO TO 2700
                 ARRAY( INDEX + 0 ) = ARRAY( INDEX + 0 ) - CDPMN(DI)
            IF ( ARRAY( INDEX + 2 ) .EQ. -10000. ) GO TO 2600
                 ARRAY( INDEX + 2 ) = ARRAY( INDEX + 2 ) - CDPMN(DI)
 2600       IF ( ARRAY( INDEX + 4 ) .EQ. -10000. ) GO TO 2700
                 ARRAY( INDEX + 4 ) = ARRAY( INDEX + 4 ) - CDPMN(DI)
 2700    CONTINUE
C
C---- WRITE INFO BACK OUT...
         CALL ELWRTE ( IPNT1, ARRAY )
C
 2800 CONTINUE
C
C---- GET OUTTA HERE !!!
      RETURN
C
 2900 CALL LBCLOS ( INEVNT )
CIBM  CALL CCEXIT ( 100 )
      STOP 1030 ! Cray
c     RETURN
      END
