C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE ITERAT ( NUMBER, SUMI, SUMR, BGROUP, SMOOTH, SUMK,
     *                    NNN, IEQWLR, KUBIC, IGRP, I, R, C, M, ARRAY,
     *                    NBLK, LBLK, NTRBLK, NITEMS, GIDIM, DIDIM ,
     *                    ITRWRD, SZSMPD, SZLNHD)
C***********************************************************************
C
C     SUBROUTINE NAME: ITERAT
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: UNKNOWN
C
C     DATE WRITTEN: UNKNOWN
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                          - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: SUBROUTINE ITERATES A SPECIFIED NUMBER OF TIMES
C               THROUGH THE GAUSS-SEIDEL TECHNIQUE TO COME UP WITH
C               A SURFACE CONSISTENT SET OF INITIATION, RECEPTION,
C               STRUCTURE, AND RESIDUAL NORMAL MOVEOUT TERMS.
C
C     MODIFICATION HISTORY: ??/??/??  -  ?.?.
C
C     PARAMETERS PASSED:
C        NUMBER - NUMBER OF REMAINING ITERATIONS
C        SUMI   - SUM OF WEIGHTS FOR EACH PRI
C        SUMR   - SUM OF WEIGHTS FOR EACH GI
C        BGROUP - SHOT BETWEEN GROUP FLAG FROM 1SCOR CARD
C        SMOOTH - NUMBER OF CDP'S TO SMOOTH MOVEOUT
C        SUMK   - SUM OF WEIGHTS FOR EACH CDP
C        NNN    - ITERATION COUNTER IN ITERAT
C        IEQWLR - I = R FLAG
C        KUBIC  - REMOVE CUBIC TREND FLAG FROM 1SCOR CARD
C        IGRP   - 3D PROCESSING FLAG
C        I      - INITIATION CORRECTIONS
C        R      - RECEPTION CORRECTIONS
C        C      - STRUCTURE CORRECTIONS
C        M      - MOVEOUT CORRECTIONS
C        ARRAY  - BUFFER FOR READING DISK INFO
C        NBLK   - DISKIO BLOCK COUNTER
C        LBLK   - TOTAL NUMBER OF BLOCKS DISKIO NEEDS
C        NTRBLK - NUMBER OF TRACES PER BLOCK
C        NITEMS - NUMBER OF SAMPLES PER DISK "TRACE"
C        GIDIM  - GROUP INDEX LIMIT
C        DIDIM  - DEPTH INDEX LIMIT
C
C***********************************************************************

c#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C
      REAL    * 8 XTX(25), XTT(5), CR(5), DETER, X(6), A(6,6), XP,
     *            VALUE1, VALUE2, VALUE3, SUM, XX, WEIGHT
C
      REAL        I(12001), R(12001), C(30001), M(30001), SUMI(30001),
     *            SUMR(30001), ARRAY(8190)
C
      INTEGER     DIDIM, ITRWRD, SZSMPD, SZLNHD
      INTEGER     NUM(5), MW(5), LW(5), SUMK(DIDIM), DI, GI, TPRI,
     *            GIDIM, SMOOTH
C
      COMMON /LUNITS/ INEVNT, INPUT, OUTPUT, IPRNTR
C
      DATA DEAD/-10000./
C
      SAVE ! Cray
C
C---- DO "NUMBER" ITERATIONS TO COMPUTE I, R, C, & M
C---- ZERO OUT MATRIX BUFFER....
      DO 4900 NN = 1,NUMBER
         CALL MOVE ( 0, A, 0, 36*SZSMPD )
C
C---- I = R ??
         IF ( IEQWLR .EQ. 1 ) GO TO 600
C
C---- ZERO OUT INITIATION BUFFERS....
         CALL MOVE ( 0,    I, 0, GIDIM * SZSMPD ) ! Cray
         CALL MOVE ( 0, SUMI, 0, GIDIM * SZSMPD ) ! Cray
C
C---- READ THROUGH DATA SET..
C---- SOLVE FOR INITIATION...
         DO 200 IPNT1 = 1,NBLK
            N = NTRBLK
            IF ( IPNT1 .EQ. NBLK ) N = LBLK
            CALL ELREAD( IPNT1, ARRAY )
C
            DO 100 IPNT2 = 1,N
               INDEX  = ( IPNT2 - 1 ) * NITEMS + 1
C
C---- SEE IF PICK IS DEAD...
               IF ( ARRAY( INDEX ) .EQ. DEAD ) GO TO 100
C
C---- GET GOOD INFO...
               DI   = ARRAY( INDEX + 6 )
               GI   = ARRAY( INDEX + 7 )
               TPRI = ARRAY( INDEX + 8 )
               WEIGHT = ARRAY( INDEX + 1 )
C
               VALUE1  = R(GI)
               VALUE2  = M(DI)

c     write(0,*)'NN,IPNT1= ',NN,IPNT1,index,ARRAY(INDEX)
C
C---- SET I = 0
C---- USE GAUSS SEIDEL METHOD...
               I(TPRI) = I(TPRI) + ( ARRAY(INDEX) - VALUE1
     *                 - C(DI) - VALUE2 * ARRAY( INDEX + 9 ) ) * WEIGHT
C
C---- SUM UP WEIGHTS FOR EACH
C---- INDIVIDUAL PRI..
               SUMI(TPRI) = SUMI(TPRI) + WEIGHT
  100       CONTINUE
  200    CONTINUE
C
C---- SET VECTOR CONSTANTS FOR MATRIX
         X(1)   = 1.
         X(5)   = 0.
         NUM(1) = 1
         NUM(2) = 2
         NUM(3) = 3
         NUM(4) = 4
         NUM(5) = 6
C
C---- AVERAGE INITIATION CORRECTION
C---- DIVIDE THROUGH BY SUM OF WEIGHTS
C---- PER EACH PRI...
         DO 500 J = 1,GIDIM
            IF ( SUMI(J) .LE. 0 ) GO TO 500
            VALUE1 = SUMI(J)
            I(J)  = I(J) / VALUE1
C
C---- SET VECTOR VALUES...
            XP   = J
            XP   = XP + BGROUP - 1.0e0
            X(2) = XP
            X(3) = XP * XP
            X(4) = XP * XP * XP
            X(6) = I(J)
C
C---- SET MATRIX VALUES....
            DO 400 L = 1,5
               LI = NUM(L)
               DO 400 LL = L,5
                  LJ = NUM(LL)
  400       A(LI,LJ) = A(LI,LJ) + X(LI) * X(LJ)
  500    CONTINUE
C
C---- SOLVE FOR RECEPTION TERM
C---- ZERO RECEPTION BUFFERS...
  600    CALL MOVE ( 0,    R, 0, GIDIM * SZSMPD ) ! Cray
         CALL MOVE ( 0, SUMR, 0, GIDIM * SZSMPD ) ! Cray
C
         DO 800 IPNT1 = 1,NBLK
            N = NTRBLK
            IF ( IPNT1 .EQ. NBLK ) N = LBLK
            CALL ELREAD ( IPNT1, ARRAY )
C
            DO 700 IPNT2 = 1,N
               INDEX = ( IPNT2 - 1 ) * NITEMS + 1
C
C---- DEAD ??
               IF ( ARRAY( INDEX ) .EQ. DEAD ) GO TO 700
               DI   = ARRAY( INDEX + 6 )
               GI   = ARRAY( INDEX + 7 )
               TPRI = ARRAY( INDEX + 8 )
               WEIGHT = ARRAY( INDEX + 1 )
C
C---- SET R = 0
               VALUE1 = C(DI)
               VALUE2 = M(DI)
               VALUE3 = ARRAY(INDEX) - VALUE1
     *                 - VALUE2 * ARRAY( INDEX + 9 )
               R(GI) = R(GI) + ( VALUE3 - I(TPRI) ) * WEIGHT
C
C---- SUM UP WEIGHTS...
               SUMR(GI) = SUMR(GI) + WEIGHT
C
C---- DOES I = R ??
               IF ( IEQWLR .NE. 1 ) GO TO 700
               R(TPRI) = R(TPRI) + ( VALUE3 - I(GI) ) * WEIGHT
C
               SUMR(TPRI) = SUMR(TPRI) + WEIGHT
  700       CONTINUE
  800    CONTINUE
C
C---- IF SO, FILL INITIATION CORRECTION WITH RECEPTION CORRECTION
         IF ( IEQWLR .NE. 1 ) GO TO 1000
         DO 900 J = 1,GIDIM
            I(J)   = R(J)
            SUMI(J) = SUMR(J)
  900    CONTINUE
 1000    CONTINUE
C
C---- REMOVE CUBIC TREND ???
         IF ( KUBIC .NE. 1 ) GO TO 1500
C
C---- YES...
         DO 1400 J = 1,GIDIM
            IF ( IGRP .EQ. 3 ) GO TO 1200
C
C---- AVERAGE INITIATION VALUES...
            IF ( SUMI(J) .LE. 0 ) GO TO 1200
            VALUE1 = SUMI(J)
            I(J)   = I(J) / VALUE1
C
C---- AVERAGE RECEPTION VALUES..
 1200       IF ( SUMR(J) .LE. 0 ) GO TO 1400
            VALUE1 = SUMR(J)
            R(J)   = R(J) / VALUE1
 1400    CONTINUE
C
         GO TO 3200
C
C---- DOES I = R ???
C---- BUILD THE ROW VECTOR & THE MATRIX FOR I = R
 1500    IF ( IEQWLR .NE. 1 ) GO TO 1900
         X(1)   = 1.0e0
         X(5)   = 0.0e0
         NUM(1) = 1
         NUM(2) = 2
         NUM(3) = 3
         NUM(4) = 4
         NUM(5) = 6
C
C---- AVERAGE INITIATION VALUES...
         DO 1800 J = 1,GIDIM
            IF ( SUMI(J) .LE. 0 ) GO TO 1800
            VALUE1 = SUMI(J)
            I(J)   = I(J) / VALUE1
C
C---- SET SOME VECTOR VALUES...
            XP   = J
            XP   = XP + BGROUP - 1.0e0
            X(2) = XP
            X(3) = XP * XP
            X(4) = XP * XP * XP
            X(6) = I(J)
C
C---- SET SOME MATRIX POSITIONS...
            DO 1700 L = 1,5
               LI = NUM(L)
               DO 1700 LL = L,5
                  LJ = NUM(LL)
 1700       A(LI,LJ) = A(LI,LJ) + X(LI) * X(LJ)
 1800    CONTINUE
C
C---- SET VECTOR CONSTANTS FOR MATRIX
 1900    X(1)   = 0.0e0
         X(5)   = 1.0e0
         NUM(1) = 2
         NUM(2) = 3
         NUM(3) = 4
         NUM(4) = 5
         NUM(5) = 6
C
C---- AVERAGE RECEPTION VALUES...
         DO 2200 J = 1,GIDIM
            IF ( SUMR(J) .LE. 0 ) GO TO 2200
            VALUE1 = SUMR(J)
            R(J)   = R(J) / VALUE1
C
            VALUE1 = J
            X(2)   = VALUE1
            X(3)   = VALUE1 * VALUE1
            X(4)   = VALUE1 * VALUE1 * VALUE1
            X(6)   = R(J)
C
C---- MANIPULATE MATRIX...
            DO 2100 L = 1,5
               LI = NUM(L)
               DO 2100 LL = L,5
                  LJ= NUM(LL)
 2100       A(LI,LJ) = A(LI,LJ) + X(LI) * X(LJ)
 2200    CONTINUE
C
C---- UPPER RIGHT PORTION OF MATRIX
C---- IS FILLED, FILL REMAINDER...
         DO 2300 J = 1,6
            DO 2300 K = 1,6
 2300          A(K,J) = A(J,K)
               II = 0
C
C---- TRANSPOSE MATRIX....
         DO 2400 J = 1,5
            DO 2400 K = 1,5
               II = II + 1
               XTX(II) = A(K,J)
 2400    CONTINUE
         DO 2500 J = 1,5
            XTT(J) = A(J,6)
 2500    CONTINUE
C
C---- INVERT THE MATRIX...
         CALL DMINV ( XTX, 5, DETER, LW, MW )
C
         IF ( DETER .NE. 0 ) GO TO 2800
         WRITE(IPRNTR,2700) ( ( A(J,K),K=1,5) ,J=1,5 )
 2700 FORMAT(/,12X, ' ** M7501 ** ERROR DETECTED BY SUBROUTINE ITERAT:',
     *       /,25X, 'THE LEAST SQUARES FIT OF THE INITIATION-RECEPTION',
     *       /,25X, 'CUBIC EQUATION HAS FAILED.  ENSURE THAT THE',
     *       /,25X, 'FIRST-LAST RECORDS TO PROCESS RECORD NUMBERS',
     *       /,25X, 'USED TO GENERATE THE EVENT TAPE CORRESPOND TO THE',
     *       /,25X, 'FIRST-LAST RECORDS TO PROCESS ENTRIES (CC 31-35, ',
     *              '36-40).',/,(5X,5D12.6) )
CIBM     CALL CCEXIT ( 100 )
         STOP 1050 ! Cray
C
C---- FIND THE SOLUTION ("CR" CONTAINS A0, A1, A2, A3, B0)
C
 2800    CALL DGMPRD ( XTX, XTT, CR, 5, 5, 1 )
C
C---- SOLVE FOR INITIATION CORRECTION
C---- AND RECEPTION CORRECTION...
         DO 3000 J = 1,GIDIM
            IF ( SUMI(J) .EQ. 0. ) GO TO 2900
            XP   = J
            XP   = XP + BGROUP - 1.0D0
            I(J) = I(J) -
     *             ( CR(1) + CR(2) * XP + CR(3) * XP * XP + CR(4)
     *               * XP * XP * XP )
C
 2900       IF ( SUMR(J) .EQ. 0. ) GO TO 3000
            XP   = J
            R(J) = R(J) -
     *             ( CR(2) * XP + CR(3) * XP * XP + CR(4)
     *               * XP * XP * XP + CR(5) )
 3000    CONTINUE
C
C--- DOES I = R ??
         IF ( IEQWLR .NE. 1 ) GO TO 3200
         DO 3100 J = 1,GIDIM
            I(J) = R(J)
 3100    CONTINUE
C
C---- SOLVE FOR STRUCTURE
 3200 CALL MOVE (0,    C, 0, DIDIM * SZSMPD ) ! Cray
      CALL MOVE (0, SUMI, 0, DIDIM * SZSMPD ) ! Cray
C
C---- READ THROUGH THE ENTIRE DATA SET
         DO 3400 IPNT1 = 1,NBLK
            N = NTRBLK
            IF ( IPNT1 .EQ. NBLK ) N = LBLK
            CALL ELREAD ( IPNT1, ARRAY )
C
            DO 3300 IPNT2 = 1,N
               INDEX = ( IPNT2 - 1 ) * NITEMS + 1
C
C---- DEAD ???
               IF ( ARRAY(INDEX) .EQ. DEAD ) GO TO 3300
               DI     = ARRAY( INDEX + 6 )
               GI     = ARRAY( INDEX + 7 )
               TPRI   = ARRAY( INDEX + 8 )
               WEIGHT = ARRAY( INDEX + 1 )
C
C---- C = 0
               VALUE1 = I(TPRI)
               VALUE2 = M(DI)
               C(DI)  = C(DI) + (ARRAY(INDEX) - VALUE1 - R(GI)
     *                  - VALUE2 * ARRAY( INDEX + 9 ) ) * WEIGHT
C
C---- SUM UP WEIGHTS PER CDP...
               SUMI(DI) = SUMI(DI) + WEIGHT
 3300       CONTINUE
 3400    CONTINUE
C
C---- AVERAGE THE STRUCTURE VALUES...
         DO 3500 J = 1,DIDIM
            IF ( SUMI(J) .EQ. 0. ) GO TO 3500
            VALUE1 = SUMI(J)
            C(J)   = C(J) / VALUE1
 3500    CONTINUE
C
C---- SOLVE FOR RNMO...
         CALL MOVE ( 0,   M, 0, DIDIM * SZSMPD ) ! Cray
         CALL MOVE ( 0, SUMK, 0, DIDIM * SZSMPD ) ! Cray
         CALL MOVE ( 0, SUMR, 0, DIDIM * SZSMPD ) ! Cray
C
C---- READ THROUGH ENTIRE DATA SET
         DO 3700 IPNT1 = 1,NBLK
            N = NTRBLK
            IF ( IPNT1 .EQ. NBLK ) N = LBLK
            CALL ELREAD ( IPNT1, ARRAY )
C
            DO 3600 IPNT2 = 1,N
               INDEX = ( IPNT2 - 1 ) * NITEMS + 1
C
               IF ( ARRAY(INDEX) .EQ. DEAD ) GO TO 3600
               DI     = ARRAY( INDEX + 6 )
               GI     = ARRAY( INDEX + 7 )
               TPRI   = ARRAY( INDEX + 8 )
               WEIGHT = ARRAY( INDEX + 1 )
               XX     = ARRAY( INDEX + 9 )
C
C---- M = 0
               VALUE1 = I(TPRI)
               M(DI)  = M(DI) + ( ARRAY(INDEX)
     *                  - VALUE1 - R(GI) - C(DI) ) * XX * WEIGHT
C
C---- HOW MUCH AND HOW MANY ???
               SUMR(DI) = XX * XX * WEIGHT + SUMR(DI)
               SUMK(DI) = SUMK(DI) + 1
 3600       CONTINUE
 3700    CONTINUE
C
C---- AVERAGE THE RNMO TERM
         K = 0
         DO 4000 J = 1,DIDIM
            IF ( SUMK(J) .EQ.  0 ) GO TO 4000
            IF ( SUMR(J) .NE. 0.0 ) GO TO 3900
            WRITE(IPRNTR,3800) J, SUMK(J)
 3800 FORMAT(/,12X, ' ** M7502 ** WARNING FROM SUBROUTINE ITERAT:',
     *       /,25X, 'THERE ARE NO USABLE TRACES AVAILABLE FOR',
     *       /,25X, 'COMPUTING THE RESIDUAL NORMAL MOVEOUT FOR',
     *       /,25X, 'DEPTH INDEX ',I5,'.  THERE ARE ',I5,' LIVE',
     *       /,25X, 'TRACES BUT THE TRACE DISTANCE AND/OR WEIGHT',
     *       /,25X, 'FOR EACH TRACE IS ZERO, RESULTING IN A MOVEOUT ',
     *       /,25X, 'CORRECTION OF ZERO.  IF THIS IS UNSATISFACTORY,',
     *       /,25X, 'EDIT THE TIMES AND WEIGHTS ON THE EVENT TAPE.',/)
            GO TO 4000
C
 3900       K       = K + 1
            VALUE1  = SUMR(J)
            SUMR(K) = M(J) / VALUE1
            SUMK(K) = J
 4000    CONTINUE
C
C---- SMOOTH THE RNMO TERM (BOX-CAR FILTER)
         IF ( SMOOTH .LE. K ) GO TO 4200
         J      = SMOOTH
         SMOOTH = K
C
C---- ODD OR EVEN NUMBER OF CDP'S ???
         IF ( ( ( K / 2 ) * 2 ) .EQ. K ) SMOOTH = SMOOTH - 1
         WRITE(IPRNTR,4100) J, K, SMOOTH
 4100 FORMAT (/,12X, ' ** M7503 ** WARNING FROM SUBROUTINE ITERAT:',
     *        /,25X, 'THE SMOOTHING FUNCTION WAS REQUESTED TO',
     *        /,25X, 'HAVE ',I5,' POINTS, BUT THIS JOB CONTAINS ',I5,
     *        /,25X, 'VALID DEPTH INDEX (DI) VALUES.  THEREFORE, THE',
     *        /,25X, 'NUMBER OF POINTS IN THE SMOOTHING FUNCTION WILL',
     *        /,25X, 'BE CHANGED TO ',I5,' POINTS.  IF THIS IS',
     *        /,25X, 'UNSATISFACTORY, AMEND THIS ENTRY (CC 27-30).',//)
C
 4200    NPT = SMOOTH / 2
         KPT = 1 - NPT
         IPT = NPT
         SUM = 0.0
C
C---- COMPUTE SUM OVER 1/2 USER SPECIFIED POINTS...
         IF ( NPT .EQ. 0 ) GO TO 4400
         DO 4300 J = 1,NPT
 4300    SUM = SUM + SUMR(J)
C
C---- DO A RUNNING SUM NOW...
 4400    DO 4700 J = 1,K
            IPT = IPT + 1
            IF ( IPT .GT. K ) GO TO 4500
            SUM =  SUM + SUMR(IPT)
            NPT =  NPT + 1
C
C---- WITH AN AVERAGE...
 4500       M(SUMK(J)) = SUM / NPT
            IF ( KPT .LT. 1 ) GO TO 4600
            SUM = SUM - SUMR(KPT)
            NPT = NPT - 1
 4600       KPT = KPT + 1
 4700    CONTINUE
C
C---- COMPUTE ERROR AFTER EACH ITERATION...
         CALL ERRCAL ( RMS, I, R, C, M, ARRAY, NBLK, LBLK, NTRBLK,
     *                 NITEMS )
C
      WRITE (IPRNTR,4800) NNN, RMS
 4800 FORMAT(32X,'     RMS ERROR OF PICKS AFTER ITERATING ',I2,
     *           ' TIME(S)',F10.3,'     ')
C
         NNN = NNN + 1
 4900 CONTINUE
C
C---- LET'S BOOGIE....
      RETURN
      END
