C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE PRNTEM ( IGMIN, IGMAX, IPMIN, IPMAX, ISEND, ISTAT,
     *                    ICORR )
C***********************************************************************
C
C     SUBROUTINE NAME: PRNTEM
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: CREATED FROM IN-LINE CODE
C
C     DATE WRITTEN: 12/01/84 ( MADE INTO SUBROUTINE )
C
C     AMOCO PRODUCTION CO. PROPRIETARY
C                          - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: SUBROUTINE PRNTEM GIVES A VISUAL DISPLAY
C               OF THE COMPUTED STATIC CORRECTIONS IN 8STAT
C               AND 9CORR CARD IMAGES.  THESE CARD IMAGES
C               CAN OPTIONALLY BE PUNCHED TO A VM MACHINE.
C
C     MODIFICATION HISTORY: ??/??/??  E.ANDES    INITIAL RELEASE
C                           01/19/87  E.ANDES
C                                     REDIMENSION IBLNK ARRAY TO
C                                     7 ELEMENTS INSTEAD OF 6.
C                                     PUT A RETURN AFTER 9CORR LOOP
C                                     TO PREVENT LAST 9CORR CARD FROM
C                                     BEING DUPLICATED WHEN FULL.
C
C     PARAMETERS PASSED:
C        IGMIN  - MIN LIVE GI
C        IGMAX  - MAX LIVE GI
C        IPMIN  - MIN LIVE PRI
C        IPMAX  - MAX LIVE PRI
C        ISEND  - FLAG TO SEND CARDS TO VM MACHINE
C        ISTAT  - CONTAINS RECEPTION STATICS
C        ICORR  - CONTAINS INITIATION STATICS
C
C***********************************************************************

#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

C
C     REAL    * 8 IFORMA(4), IFORMB(4)
      CHARACTER IFORMA*80, IFORMB*80, STAT*4, CORR*4
C
      INTEGER * 4 POINT1, POINT2, HOWMNY, ISTAT(12001), ICORR(12001),
     *            OUTPUT
C
      INTEGER * 2 IBLNK(7)
C
C     LOGICAL * 1 DIGIT(9), IFORM1(32), IFORM2(32)
      CHARACTER*1 DIGIT(9), IFORM1(80), IFORM2(80)
C
C     EQUIVALENCE ( IFORMA(1), IFORM1(1) ), ( IFORMB(1), IFORM2(1) )
      EQUIVALENCE ( IFORMA,    IFORM1(1) ), ( IFORMB,    IFORM2(1) )
C
      COMMON /LUNITS/ INEVNT, INPUT, OUTPUT, IPRNTR
C
      DATA ITYPE/0/, DIGIT/'1','2','3','4','5','6','7','8','9'/,
C    * IFORMA/'(25X,A1,','A4,  1X,',' I7, A7,','13X,I5) '/,
     * IFORMA/'(25X,A1,'','',A4,1X,'','',I7,A7,'','',13X,I5) '/,
C    * IFORMB/'(A1,','A4,  1X,',' I7, A7,','13X,I5) '/,
     * IFORMB/'(A1,'','',A4,1X,'','',I7,A7,'','',13X,I5) '/,
     * STAT/'STAT'/, CORR/'CORR'/, IBLNK/7*'  '/
C
C     EQUIVALENCE ( IFORMA(1), IFORM1(1) ), ( IFORMB(1), IFORM2(1) )
C
C
      SAVE ! Cray
C
      ISTAT( IGMAX + 1 ) = 9999900
      ICORR( IPMAX + 1 ) = 9999900
C
C---- PRINT THE STATIC CARD IMAGES...
      WRITE (IPRNTR,100)
  100 FORMAT('1',48X, '8STAT & 9CORR STATICS CARD IMAGES',
     *        / ,32X, '(NOTE: IMPLIED DECIMALS BETWEEN CC 11-12, ',
     *                'CC 18-19, ..., CC 60-61)', ///
c    *          ,25X, '         1         2         3         4',
     *          ,     '         1         2         3         4',
     *                '         5         6         7         8',
c    *         /,25X, '----+----0----+----0----+----0----+----0',
     *         /,     '----+----0----+----0----+----0----+----0',
     *                '----+----0----+----0----+----0----+----0')
C
C---- SEE HOW MANY 8STAT CARDS TO PRINT...
      NCARDS = ( ( ( ( ( IGMAX + 1 ) - IGMIN ) + 1 ) + 7 ) / 8 )
      IEND   = IGMIN - 1
C
      DO 400 J  = 1,NCARDS
C
C---- DETERMINE STARTING AND ENDING GI NUMBER...
         IBEGIN = IEND + 1
         IEND   = IBEGIN + 7
C
C---- IS THE LAST CARD FULL ??
         NUMBER = ( ( IGMAX + 1 ) - IBEGIN ) + 1
         IF ( J .EQ. NCARDS
     *          .AND. NUMBER .LT. 8 ) GO TO 450
C
C---- DO CARDS NEED TO BE PUNCHED ???
C        IF ( ISEND .EQ. 1 )
C    *        WRITE (13,200) DIGIT(8), STAT, (ISTAT(I),I=IBEGIN,IEND),
C    *                       IBEGIN
c 200    FORMAT(    A1, A4,  1X,    8I7, 13X,I5 )
C
C---- WRITE ON PAPER...
         WRITE (IPRNTR,300) DIGIT(8), STAT, (ISTAT(I),I=IBEGIN,IEND),
     *                      IBEGIN
  300    FORMAT(A1, A4,  1X,   8I7, 13X,I5 )
  400 CONTINUE
      GO TO 500
C
C---- SET STATIC DELIMITER...
  450 CONTINUE
      INUM = IGMAX
      GO TO 700
C
C---- SEE HOW MANY 9CORR CARDS TO PRINT...
  500 NCARDS = ( ( ( ( ( IPMAX + 1 ) - IPMIN ) + 1 ) + 7 ) / 8 )
      IEND   = IPMIN - 1
      ITYPE  = 1
C
      DO 600 J = 1,NCARDS
C
C---- DETERMINE STARTING AND ENDING PRI NUMBER...
         IBEGIN = IEND + 1
         IEND   = IBEGIN + 7
C
C---- IS THE LAST CARD FULL ??
         NUMBER = ( ( IPMAX + 1 ) - IBEGIN ) + 1
         IF ( J .EQ. NCARDS
     *          .AND. NUMBER .LT. 8 ) GO TO 650
C
C---- DO CARDS NEED TO BE PUNCHED ???
C        IF ( ISEND .EQ. 1 )
C    *        WRITE (13,200) DIGIT(9), CORR, (ICORR(I),I=IBEGIN,IEND),
C    *                       IBEGIN
C
C---- WRITE ON PAPER...
         WRITE (IPRNTR,300) DIGIT(9), CORR, (ICORR(I),I=IBEGIN,IEND),
     *                      IBEGIN
  600 CONTINUE
C
C---- NO PARTIAL 9CORR CARD, GET OUT...
      RETURN
C
C---- SET STATIC DELIMITER...
  650 INUM   = IPMAX
C
  700 POINT1 = IEND - 7
C
C---- SEE HOW MANY STATIC VALUES
C---- AND HOW MANY BLANKS NEED TO BE PRINTED...
      HOWMNY = ( INUM + 1 ) - POINT1 + 1
      POINT2 = POINT1 + HOWMNY - 1
      LENBLK = 8 - HOWMNY
C
      IF ( ITYPE .EQ. 1 ) GO TO 800
C
C---- PLUG INFO INTO FORMAT STATEMENT...
      WRITE (IFORMA,'(A,I2,A)')
     *  '(    A1,A4,1X,',HOWMNY,'I7,T76 ,I5)'
c    *  '(25X,A1,A4,1X,',HOWMNY,'I7,T101,I5)'
C     IFORM1(17) = DIGIT(HOWMNY)
C     IFORM1(21) = DIGIT(LENBLK)
C
C---- DO THEY NEED TO BE PUNCHED ??
      IF ( ISEND .NE. 1 ) GO TO 750
C     IFORM2(17) = DIGIT(HOWMNY)
C     IFORM2(21) = DIGIT(LENBLK)
C     WRITE (13,IFORMB) DIGIT(8), STAT, (ISTAT(I),I=POINT1,POINT2),
C    *                  (IBLNK(J),J=1,LENBLK), POINT1
  750 CONTINUE
      WRITE (IPRNTR,IFORMA) DIGIT(8), STAT, (ISTAT(I),I=POINT1,POINT2),
     *                      POINT1
C                           (IBLNK(J),J=1,LENBLK), POINT1
      GO TO 500
C
  800 CONTINUE
      WRITE (IFORMA,'(A,I2,A)')
     *  '(A1,A4,1X,',HOWMNY,'I7,T76 ,I5)'

c    *  '(A1,A4,1X,',HOWMNY,'I7,T101,I5)'
C     IFORM1(17) = DIGIT(HOWMNY)
C     IFORM1(21) = DIGIT(LENBLK)
C
C---- DO THEY NEED TO BE PUNCHED ??
      IF ( ISEND .NE. 1 ) GO TO 900
C     IFORM2(17) = DIGIT(HOWMNY)
C     IFORM2(21) = DIGIT(LENBLK)
C     WRITE (13,IFORMB) DIGIT(9), CORR, (ICORR(I),I=POINT1,POINT2),
C    *                  (IBLNK(J),J=1,LENBLK), POINT1
  900 CONTINUE
      WRITE (IPRNTR,IFORMA) DIGIT(9), CORR, (ICORR(I),I=POINT1,POINT2),
     *                      POINT1

C                           (IBLNK(J),J=1,LENBLK), POINT1
C
      RETURN
      END
