C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE FILTI(MAXL,ITW,TDEL,DB,F1,F2,F3,F4,BUF,LF,F)           FIL01000
C     A CONFIDENTIAL AMOCO SUBROUTINE                                   FIL02000
C                          FORTRAN BY KEN PEACOCK 2-25-80.              FIL03000
C     FILTI COMSTRUCTS FILTER OPERATORS AFTER COMPUTING THE PROPER      FIL04000
C     FILTER LENGTH AND WEIGHTING STRENGTH.                             FIL05000
C     INPUTS ARE...                                                     FIL06000
C        MAXL, LIMIT LENGTH FOR F AND BUF ARRAYS, IF FILTER LENGTH      FIL07000
C             EXCEEDS MAXL, LF IS SET TO MAXL.                          FIL08000
C        ITW, TYPE OF WEIGHTING.  ITW .EQ. 1 MEANS ROSS.  ITW .EQ. 2    FIL09000
C             MEANS BESSEL.                                             FIL10000
C        TDEL, SAMPLE INCREMENT IN SECONDS.                             FIL11000
C        DB, DESIRED LEVEL OF ATTENUATION OUTSIDE RANGE F1-F4, E.G. 60. FIL12000
C           (ALSO IS ACCURACY INSIDE RANGE F2-F3).                      FIL13000
C        F1, FIRST FREQUENCY FOR FILTER RESPONSE.                       FIL14000
C        F2, SECOND FREQUENCY FOR FILTER RESPONSE.                      FIL15000
C        F3, THIRD FREQUENCY FOR FILTER RESPONSE.                       FIL16000
C        F4, FOURTH FREQUENCY FOR FILTER RESPONSE.                      FIL17000
C     BUFFER IS...                                                      FIL18000
C             BUF, LF LENGTH BUFFER.                                    FIL19000
C     OUTPUTS ARE...                                                    FIL20000
C        LF, LENGTH FOR OPERATOR, LF .EQ. MAXL MEANS SHORTENED OPERATOR.FIL21000
C        F, THE OUTPUT OPERATOR.                                        FIL22000
C     PROGRAMMED FOR THE IBM 370/168 COMPUTER.                          FIL23000
C     VERSION AS OF 2-25-80.                                            FIL24000
C     VERSION AS OF 2-20-84.                                            FIL25000
C     VERSION AS OF 10-31-84                                            FIL26000
C                                                                       FIL27000
      DIMENSION F(1),BUF(1)                                             FIL28000
      IF(F3.EQ.0.) GO TO 1                                              FIL31000
      FREQ2 = (F3+F4)/2.                                                FIL32000
      EX = -1.2667+.0064994*DB**1.703                                   FIL33000
      IF(ITW.EQ.2) EX = -7.4901+1.6808*DB**.505                         FIL34000
      IF(EX.LT.0) EX = 0.                                               FIL35000
      LF2=(-.30864+.012374*DB**1.5080)/(TDEL*(F4-F3))                   FIL36000
      IF(ITW.EQ.2)LF2=(-.58164+.076399*DB**.983)/(TDEL*(F4-F3))         FIL37000
      IF(LF2.GT.MAXL) LF2 = MAXL                                        FIL38000
      LF2 = LF2/2*2+1                                                   FIL39000
      GO TO (10,11), ITW                                                FIL42000
   10 CALL IDEF(FREQ2,TDEL,EX,LF2,F)                                    FIL43000
      GO TO 2                                                           FIL44000
   11 CALL IDEF2(FREQ2,TDEL,EX,LF2,F)                                   FIL45000
      GO TO 2                                                           FIL46000
    1 LF2 = 1                                                           FIL47000
      F(1) = 1./TDEL                                                    FIL48000
    2 IF(F2.EQ.0.) GO TO 13                                             FIL49000
      FREQ1 = (F1+F2)/2.                                                FIL50000
      LF1=(-.30864+.012374*DB**1.5080)/(TDEL*(F2-F1))                   FIL51000
      IF(ITW.EQ.2)LF1=(-.58164+.076399*DB**.983)/(TDEL*(F2-             FIL52000
     *F1))                                                              FIL53000
      IF(LF1.GT.MAXL) LF1 = MAXL                                        FIL54000
      LF1 = LF1/2*2+1                                                   FIL55000
      GO TO (30,31), ITW                                                FIL58000
   30 CALL IDEF(FREQ1,TDEL,EX,LF1,BUF)                                  FIL59000
      GO TO 63                                                          FIL60000
   31 CALL IDEF2(FREQ1,TDEL,EX,LF1,BUF)                                 FIL61000
   63 IF(LF1-LF2)7,3,3                                                  FIL62000
    3 LF = LF1                                                          FIL63000
      DO 4 I=1,LF                                                       FIL64000
    4 BUF(I) = -BUF(I)                                                  FIL65000
      ISTA = LF1/2-LF2/2+1                                              FIL66000
      ISTO = LF2+ISTA-1                                                 FIL67000
      DO 5 I=ISTA,ISTO                                                  FIL68000
      J = I+1-ISTA                                                      FIL69000
    5 BUF(I) = F(J)+BUF(I)                                              FIL70000
      DO 6 I=1,LF                                                       FIL71000
    6 F(I) = BUF(I)                                                     FIL72000
      GO TO 14                                                          FIL73000
    7 LF = LF2                                                          FIL74000
      ISTA = LF2/2-LF1/2+1                                              FIL75000
      ISTO = LF1+ISTA-1                                                 FIL76000
      DO 8 I=ISTA,ISTO                                                  FIL77000
      J = I+1-ISTA                                                      FIL78000
    8 F(I) = F(I)-BUF(J)                                                FIL79000
      GO TO 14                                                          FIL80000
   13 LF = LF2                                                          FIL81000
   14 RETURN                                                            FIL82000
      END                                                               FIL83000
