C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE INTD(LX,X,IFC,TDEL,WC,LF,F,Y)
C                            FORTRAN BY KEN PEACOCK  10-15-76
C     SUBROUTINE INTD INTEGRATES THE INPUT ARRAY BY COMBINING THE
C     RUNNING SUM WITH A SPECIAL RESIDUAL OPERATOR.  NOTE THE SPECIAL
C     Y DIMENSION REQUIREMENT.  SUBROUTINE SICI IS IN IBM'S SSP LIBRARY.
C     SUBROUTINE FOLD IS IN THE BOOK BY ROBINSON, E. A., 1967,
C     MULTICHANNEL TIME SERIES WITH DIGITAL COMPUTER PROGRANS: HOLDEN
C     DAY, SAN FRANCISCO.
C        INPUTS ARE...
C             LX, LENGTH OF X.
C             X, THE INPUT ARRAY.
C             IFC, .NE. 0 MEANS TO CONSTRUCT RESIDUAL OPERATOR.  IFC
C                  MUST BE .NE. 0 ON FIRST CALL BUT CAN BE ON SUBSEQUENT
C                  PROVIDING THAT MAIN DOES NOT DISTURB F.
C             TDEL, SAMPLE INCREMENT IN SECONDS.
C             WC, 0. MEANS TO OUTPUT RAW OPERATOR, .NE.0. MEANS TO USE
C                  A ROSS WEIGHT FUNCTION WITH EXPONENT WC.
C             LF, LENGTH OF FILTER IN SAMPLES, LF MUST BE ODD.
C        OUTPUTS ARE...
C             F, THE LF LENGTH RESIDUAL OPERATOR.
C             Y, THE LX-LENGTH OUTPUT.  Y MUST BE DIMENSIONED TO AT
C                  LEAST LX+LF-1.
C     CODED FOR THE IBM 370/158 COMPUTER.
C     VERSION AS OF 6-2-83.
C
      DIMENSION X(1),F(1),Y(1)
      IF(IFC.EQ.0) GO TO 3
      N = LF/2
      ISTA = N+2
      KFACT = 1-ISTA
      JFACT = LF+1
      PID2 = 3.1415927/2.
      DO 1 I=ISTA,LF
      AK = I+KFACT
      CALL SICI(F(I),CON,AK*3.1415927)
C
C     CALL SIKLP(AK*3.1415927,F(I))
C
      F(I) = (F(I)+PID2)/3.1415927-.5
      J = JFACT-I
    1 F(J) = -F(I)
C     CALL GRQ1T(1.,1.,LF,F)
      F(ISTA-1) = -.5
      IF(WC.EQ.0.) GO TO 3
      DO 2 I=ISTA,LF
      AK = I+KFACT
      F(I) = F(I)*((1.-(AK/N)**2)**WC)
      J = JFACT-I
    2 F(J) = -F(I)
    3 CALL FOLD(LX,X,LF,F,LO,Y)
      RUNSUM = 0.
      DO 4 I=1,LX
      RUNSUM = RUNSUM+X(I)
      J = I+N
    4 Y(I) = TDEL*(RUNSUM+Y(J))
      RETURN
      END
