C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE KAISER(WC,LW,W)                                        KAI01000
C        A CONFIDENTIAL AMOCO SUBROUTINE                                KAI02000
C             FORTRAN BY KEN PEACOCK  (DATE UNKNOWN)                    KAI03000
C     KAISER COMPUTES A 2-SIDED BESSEL WEIGHT FUNCTION.                 KAI04000
C     INPUTS ARE...                                                     KAI05000
C        WC, STRENGTH OF WEIGHTING, A VALUE ABOUT 4 YIELDS TYPICAL      KAI06000
C           WEIGHT STRENGTH.                                            KAI07000
C        LW, LENGTH OF OUTPUT ARRAY.                                    KAI08000
C     OUTPUT IS...                                                      KAI09000
C        W, THE LW-LENGTH BESSEL FUNCTION.                              KAI10000
C     CODED FOR THE IBM 3090.                                           KAI11000
C     VERSION AS OF 2-2-86.                                             KAI12000
C                                                                       KAI13000
      DIMENSION W(1)                                                    KAI14000
      N = LW/2                                                          KAI15000
      CALL INO(WC,DEN)                                                  KAI16000
      KSTA = N+2                                                        KAI17000
      DO 10 K = KSTA,LW                                                 KAI18000
      GE = WC*SQRT(abs(1.-(float(K+1-KSTA)/float(N))**2))
      CALL INO(GE,E)                                                    KAI20000
   10 W(K) = E/DEN                                                      KAI21000
      DO 20 I=1,N                                                       KAI22000
      K = N+1+I                                                         KAI23000
      J = N+1-I                                                         KAI24000
   20 W(J) = W(K)                                                       KAI25000
      W(N+1) = 1.                                                       KAI26000
      RETURN                                                            KAI27000
      END                                                               KAI28000
